/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.assignment;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Variable;

public class PhpReplaceableAssignmentCondition
implements Condition<AssignmentExpression> {
    private final TokenSet myReplaceableOperatorTypes;
    private final TokenSet myCommutativeOperatorTypes;
    private final Condition<? super PsiElement> myRightOperandCondition;

    public PhpReplaceableAssignmentCondition(TokenSet replaceableOperatorTypes, TokenSet commutativeOperatorTypes) {
        this(replaceableOperatorTypes, commutativeOperatorTypes, (Condition<? super PsiElement>)Conditions.alwaysTrue());
    }

    public PhpReplaceableAssignmentCondition(TokenSet replaceableOperatorTypes, TokenSet commutativeOperatorTypes, Condition<? super PsiElement> rightOperandCondition) {
        this.myReplaceableOperatorTypes = replaceableOperatorTypes;
        this.myCommutativeOperatorTypes = commutativeOperatorTypes;
        this.myRightOperandCondition = rightOperandCondition;
    }

    public boolean value(AssignmentExpression assignment) {
        if (assignment instanceof SelfAssignmentExpression) {
            return false;
        }
        PhpPsiElement value = assignment.getValue();
        if (!(value instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression expression = (BinaryExpression)value;
        IElementType operatorType = expression.getOperationType();
        if (!this.myReplaceableOperatorTypes.contains(operatorType)) {
            return false;
        }
        PhpPsiElement variable = assignment.getVariable();
        if (variable == null) {
            return false;
        }
        String variableName = variable.getName();
        if (variableName == null) {
            return false;
        }
        PsiElement leftOperand = expression.getLeftOperand();
        PsiElement rightOperand = expression.getRightOperand();
        if (this.myCommutativeOperatorTypes.contains(operatorType)) {
            return this.appropriateOperands(variableName, leftOperand, rightOperand) || this.appropriateOperands(variableName, rightOperand, leftOperand);
        }
        return this.appropriateOperands(variableName, leftOperand, rightOperand);
    }

    private boolean appropriateOperands(String variableName, PsiElement leftOperand, PsiElement rightOperand) {
        return PhpReplaceableAssignmentCondition.variableWithName(leftOperand, variableName) && this.myRightOperandCondition.value((Object)rightOperand);
    }

    public static boolean variableWithName(PsiElement element, String variableName) {
        if (!(element instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)element;
        return PhpLangUtil.equalsVariableNames(variableName, variable.getNameCS());
    }
}

