/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.roots.PhpDirectoryProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPsrDirectoryComboBox
extends ComboboxWithBrowseButton {
    private final Project myProject;
    private PhpDirectoryProvider myDirectoryProvider;
    private final String myProjectBasePath;
    protected VirtualFile myBaseDir;
    protected String myBaseNamespace;
    private ItemWrapper myInitialItem;
    private Condition<VirtualFile> myDirectoriesFilter;

    public PhpPsrDirectoryComboBox(@NotNull Project project) {
        if (project == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(0);
        }
        this(project, PhpDirectoryByPsrProvider.getDefaultProvider());
    }

    public PhpPsrDirectoryComboBox(@NotNull Project project, @NotNull PhpDirectoryProvider provider) {
        VirtualFile projectParent;
        if (project == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(2);
        }
        super((JComboBox)new ComboBoxWithWidePopup());
        this.myDirectoriesFilter = Conditions.alwaysTrue();
        this.myProject = project;
        this.myDirectoryProvider = provider;
        VirtualFile projectDir = project.getBaseDir();
        this.myProjectBasePath = projectDir != null ? ((projectParent = projectDir.getParent()) == null ? "" : projectParent.getPresentableUrl()) : "";
    }

    public void init(final @NotNull VirtualFile baseDir, @NotNull String namespace) {
        if (baseDir == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(3);
        }
        if (namespace == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(4);
        }
        this.myBaseNamespace = namespace;
        this.myBaseDir = baseDir;
        String path = this.myBaseDir.getPresentableUrl();
        this.myInitialItem = this.addDirectory(this.getComboBox(), path, this.myBaseDir);
        this.setTextFieldPreferredWidth(path.length());
        final JComboBox comboBox = this.getComboBox();
        final FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        BasicComboBoxEditor editor = new BasicComboBoxEditor(){
            private ItemWrapper mySelectedItem;

            @Override
            public void setItem(Object anObject) {
                if (anObject instanceof ItemWrapper) {
                    this.mySelectedItem = (ItemWrapper)anObject;
                    this.editor.setText(((ItemWrapper)anObject).getFullPresentablePath());
                }
            }

            @Override
            public Object getItem() {
                String newPath = StringUtil.trimEnd((String)this.editor.getText(), (String)File.separator);
                if (PhpPsrDirectoryComboBox.this.myInitialItem != null && StringUtil.equals((CharSequence)newPath, (CharSequence)PhpPsrDirectoryComboBox.this.myInitialItem.getFullPresentablePath())) {
                    this.mySelectedItem = PhpPsrDirectoryComboBox.this.myInitialItem;
                } else if (this.mySelectedItem == PhpPsrDirectoryComboBox.this.myInitialItem) {
                    this.mySelectedItem = PhpPsrDirectoryComboBox.this.addDirectory(PhpPsrDirectoryComboBox.this.getComboBox(), newPath, PhpPsrDirectoryComboBox.findExistingParent(newPath));
                } else {
                    this.mySelectedItem.updatePath(newPath, PhpPsrDirectoryComboBox.findExistingParent(newPath));
                }
                comboBox.setSelectedItem(this.mySelectedItem);
                return this.mySelectedItem;
            }

            @Override
            protected JTextField createEditorComponent() {
                JTextField field = super.createEditorComponent();
                FileChooserFactory.getInstance().installFileCompletion(field, descriptor, false, (Disposable)PhpPsrDirectoryComboBox.this.myProject);
                return field;
            }
        };
        editor.getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                comboBox.setEditable(false);
            }
        });
        comboBox.setEditor(editor);
        comboBox.setRenderer(new ListCellRendererWrapper<ItemWrapper>(){

            public void customize(JList list, ItemWrapper itemWrapper, int index, boolean selected, boolean hasFocus) {
                this.setText(itemWrapper.getPresentablePath());
                this.setIcon(itemWrapper.getIcon((FileIndex)ProjectRootManager.getInstance((Project)PhpPsrDirectoryComboBox.this.myProject).getFileIndex()));
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)PhpPsrDirectoryComboBox.this.myProject, (VirtualFile)baseDir);
                if (file != null) {
                    String path = file.getPresentableUrl();
                    JComboBox comboBox = PhpPsrDirectoryComboBox.this.getComboBox();
                    ItemWrapper item = PhpPsrDirectoryComboBox.this.addDirectory(comboBox, path, file);
                    comboBox.setSelectedItem(item);
                }
            }
        });
        comboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    comboBox.setEditable(true);
                }
            }
        });
    }

    public void setDirectoriesFilter(@NotNull Condition<VirtualFile> filter) {
        if (filter == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(5);
        }
        this.myDirectoriesFilter = filter;
    }

    public void setDirectoryProvider(@NotNull PhpDirectoryProvider directoryProvider) {
        if (directoryProvider == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(6);
        }
        this.myDirectoryProvider = directoryProvider;
    }

    public String getSelectedPath() {
        Object item = this.getComboBox().getSelectedItem();
        return ((ItemWrapper)item).getFullIndependentPath();
    }

    @Nullable
    public VirtualFile getExistingParent() {
        Object item = this.getComboBox().getSelectedItem();
        return ((ItemWrapper)item).getExistingParent();
    }

    public String getRelativePath() {
        Object item = this.getComboBox().getSelectedItem();
        return ((ItemWrapper)item).getRelativePath();
    }

    @NotNull
    public List<String> suggestDirectories(@NotNull String namespace) {
        if (namespace == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(7);
        }
        List<String> list = this.myDirectoryProvider.suggestDirectories(this.myProject, namespace, this.myBaseDir, this.myBaseNamespace);
        if (list == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void updateDirectories(@NotNull String namespace) {
        List<String> directories;
        if (namespace == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(9);
        }
        if (!(directories = this.suggestDirectories(namespace)).isEmpty()) {
            this.updateDirectories(directories);
        }
    }

    private void updateDirectories(@NotNull Collection<String> directories) {
        if (directories == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(10);
        }
        JComboBox box = this.getComboBox();
        box.removeAllItems();
        Iterator<String> iterator = directories.iterator();
        String mainDirectory = iterator.next();
        VirtualFile mainParent = PhpPsrDirectoryComboBox.findExistingParent(mainDirectory);
        while (iterator.hasNext() && !this.myDirectoriesFilter.value((Object)mainParent)) {
            mainDirectory = iterator.next();
            mainParent = PhpPsrDirectoryComboBox.findExistingParent(mainDirectory);
        }
        if (!iterator.hasNext() && !this.myDirectoriesFilter.value((Object)mainParent)) {
            box.addItem(this.myInitialItem);
        } else {
            if (!StringUtil.equals((CharSequence)mainDirectory, (CharSequence)this.myInitialItem.getFullPresentablePath())) {
                box.addItem(this.myInitialItem);
            }
            box.setSelectedItem(this.addDirectory(box, mainDirectory, mainParent));
            while (iterator.hasNext()) {
                VirtualFile existingParent;
                String directory = iterator.next();
                if (StringUtil.equals((CharSequence)directory, (CharSequence)this.myInitialItem.getFullPresentablePath()) || !this.myDirectoriesFilter.value((Object)(existingParent = PhpPsrDirectoryComboBox.findExistingParent(directory)))) continue;
                this.addDirectory(box, directory, existingParent);
            }
        }
    }

    @Nullable
    private static VirtualFile findExistingParent(@NotNull String path) {
        if (path == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(path);
        return directory == null ? PhpPsrDirectoryComboBox.findExistingParent(PathUtil.getParentPath((String)path)) : directory;
    }

    private ItemWrapper addDirectory(@NotNull JComboBox comboBox, @NotNull String directory, @Nullable VirtualFile baseDirectory) {
        if (comboBox == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(12);
        }
        if (directory == null) {
            PhpPsrDirectoryComboBox.$$$reportNull$$$0(13);
        }
        ItemWrapper item = new ItemWrapper(directory, this.myProjectBasePath, baseDirectory);
        comboBox.addItem(item);
        return item;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/ui/PhpPsrDirectoryComboBox";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/ui/PhpPsrDirectoryComboBox";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoriesFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestDirectories";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectories";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExistingParent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ItemWrapper {
        private static final String PATH_PREFIX = "...";
        private final String myProjectBasePath;
        private String myFullPath;
        private VirtualFile myExistingParent;
        private String myCachedPathPresentation;

        public ItemWrapper(@NotNull String path, @NotNull String projectPath, @Nullable VirtualFile existingParent) {
            if (path == null) {
                ItemWrapper.$$$reportNull$$$0(0);
            }
            if (projectPath == null) {
                ItemWrapper.$$$reportNull$$$0(1);
            }
            this.myFullPath = path;
            this.myProjectBasePath = projectPath;
            this.myExistingParent = existingParent;
            this.myCachedPathPresentation = null;
        }

        public void updatePath(@NotNull String path, @Nullable VirtualFile baseDirectory) {
            if (path == null) {
                ItemWrapper.$$$reportNull$$$0(2);
            }
            this.myFullPath = path;
            this.myExistingParent = baseDirectory;
            this.myCachedPathPresentation = null;
        }

        public VirtualFile getExistingParent() {
            return this.myExistingParent;
        }

        public String getRelativePath() {
            if (this.myExistingParent == null) {
                return this.myFullPath;
            }
            String relativeDirPath = FileUtil.getRelativePath((String)this.myExistingParent.getPath(), (String)this.getFullIndependentPath(), (char)'/');
            return StringUtil.equals((CharSequence)relativeDirPath, (CharSequence)".") ? "" : relativeDirPath;
        }

        public String getPresentablePath() {
            if (this.myCachedPathPresentation == null) {
                this.myCachedPathPresentation = this.myFullPath != null && this.myFullPath.startsWith(this.myProjectBasePath) && !StringUtil.equals((CharSequence)this.myFullPath, (CharSequence)this.myProjectBasePath) ? PATH_PREFIX + this.myFullPath.substring(this.myProjectBasePath.length()) : StringUtil.notNullize((String)this.myFullPath);
            }
            return this.myCachedPathPresentation;
        }

        public String getFullPresentablePath() {
            return this.myFullPath;
        }

        public String getFullIndependentPath() {
            return FileUtil.toSystemIndependentName((String)this.myFullPath);
        }

        public Icon getIcon(FileIndex fileIndex) {
            if (this.myExistingParent != null) {
                if (fileIndex.isInTestSourceContent(this.myExistingParent)) {
                    return PlatformIcons.MODULES_TEST_SOURCE_FOLDER;
                }
                if (fileIndex.isInSourceContent(this.myExistingParent)) {
                    return PlatformIcons.MODULES_SOURCE_FOLDERS_ICON;
                }
            }
            return PlatformIcons.FOLDER_ICON;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectPath";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/roots/ui/PhpPsrDirectoryComboBox$ItemWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

