/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GemUtil {
    private static final String GEMS_DIRECTORY = "gems";
    private static final String RBENV_HOME_DIRECTORY_NAME = ".rbenv";
    private static final String RBENV_HOME_VARIABLE = "RBENV_ROOT";
    private static final String RBENV_RUBIES_DIRECTORY = "versions";
    private static final String RBENV_GEMS_RELATIVE_PATH = "lib/ruby/gems";
    private static final String RVM_HOME_DIRECTORY_NAME = ".rvm";
    private static final String RVM_HOME_VARIABLE = "rvm_path";
    private static final String RVM_SYSTEM_WIDE_PATH = "/usr/local/rvm";
    private static final String RVM_RUBIES_DIRECTORY = "rubies";

    @NotNull
    public static Collection<? extends VirtualFile> findGems(@NotNull String gemName) {
        if (gemName == null) {
            GemUtil.$$$reportNull$$$0(0);
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        result.addAll(GemUtil.findRvmGems(gemName));
        result.addAll(GemUtil.findRbenvGems(gemName));
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            GemUtil.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    @NotNull
    public static List<String> listPossibleExecutableFilePaths(@NotNull String executableFileName, @NotNull String executableRelativePath) {
        if (executableFileName == null) {
            GemUtil.$$$reportNull$$$0(2);
        }
        if (executableRelativePath == null) {
            GemUtil.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.map(GemUtil.listPossibleExecutableFiles(executableFileName, executableRelativePath), file -> file.getPath());
        if (list == null) {
            GemUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static boolean isValidExecutableFile(@Nullable VirtualFile executableFile) {
        return executableFile != null && executableFile.exists() && !executableFile.isDirectory();
    }

    @NotNull
    public static Set<VirtualFile> listPossibleExecutableFiles(@NotNull String executableFileName, @NotNull String executableRelativePath) {
        if (executableFileName == null) {
            GemUtil.$$$reportNull$$$0(5);
        }
        if (executableRelativePath == null) {
            GemUtil.$$$reportNull$$$0(6);
        }
        LinkedHashSet interpreters = ContainerUtil.newLinkedHashSet();
        List path = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)executableFileName);
        for (File file : path) {
            VirtualFile compassExecutableFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            if (!GemUtil.isValidExecutableFile(compassExecutableFile)) continue;
            interpreters.add(compassExecutableFile);
        }
        for (VirtualFile virtualFile : GemUtil.findGems(executableFileName)) {
            GemUtil.populateWithExecutableFilesFromGemDirectory(virtualFile, interpreters, executableRelativePath);
        }
        LinkedHashSet linkedHashSet = interpreters;
        if (linkedHashSet == null) {
            GemUtil.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<? extends VirtualFile> findRbenvGems(@NotNull String gemName) {
        VirtualFile versionsDirectory;
        VirtualFile rbenvHome;
        if (gemName == null) {
            GemUtil.$$$reportNull$$$0(8);
        }
        if (SystemInfo.isUnix && (rbenvHome = GemUtil.getRbenvHome()) != null && (versionsDirectory = rbenvHome.findFileByRelativePath(RBENV_RUBIES_DIRECTORY)) != null && versionsDirectory.isDirectory()) {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            Pattern gemNamePattern = GemUtil.createGemNamePattern(gemName);
            for (VirtualFile versionDirectory : versionsDirectory.getChildren()) {
                VirtualFile versionGemsDirectory = versionDirectory.findFileByRelativePath(RBENV_GEMS_RELATIVE_PATH);
                if (versionGemsDirectory == null || !versionGemsDirectory.isDirectory()) continue;
                for (VirtualFile subversionDirectory : versionGemsDirectory.getChildren()) {
                    VirtualFile gemsDirectory = subversionDirectory.findFileByRelativePath(GEMS_DIRECTORY);
                    if (gemsDirectory == null || !gemsDirectory.isDirectory()) continue;
                    for (VirtualFile gem : gemsDirectory.getChildren()) {
                        if (!gem.isDirectory() || !gemNamePattern.matcher(gem.getName()).matches()) continue;
                        result.add(gem);
                    }
                }
            }
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                GemUtil.$$$reportNull$$$0(9);
            }
            return linkedHashSet;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            GemUtil.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    private static Collection<? extends VirtualFile> findRvmGems(@NotNull String gemName) {
        VirtualFile versionsDirectory;
        VirtualFile rvmHome;
        if (gemName == null) {
            GemUtil.$$$reportNull$$$0(11);
        }
        if (SystemInfo.isUnix && (rvmHome = GemUtil.getRvmHome()) != null && (versionsDirectory = rvmHome.findChild(GEMS_DIRECTORY)) != null && versionsDirectory.isDirectory() && versionsDirectory.getChildren().length > 0) {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            Pattern gemNamePattern = GemUtil.createGemNamePattern(gemName);
            for (VirtualFile rubyDirectory : versionsDirectory.getChildren()) {
                VirtualFile gemsDirectory = rubyDirectory.findFileByRelativePath(GEMS_DIRECTORY);
                if (gemsDirectory == null || !gemsDirectory.isDirectory()) continue;
                for (VirtualFile gem : gemsDirectory.getChildren()) {
                    if (!gem.isDirectory() || !gemNamePattern.matcher(gem.getName()).matches()) continue;
                    result.add(gem);
                }
            }
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                GemUtil.$$$reportNull$$$0(12);
            }
            return linkedHashSet;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            GemUtil.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Nullable
    private static VirtualFile getRbenvHome() {
        VirtualFile rubyHome = GemUtil.findRubyHomeFromEnvironmentVariable(RBENV_HOME_VARIABLE);
        return rubyHome != null ? rubyHome : GemUtil.findRubyHomeInUserDirectory(RBENV_HOME_DIRECTORY_NAME);
    }

    @Nullable
    private static VirtualFile getRvmHome() {
        VirtualFile systemWideRvmHome;
        VirtualFile rvmHome = GemUtil.findRubyHomeFromEnvironmentVariable(RVM_HOME_VARIABLE);
        if (rvmHome == null && (rvmHome = GemUtil.findRubyHomeInUserDirectory(RVM_HOME_DIRECTORY_NAME)) == null && GemUtil.isValidRubyHome(systemWideRvmHome = VirtualFileManager.getInstance().refreshAndFindFileByUrl(RVM_SYSTEM_WIDE_PATH))) {
            assert (systemWideRvmHome != null);
            VirtualFile markerDirectory = systemWideRvmHome.findChild(RVM_RUBIES_DIRECTORY);
            if (GemUtil.isValidRubyHome(markerDirectory)) {
                rvmHome = systemWideRvmHome;
            }
        }
        return rvmHome;
    }

    @Nullable
    private static VirtualFile findRubyHomeFromEnvironmentVariable(@NotNull String variableName) {
        String pathFromEnvironmentVariable;
        if (variableName == null) {
            GemUtil.$$$reportNull$$$0(14);
        }
        if (!StringUtil.isEmpty((String)(pathFromEnvironmentVariable = EnvironmentUtil.getValue((String)variableName)))) {
            String possibleRubyHomePath = VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)pathFromEnvironmentVariable));
            VirtualFile rubyHome = VirtualFileManager.getInstance().refreshAndFindFileByUrl(possibleRubyHomePath);
            if (GemUtil.isValidRubyHome(rubyHome)) {
                return rubyHome;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findRubyHomeInUserDirectory(@NotNull String rubyHomeDirectoryName) {
        VirtualFile rvmHome;
        VirtualFile userHomeFolder;
        if (rubyHomeDirectoryName == null) {
            GemUtil.$$$reportNull$$$0(15);
        }
        if ((userHomeFolder = VfsUtil.getUserHomeDir()) != null && GemUtil.isValidRubyHome(rvmHome = userHomeFolder.findChild(rubyHomeDirectoryName))) {
            return rvmHome;
        }
        return null;
    }

    @NotNull
    private static Pattern createGemNamePattern(@NotNull String gemName) {
        if (gemName == null) {
            GemUtil.$$$reportNull$$$0(16);
        }
        Pattern pattern = Pattern.compile(StringUtil.escapePattern((String)gemName) + "-\\d.*");
        if (pattern == null) {
            GemUtil.$$$reportNull$$$0(17);
        }
        return pattern;
    }

    private static boolean isValidRubyHome(@Nullable VirtualFile rvmHome) {
        if (rvmHome == null) {
            return false;
        }
        return rvmHome.exists() && rvmHome.isDirectory() && rvmHome.getChildren().length > 0;
    }

    private static void populateWithExecutableFilesFromGemDirectory(@NotNull VirtualFile gemsDirectory, @NotNull Set<VirtualFile> interpreters, @NotNull String relativePathInGem) {
        VirtualFile compassExecutableFile;
        if (gemsDirectory == null) {
            GemUtil.$$$reportNull$$$0(18);
        }
        if (interpreters == null) {
            GemUtil.$$$reportNull$$$0(19);
        }
        if (relativePathInGem == null) {
            GemUtil.$$$reportNull$$$0(20);
        }
        if (GemUtil.isValidExecutableFile(compassExecutableFile = gemsDirectory.findFileByRelativePath(relativePathInGem))) {
            interpreters.add(compassExecutableFile);
        }
    }

    private GemUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/GemUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableFileName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableRelativePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyHomeDirectoryName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsDirectory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePathInGem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/GemUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findGems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleExecutableFilePaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleExecutableFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findRbenvGems";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findRvmGems";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createGemNamePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findGems";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleExecutableFilePaths";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleExecutableFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findRbenvGems";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findRvmGems";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRubyHomeFromEnvironmentVariable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findRubyHomeInUserDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createGemNamePattern";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "populateWithExecutableFilesFromGemDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

