/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.language.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateCustomTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTheme;
import org.jetbrains.plugins.textmate.plist.XmlPlistReader;

public abstract class TextMateService {
    protected static final Logger LOG = Logger.getInstance(TextMateService.class);

    public static TextMateService getInstance() {
        return (TextMateService)ServiceManager.getService(TextMateService.class);
    }

    public abstract void reloadThemesFromDisk();

    @Nullable
    public abstract Bundle createBundle(@NotNull VirtualFile var1);

    public abstract boolean registerTheme(@Nullable VirtualFile var1);

    public abstract TextMateTheme getCurrentTheme();

    public abstract void registerEnabledBundles(boolean var1);

    public abstract void unregisterAllBundles(boolean var1);

    @Nullable
    public abstract TextMateLanguageDescriptor getLanguageDescriptorByExtension(String var1);

    @Nullable
    public abstract String getVariableValue(@NotNull String var1, @NotNull EditorEx var2);

    @NotNull
    public abstract SnippetsRegistry getSnippetsRegistry();

    @Nullable
    public abstract TextMateLanguageDescriptor getLanguageDescriptorByFileName(String var1);

    public abstract String[] getThemeNames();

    @NotNull
    public abstract List<Preferences> getPreferencesForSelector(String var1);

    @NotNull
    public abstract Map<String, TextMateCustomTextAttributes> getCustomHighlightingColors();

    public abstract XmlPlistReader getPlistReader();

    public abstract void addListener(@NotNull TextMateBundleListener var1);

    public abstract void removeListener(@NotNull TextMateBundleListener var1);

    public abstract void clearListeners();

    public static interface TextMateBundleListener {
        public void colorSchemeChanged();
    }
}

