/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.VariableNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInferType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptExtractNamedTypeHandler
implements RefactoringActionHandler {
    @NotNull
    private final JSIntroduceTargetChooser<JSTypeDeclaration> myTypeChooser;
    @NotNull
    private final ReplaceAllChooser myReplaceAllChooser;
    protected static final String DEFAULT_NAME = "Created";

    public TypeScriptExtractNamedTypeHandler(@NotNull JSIntroduceTargetChooser<JSTypeDeclaration> typeChooser, @NotNull ReplaceAllChooser chooser) {
        if (typeChooser == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(0);
        }
        if (chooser == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(1);
        }
        this.myTypeChooser = typeChooser;
        this.myReplaceAllChooser = chooser;
    }

    public TypeScriptExtractNamedTypeHandler() {
        this(IntroduceTargetChooser::showChooser, TypeScriptExtractNamedTypeHandler::showOccurrencesChooser);
    }

    public boolean isAvailableOnEditorAndFile(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(3);
        }
        return !ContainerUtil.isEmpty(this.getCandidates(editor, file2));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, DataContext dataContext) {
        if (project == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(8);
        }
        this.invoke(editor, file2);
    }

    public void invoke(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(10);
        }
        List<Candidate> types = this.getCandidates(editor, file2);
        Consumer<Candidate> callback = selectedType -> {
            if (editor == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(58);
            }
            this.invokeForType(editor, (Candidate)selectedType);
        };
        this.chooseType(editor, types, TypeScriptExtractNamedTypeHandler.writeCallback(callback));
    }

    private void invokeForType(@NotNull Editor editor, @NotNull Candidate target) {
        List<JSTypeDeclaration> occurrences;
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(11);
        }
        if (target == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(12);
        }
        Pair<JSElement, Collection<TypeScriptGenericOrMappedTypeParameter>> pair = TypeScriptExtractNamedTypeHandler.getScopeAndGenerics(target);
        JSElement scope = (JSElement)pair.first;
        if (scope == null) {
            return;
        }
        List<JSTypeDeclaration> list = occurrences = target.relativeRange == null ? TypeScriptExtractNamedTypeHandler.findOccurrences(target.type, scope) : ContainerUtil.emptyList();
        if (occurrences.size() > 1) {
            Consumer<OccurrencesChooser.ReplaceChoice> callback = choice -> {
                if (editor == null) {
                    TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(56);
                }
                if (target == null) {
                    TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(57);
                }
                List toReplace = choice == OccurrencesChooser.ReplaceChoice.ALL ? occurrences : ContainerUtil.emptyList();
                this.invokeForOccurrences(editor, target, toReplace, scope, (Collection)pair.second);
            };
            this.myReplaceAllChooser.invoke(editor, target.type, occurrences, TypeScriptExtractNamedTypeHandler.writeCallback(callback));
        } else {
            this.invokeForOccurrences(editor, target, occurrences, scope, (Collection)pair.second);
        }
    }

    void invokeForOccurrences(@NotNull Editor editor, @NotNull Candidate target, @NotNull List<JSTypeDeclaration> occurrences, @NotNull JSElement scope, @NotNull Collection<TypeScriptGenericOrMappedTypeParameter> genericParameters) {
        List nameCandidates;
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(13);
        }
        if (target == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(14);
        }
        if (occurrences == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(16);
        }
        if (genericParameters == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(17);
        }
        JSTypeDeclaration firstInScope = occurrences.size() > 0 && occurrences.get(0).getTextRange().getStartOffset() < target.type.getTextRange().getStartOffset() ? occurrences.get(0) : target.type;
        PsiElement anchor = PsiTreeUtil.findFirstParent((PsiElement)firstInScope, t -> {
            PsiElement parent;
            if (scope == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(55);
            }
            return scope.isEquivalentTo(parent = t.getParent()) || parent instanceof JSBlockStatement && scope.isEquivalentTo(parent.getParent());
        });
        if ((anchor = JSPsiImplUtils.findLeadingCommentOrSelf(anchor)) == null) {
            return;
        }
        JSType jsType = TypeScriptExtractNamedTypeHandler.getJSType(target.type);
        List list = nameCandidates = jsType != null ? JSNameSuggestionsUtil.generateTypeNamesFromType(jsType, (PsiElement)scope) : ContainerUtil.emptyList();
        if (nameCandidates.isEmpty()) {
            nameCandidates = ContainerUtil.list((Object[])new String[]{JSNameSuggestionsUtil.ensureUniqueVariableName(DEFAULT_NAME, (PsiElement)scope, ContainerUtil.newHashSet(), false)});
        }
        String introducedText = target.relativeRange != null ? target.relativeRange.substring(target.type.getText()) : target.type.getText();
        String genericParametersText = genericParameters.isEmpty() ? "" : "<" + StringUtil.join(genericParameters, t -> t instanceof TypeScriptTypeParameter ? t.getText() : t.getName(), (String)", ") + ">";
        JSClass typeDeclaration = this.buildTypeDeclarationFromText((String)nameCandidates.get(0), genericParametersText, introducedText, (PsiElement)target.type);
        typeDeclaration = (JSClass)anchor.getParent().addBefore((PsiElement)typeDeclaration, anchor);
        JSChangeUtil.addWs(typeDeclaration.getParent().getNode(), typeDeclaration.getNode().getTreeNext(), "\n");
        List genericArguments = ContainerUtil.map(genericParameters, t -> t.getName());
        String genericArgumentsText = genericArguments.isEmpty() ? "" : "<" + StringUtil.join((Collection)genericArguments, (String)", ") + ">";
        String usageReplacementText = (String)nameCandidates.get(0) + genericArgumentsText;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)target.type.getProject());
        List occurrencesPointers = ContainerUtil.mapNotNull(occurrences, o -> {
            if (target == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(54);
            }
            if (o == target.type) {
                return null;
            }
            JSReferenceExpression replacement = TypeScriptExtractNamedTypeHandler.replaceUsage(o, null, usageReplacementText);
            if (replacement == null) {
                return null;
            }
            return smartPointerManager.createSmartPsiElementPointer((PsiElement)replacement);
        });
        JSReferenceExpression usageReplacement = TypeScriptExtractNamedTypeHandler.replaceUsage(target.type, target.relativeRange, usageReplacementText);
        if (usageReplacement == null) {
            return;
        }
        SmartPsiElementPointer usageReplacementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)usageReplacement);
        FormatFixer.create((PsiElement)typeDeclaration, FormatFixer.Mode.Reformat).fixFormat();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)typeDeclaration.getProject());
        Document document = documentManager.getDocument(typeDeclaration.getContainingFile());
        if (document == null) {
            return;
        }
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        usageReplacement = (JSElement)usageReplacementPointer.getElement();
        if (usageReplacement == null) {
            return;
        }
        List filteredOccurrences = ContainerUtil.mapNotNull((Collection)occurrencesPointers, pointer -> (JSElement)pointer.getElement());
        TypeScriptExtractNamedTypeHandler.startTemplate(editor, (JSElement)usageReplacement, filteredOccurrences, nameCandidates, typeDeclaration, (PsiElement)scope);
    }

    @Nullable
    private static JSReferenceExpression replaceUsage(@NotNull JSTypeDeclaration type, @Nullable TextRange range, @NotNull String text) {
        if (type == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(18);
        }
        if (text == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(19);
        }
        String replacementText = range == null ? text : type.getText().substring(0, range.getStartOffset()) + text + type.getText().substring(range.getEndOffset());
        JSTypeDeclaration replacement = (JSTypeDeclaration)type.replace((PsiElement)JSChangeUtil.createTypeScriptType(replacementText, (PsiElement)type));
        TextRange absoluteRange = range != null ? range.shiftRight(replacement.getTextRange().getStartOffset()) : null;
        Ref result2 = new Ref();
        PsiTreeUtil.processElements((PsiElement)replacement, element -> {
            if (element instanceof JSReferenceExpression && (absoluteRange == null || absoluteRange.contains(element.getTextRange()))) {
                result2.set((Object)((JSReferenceExpression)element));
                return false;
            }
            return true;
        });
        return (JSReferenceExpression)result2.get();
    }

    private static void startTemplate(@NotNull Editor editor, @NotNull JSElement target, @NotNull List<JSElement> occurrencesWithoutMain, @NotNull List<String> nameCandidates, @NotNull JSClass typeDeclaration, @NotNull PsiElement scope) {
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(20);
        }
        if (target == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(21);
        }
        if (occurrencesWithoutMain == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(22);
        }
        if (nameCandidates == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(23);
        }
        if (typeDeclaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(25);
        }
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl(scope);
        String dependantVariableName = "OTHER_VARIABLE";
        String primaryVariableName = "PRIMARY_VARIABLE";
        templateBuilder.replaceElement(typeDeclaration.getNameIdentifier(), "OTHER_VARIABLE", "PRIMARY_VARIABLE", false);
        for (JSElement occurrence : occurrencesWithoutMain) {
            templateBuilder.replaceElement((PsiElement)occurrence, "OTHER_VARIABLE", "PRIMARY_VARIABLE", false);
        }
        templateBuilder.replaceElement((PsiElement)target, "PRIMARY_VARIABLE", (Expression)new VariableNode("PRIMARY_VARIABLE", TypeScriptExtractNamedTypeHandler.buildTemplateExpression(nameCandidates)), true);
        Template template = templateBuilder.buildInlineTemplate();
        template.setToReformat(false);
        TemplateManager templateManager = TemplateManager.getInstance((Project)scope.getProject());
        BaseCreateFix.navigate(scope.getProject(), editor, scope.getTextRange().getStartOffset(), scope.getContainingFile().getVirtualFile());
        templateManager.startTemplate(editor, template);
    }

    @NotNull
    static Pair<JSElement, Collection<TypeScriptGenericOrMappedTypeParameter>> getScopeAndGenerics(@NotNull Candidate candidate) {
        if (candidate == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(26);
        }
        Ref localTypesScope = new Ref();
        LinkedHashSet<TypeScriptGenericOrMappedTypeParameter> genericParameters = new LinkedHashSet<TypeScriptGenericOrMappedTypeParameter>();
        TextRange absoluteRange = candidate.relativeRange != null ? candidate.relativeRange.shiftRight(candidate.type.getTextRange().getStartOffset()) : null;
        TypeScriptExtractNamedTypeHandler.getScopeAndGenerics((PsiElement)candidate.type, absoluteRange, (Ref<PsiElement>)localTypesScope, genericParameters);
        if (!localTypesScope.isNull()) {
            Pair pair = Pair.create((Object)ObjectUtils.tryCast((Object)localTypesScope.get(), JSElement.class), genericParameters);
            if (pair == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(27);
            }
            return pair;
        }
        JSElement scope = (JSElement)PsiTreeUtil.findFirstParent((PsiElement)candidate.type, element -> element instanceof JSFile || element instanceof TypeScriptModule || element instanceof JSEmbeddedContent && !JSPsiImplUtils.isEmbeddedTypeContext(element) && !JSPsiImplUtils.isEmbeddedExpressionContent(element));
        Pair pair = Pair.create((Object)scope, genericParameters);
        if (pair == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(28);
        }
        return pair;
    }

    static void getScopeAndGenerics(@Nullable PsiElement candidate, @Nullable TextRange textRange, @NotNull Ref<PsiElement> scopeRef, @NotNull Collection<TypeScriptGenericOrMappedTypeParameter> genericParameters) {
        if (scopeRef == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(29);
        }
        if (genericParameters == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(30);
        }
        if (candidate == null) {
            return;
        }
        PsiTreeUtil.processElements((PsiElement)candidate, element -> {
            PsiElement nameScope;
            if (scopeRef == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(52);
            }
            if (genericParameters == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(53);
            }
            if (!(element instanceof TypeScriptSingleType)) {
                return true;
            }
            if (textRange != null && !textRange.contains(element.getTextRange())) {
                return true;
            }
            JSReferenceExpression refExpr = ((TypeScriptSingleType)element).getReferenceExpression();
            if (refExpr == null) {
                return true;
            }
            PsiElement resolved = refExpr.resolve();
            if (resolved instanceof JSNamedElement && (nameScope = JSPsiImplUtils.getNameScope((JSNamedElement)resolved)) != null && (scopeRef.get() == null || PsiTreeUtil.isAncestor((PsiElement)((PsiElement)scopeRef.get()), (PsiElement)nameScope, (boolean)true))) {
                scopeRef.set((Object)nameScope);
            }
            if (resolved instanceof TypeScriptTypeParameter) {
                TypeScriptTypeParameter typeParameter = (TypeScriptTypeParameter)resolved;
                if (genericParameters.add((TypeScriptGenericOrMappedTypeParameter)typeParameter)) {
                    TypeScriptExtractNamedTypeHandler.getScopeAndGenerics((PsiElement)typeParameter.getDefault(), null, scopeRef, genericParameters);
                    TypeScriptExtractNamedTypeHandler.getScopeAndGenerics((PsiElement)typeParameter.getTypeConstraint(), null, scopeRef, genericParameters);
                }
            } else if (resolved instanceof TypeScriptMappedTypeParameter || resolved instanceof TypeScriptInferType) {
                genericParameters.add((TypeScriptGenericOrMappedTypeParameter)resolved);
            }
            return true;
        });
    }

    @NotNull
    protected abstract JSClass buildTypeDeclarationFromText(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull PsiElement var4);

    protected boolean isAcceptableType(@NotNull JSTypeDeclaration declaration) {
        if (declaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(31);
        }
        return !(declaration.getParent() instanceof TypeScriptInterface);
    }

    @NotNull
    private static List<JSTypeDeclaration> findOccurrences(@NotNull JSTypeDeclaration typeDeclaration, @NotNull JSElement scope) {
        if (typeDeclaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(33);
        }
        ArrayList results = ContainerUtil.newArrayList();
        PsiTreeUtil.processElements((PsiElement)scope, e -> {
            if (typeDeclaration == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(51);
            }
            if (e instanceof JSTypeDeclaration && !(e.getParent() instanceof TypeScriptInterface) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)typeDeclaration)) {
                results.add((JSTypeDeclaration)e);
            }
            return true;
        });
        ArrayList arrayList = results;
        if (arrayList == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    private static Expression buildTemplateExpression(final @NotNull List<String> nameCandidates) {
        if (nameCandidates == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(35);
        }
        Expression expression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult((String)nameCandidates.get(0));
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return (LookupElement[])ContainerUtil.map2Array((Collection)nameCandidates, LookupElement.class, s -> LookupElementBuilder.create((String)s));
            }
        };
        if (expression == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(36);
        }
        return expression;
    }

    private void chooseType(Editor editor, final List<Candidate> candidates, final Pass<Candidate> callback) {
        if (candidates.isEmpty()) {
            return;
        }
        if (candidates.size() == 1) {
            callback.pass((Object)candidates.get(0));
        } else {
            List list = ContainerUtil.map(candidates, t -> t.type);
            this.myTypeChooser.invoke(editor, list, new Pass<JSTypeDeclaration>(){

                public void pass(JSTypeDeclaration selected) {
                    callback.pass(ContainerUtil.find((Iterable)candidates, t -> t.type == selected));
                }
            }, (Function<JSTypeDeclaration, String>)((Function)declaration -> declaration.getText()));
        }
    }

    @NotNull
    private List<Candidate> getCandidates(@NotNull Editor editor, @NotNull PsiFile file2) {
        SelectionModel selectionModel;
        if (editor == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(38);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
            Candidate fromSelection = TypeScriptExtractNamedTypeHandler.findTypeInRange(file2, new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
            List list = fromSelection != null && this.isAcceptableType(fromSelection.type) ? ContainerUtil.list((Object[])new Candidate[]{fromSelection}) : ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(39);
            }
            return list;
        }
        List<Candidate> list = this.lookUpCandidates(file2, editor.getCaretModel().getOffset());
        if (list == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(40);
        }
        return list;
    }

    @Nullable
    private static Candidate findTypeInRange(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(41);
        }
        if (range == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(42);
        }
        JSTypeDeclaration startElement = TypeScriptExtractNamedTypeHandler.findTypeElementAt(file2, range.getStartOffset(), true);
        JSTypeDeclaration endElement = TypeScriptExtractNamedTypeHandler.findTypeElementAt(file2, range.getEndOffset(), false);
        if (startElement == null || endElement == null) {
            return null;
        }
        startElement = TypeScriptExtractNamedTypeHandler.findTopmost(startElement, JSTypeDeclaration.class, (Condition<PsiElement>)((Condition)element -> {
            if (range == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(50);
            }
            return range.contains(element.getTextRange());
        }));
        endElement = TypeScriptExtractNamedTypeHandler.findTopmost(endElement, JSTypeDeclaration.class, (Condition<PsiElement>)((Condition)element -> {
            if (range == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(49);
            }
            return range.contains(element.getTextRange());
        }));
        if (startElement == null || endElement == null) {
            return null;
        }
        if (startElement == endElement && range.contains(startElement.getTextRange())) {
            return new Candidate(startElement, null);
        }
        if (startElement.getParent() == endElement.getParent() && startElement.getParent() instanceof TypeScriptUnionOrIntersectionType) {
            PsiElement parent = startElement.getParent();
            TextRange meaningfulRange = new TextRange(startElement.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset());
            return parent.getTextRange().contains(meaningfulRange) ? new Candidate((JSTypeDeclaration)parent, meaningfulRange.shiftLeft(parent.getTextRange().getStartOffset())) : null;
        }
        return null;
    }

    @NotNull
    private List<Candidate> lookUpCandidates(@NotNull PsiFile file2, int offset) {
        JSTypeDeclaration current;
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(43);
        }
        if ((current = TypeScriptExtractNamedTypeHandler.findTypeElementAt(file2, offset, true)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(44);
            }
            return list;
        }
        ArrayList types = ContainerUtil.newArrayList();
        while (current != null) {
            Candidate last = (Candidate)ContainerUtil.getLastItem((List)types);
            if ((last == null || !current.getTextRange().equals((Object)last.type.getTextRange())) && this.isAcceptableType(current)) {
                types.add(new Candidate(current, null));
            }
            if (!((current = (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)current, JSTypeDeclaration.class)) instanceof TypeScriptParenthesizedType)) continue;
            current = (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)current, JSTypeDeclaration.class);
        }
        ArrayList arrayList = types;
        if (arrayList == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    @Nullable
    private static <T extends PsiElement> T findTopmost(@NotNull T element, Class<T> clazz, Condition<PsiElement> condition) {
        if (element == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(46);
        }
        if (!condition.value(element)) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType(element, clazz);
        while (parent != null && condition.value((Object)parent)) {
            element = parent;
            parent = PsiTreeUtil.getParentOfType(element, clazz);
        }
        return element;
    }

    @Nullable
    private static JSTypeDeclaration findTypeElementAt(@NotNull PsiFile file2, int offset, boolean forward) {
        PsiElement element;
        if (file2 == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(47);
        }
        if ((element = file2.findElementAt(offset == file2.getTextLength() && !forward && offset > 0 ? offset - 1 : offset)) == null) {
            return null;
        }
        if (!forward) {
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        while (element != null && (element instanceof PsiWhiteSpace || element instanceof PsiComment || element.getNode().getElementType() == JSTokenTypes.LPAR || element.getNode().getElementType() == JSTokenTypes.RPAR)) {
            element = forward ? PsiTreeUtil.nextLeaf((PsiElement)element) : PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        return (JSTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, JSTypeDeclaration.class);
    }

    @Nullable
    private static JSType getJSType(@NotNull JSTypeDeclaration typeDeclaration) {
        JSTypeDeclarationOwner owner;
        if (typeDeclaration == null) {
            TypeScriptExtractNamedTypeHandler.$$$reportNull$$$0(48);
        }
        return (owner = (JSTypeDeclarationOwner)ObjectUtils.tryCast((Object)typeDeclaration.getParent(), JSTypeDeclarationOwner.class)) != null ? owner.getType() : null;
    }

    private static <T> Pass<T> writeCallback(final Consumer<T> callback) {
        return new Pass<T>(){

            public void pass(T t) {
                ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> callback.accept(t)));
            }
        };
    }

    private static void showOccurrencesChooser(Editor editor, JSTypeDeclaration main, List<JSTypeDeclaration> occurrences, Pass<OccurrencesChooser.ReplaceChoice> callback) {
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)main, occurrences, callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeChooser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 37: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 38: 
            case 41: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: 
            case 14: 
            case 21: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 16: 
            case 25: 
            case 33: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: 
            case 30: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericParameters";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrencesWithoutMain";
                break;
            }
            case 23: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCandidates";
                break;
            }
            case 24: 
            case 32: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 27: 
            case 28: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler";
                break;
            }
            case 29: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeRef";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 42: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeAndGenerics";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findOccurrences";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTemplateExpression";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "lookUpCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnEditorAndFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invokeForType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invokeForOccurrences";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceUsage";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
            case 26: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getScopeAndGenerics";
                break;
            }
            case 27: 
            case 28: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 44: 
            case 45: {
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findOccurrences";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateExpression";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findTypeInRange";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lookUpCandidates";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findTopmost";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findTypeElementAt";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getJSType";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findTypeInRange$14";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findTypeInRange$13";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findOccurrences$10";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getScopeAndGenerics$9";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeForOccurrences$5";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeForOccurrences$2";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeForType$1";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 28: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Candidate {
        @NotNull
        public final JSTypeDeclaration type;
        @Nullable
        public final TextRange relativeRange;

        Candidate(@NotNull JSTypeDeclaration type, @Nullable TextRange relativeRange) {
            if (type == null) {
                Candidate.$$$reportNull$$$0(0);
            }
            this.type = type;
            this.relativeRange = relativeRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/refactoring/TypeScriptExtractNamedTypeHandler$Candidate", "<init>"));
        }
    }

    public static interface ReplaceAllChooser {
        public void invoke(Editor var1, JSTypeDeclaration var2, List<JSTypeDeclaration> var3, Pass<OccurrencesChooser.ReplaceChoice> var4);
    }
}

