/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSessionToolWindowHelper;
import com.intellij.database.console.session.DatabaseSessionView;
import com.intellij.database.console.session.VisibleDatabaseSession;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.ToolWindow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridSessionClient
extends DatabaseTableGridDataHookUp
implements VisibleDatabaseSessionClient,
DataRequest.CustomSearchPathOwner {
    private final VisibleDatabaseSession mySession;

    DataGridSessionClient(@NotNull Project project, @NotNull VisibleDatabaseSession session2, @NotNull VirtualFile file) {
        if (project == null) {
            DataGridSessionClient.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            DataGridSessionClient.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DataGridSessionClient.$$$reportNull$$$0(2);
        }
        super(project, session2, file, new DGDepartment.DataEditor(DataGridSessionClient.getTitle(project, file)));
        this.mySession = session2;
        this.mySession.attach(this);
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = DataGridSessionClient.getTitle(this.getProject(), this.myFile);
        if (string == null) {
            DataGridSessionClient.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public VisibleDatabaseSession getSession() {
        VisibleDatabaseSession visibleDatabaseSession = this.mySession;
        if (visibleDatabaseSession == null) {
            DataGridSessionClient.$$$reportNull$$$0(4);
        }
        return visibleDatabaseSession;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean getShowOnActivity() {
        DatabaseSessionView view = (DatabaseSessionView)this.mySession.getView();
        Project project = view.getProject();
        ToolWindow window = view.getToolWindowHelper().getToolWindow(project);
        return window != null && window.isVisible() || DatabaseSessionToolWindowHelper.wasActiveLastTime(project);
    }

    @Override
    public boolean focusOnError(@NotNull DataRequest.Context context) {
        if (context == null) {
            DataGridSessionClient.$$$reportNull$$$0(5);
        }
        return true;
    }

    @Override
    public boolean showOnAttention(@NotNull DataRequest.Context context) {
        if (context == null) {
            DataGridSessionClient.$$$reportNull$$$0(6);
        }
        return false;
    }

    @Override
    @Nullable
    public SearchPath getSearchPath() {
        return DbImplUtil.getDatabaseToSwitch((LocalDataSource)this.mySession.getTarget(), SearchPath.of((ObjectPath)ObjectPaths.of((DasObject)this.getDatabaseTable())));
    }

    @Override
    public boolean cleanup() {
        return false;
    }

    @NotNull
    private static String getTitle(Project project, VirtualFile file) {
        String string = VfsPresentationUtil.getPresentableNameForUI((Project)project, (VirtualFile)file);
        if (string == null) {
            DataGridSessionClient.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataGridSessionClient";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataGridSessionClient";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "focusOnError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showOnAttention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

