/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BatchIndicesEditorModel
extends EditorModelBase {
    public static final Function<DeIndex, Boolean> PREV_UNIQUE_GENERATOR = index2 -> ((DasIndex)ObjectUtils.assertNotNull((Object)((DasIndex)index2.getEditedObject()))).isUnique();
    public static final Function<DeIndex, Boolean> TRUE_UNIQUE_GENERATOR = index2 -> true;
    public static final Function<DeIndex, Boolean> FALSE_UNIQUE_GENERATOR = index2 -> false;
    public static final Consumer<List<DeIndex>> PREV_NAME_GENERATOR = new Consumer<List<DeIndex>>(){

        public void consume(List<DeIndex> indices) {
            for (DeIndex index2 : indices) {
                index2.name = ((DasObject)ObjectUtils.assertNotNull((Object)index2.getEditedObject())).getName();
            }
        }

        public String toString() {
            return "Using present names";
        }
    };
    public static final Consumer<List<DeIndex>> DEFAULT_NAME_GENERATOR = new PatternNameGenerator("{table}_{columns}_index");
    private final List<DeIndex> myIndices;
    private Consumer<List<DeIndex>> myNameGenerator;
    private Function<DeIndex, Boolean> myUniqueGenerator;

    @NotNull
    public Iterable<DeIndex> getIndices() {
        List<DeIndex> list = this.myIndices;
        if (list == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(0);
        }
        return list;
    }

    public BatchIndicesEditorModel(@NotNull List<DeIndex> indices, @NotNull DeModel model, @NotNull EditorModelsCache models) {
        if (indices == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(1);
        }
        if (model == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(2);
        }
        if (models == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(3);
        }
        super(model, models);
        this.myIndices = indices;
    }

    public void setNameGenerator(@NotNull Consumer<List<DeIndex>> generator) {
        if (generator == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(4);
        }
        if (Comparing.equal(generator, this.myNameGenerator)) {
            return;
        }
        this.myNameGenerator = generator;
        generator.consume(this.myIndices);
        this.modify();
    }

    @NotNull
    public Consumer<List<DeIndex>> getNameGenerator() {
        Consumer<List<DeIndex>> consumer2 = this.myNameGenerator;
        if (consumer2 == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(5);
        }
        return consumer2;
    }

    public void setUniqueGenerator(@NotNull Function<DeIndex, Boolean> generator) {
        if (generator == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(6);
        }
        if (Comparing.equal(generator, this.myUniqueGenerator)) {
            return;
        }
        this.myUniqueGenerator = generator;
        for (DeIndex index2 : this.myIndices) {
            index2.unique = (Boolean)generator.fun((Object)index2);
        }
        this.modify();
    }

    @NotNull
    public Function<DeIndex, Boolean> getUniqueGenerator() {
        Function<DeIndex, Boolean> function2 = this.myUniqueGenerator;
        if (function2 == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(7);
        }
        return function2;
    }

    @NotNull
    public ThreeState isUnique() {
        ThreeState res2 = ThreeState.UNSURE;
        for (DeIndex index2 : this.myIndices) {
            if (res2 == ThreeState.UNSURE) {
                res2 = ThreeState.fromBoolean((boolean)index2.unique);
                continue;
            }
            if (index2.unique == res2.toBoolean()) continue;
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                BatchIndicesEditorModel.$$$reportNull$$$0(8);
            }
            return threeState;
        }
        ThreeState threeState = res2;
        if (threeState == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(9);
        }
        return threeState;
    }

    @NotNull
    public JBIterable<DeIndex> getEditedObjects() {
        JBIterable jBIterable = JBIterable.from(this.myIndices);
        if (jBIterable == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/models/BatchIndicesEditorModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/models/BatchIndicesEditorModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueGenerator";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "isUnique";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditedObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNameGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setUniqueGenerator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PatternNameGenerator
    implements Consumer<List<DeIndex>> {
        private final String myPattern;

        public PatternNameGenerator(@NotNull String pattern) {
            if (pattern == null) {
                PatternNameGenerator.$$$reportNull$$$0(0);
            }
            this.myPattern = pattern;
        }

        @NotNull
        public String generate(@NotNull DeIndex index2) {
            if (index2 == null) {
                PatternNameGenerator.$$$reportNull$$$0(1);
            }
            String string = this.myPattern.replace("{table}", index2.table.name).replace("{columns}", StringUtil.join((Iterable)index2.getColumnsRef().names(), (String)"_"));
            if (string == null) {
                PatternNameGenerator.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatternNameGenerator generator = (PatternNameGenerator)o;
            return this.myPattern.equals(generator.myPattern);
        }

        public int hashCode() {
            return this.myPattern.hashCode();
        }

        public String toString() {
            return this.myPattern;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                PatternNameGenerator.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void consume(List<DeIndex> indices) {
            Map names = DasUtil.newCaseAwareMap((boolean)DasUtil.isCaseSensitive((Casing)indices.get((int)0).model.getCasing(ObjectKind.INDEX, null)));
            for (DeIndex index2 : indices) {
                index2.name = this.generate(index2);
                Integer integer = (Integer)names.get(index2.name);
                if (integer != null) {
                    integer = integer + 1;
                    names.put(index2.name, integer);
                    index2.name = index2.name + "_" + integer;
                    continue;
                }
                names.put(index2.name, 0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/models/BatchIndicesEditorModel$PatternNameGenerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/models/BatchIndicesEditorModel$PatternNameGenerator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

