/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.rename.inplace;

import com.intellij.database.Dbms;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInplaceRenameHandler
extends MemberInplaceRenameHandler {
    protected boolean isAvailable(@Nullable PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        if (!editor.getSettings().isVariableInplaceRenameEnabled()) {
            return false;
        }
        return SqlInplaceRenameHandler.isRenameable(element2);
    }

    public static boolean isRenameable(@Nullable PsiElement element2) {
        SqlNameElement nameElement;
        if (element2 instanceof SqlFileImpl.FakeDefinition) {
            return false;
        }
        SqlNameElement sqlNameElement = nameElement = element2 instanceof SqlDefinition ? ((SqlDefinition)element2).getNameElement() : null;
        if (nameElement == null && element2 instanceof SqlReferenceExpression && element2 instanceof PsiNameIdentifierOwner) {
            nameElement = ((SqlReferenceExpression)element2).getIdentifier();
        }
        return nameElement != null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element2, @NotNull PsiNameIdentifierOwner elementToRename, @NotNull Editor editor) {
        PsiElement identifier;
        if (element2 == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        if (elementToRename == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(4);
        }
        if ((identifier = elementToRename.getNameIdentifier()) != null) {
            MyMemberInplaceRenamer myMemberInplaceRenamer = new MyMemberInplaceRenamer(elementToRename, element2, editor);
            if (myMemberInplaceRenamer == null) {
                SqlInplaceRenameHandler.$$$reportNull$$$0(5);
            }
            return myMemberInplaceRenamer;
        }
        MemberInplaceRenamer memberInplaceRenamer = super.createMemberRenamer(element2, elementToRename, editor);
        if (memberInplaceRenamer == null) {
            SqlInplaceRenameHandler.$$$reportNull$$$0(6);
        }
        return memberInplaceRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemberRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createMemberRenamer";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMemberInplaceRenamer
    extends MemberInplaceRenamer {
        private String myForcedPrefix;

        MyMemberInplaceRenamer(@NotNull PsiNameIdentifierOwner elementToRename, PsiElement substituted, Editor editor) {
            if (elementToRename == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(0);
            }
            super((PsiNamedElement)elementToRename, substituted, editor);
            this.myForcedPrefix = MyMemberInplaceRenamer.getForcedPrefix((PsiNamedElement)elementToRename);
        }

        private MyMemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor, String initialName, String oldName) {
            if (elementToRename == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(1);
            }
            super(elementToRename, substituted, editor, initialName, oldName);
            this.myForcedPrefix = MyMemberInplaceRenamer.getForcedPrefix(elementToRename);
        }

        @Nullable
        private static String getForcedPrefix(@NotNull PsiNamedElement element2) {
            Dbms id;
            if (element2 == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(2);
            }
            if (!(id = SqlImplUtil.getSqlDialectSafe((PsiElement)element2).getDbms()).isTransactSql()) {
                return null;
            }
            if (element2 instanceof SqlVariableDefinition) {
                return "@";
            }
            return null;
        }

        protected boolean isIdentifier(String newName, Language l) {
            if (StringUtil.isEmpty((String)newName)) {
                return false;
            }
            if (!this.checkPrefix(newName)) {
                return false;
            }
            SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe(this.myScope);
            String realNewName = language.quoteIdentifier(this.myProject, newName);
            SqlReferenceExpression ref = SqlPsiElementFactory.createReferenceFromText(realNewName, language, SqlCompositeElementTypes.SQL_SHORT_REFERENCE, this.myScope);
            return ref != null && ref.getIdentifier() != null;
        }

        private boolean checkPrefix(@NotNull String name) {
            if (name == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(3);
            }
            return this.myForcedPrefix == null || name.startsWith(this.myForcedPrefix);
        }

        protected PsiElement getNameIdentifier() {
            PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            PsiFile psiFile = currentFile = currentFile == null ? null : SqlImplUtil.getTopLevelSqlFile(currentFile);
            if (currentFile == null || !PsiTreeUtil.isContextAncestor((PsiElement)currentFile, (PsiElement)this.myElementToRename, (boolean)false)) {
                return super.getNameIdentifier();
            }
            return this.myElementToRename instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)this.myElementToRename).getNameIdentifier() : null;
        }

        @NotNull
        protected TextRange getRangeToRename(@NotNull PsiReference reference) {
            SqlReferenceExpression expression;
            SqlIdentifier identifier;
            if (reference == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(4);
            }
            SqlIdentifier sqlIdentifier = identifier = (expression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)reference.getElement(), SqlReferenceExpression.class)) == null ? null : expression.getIdentifier();
            if (identifier != null) {
                TextRange textRange = identifier.getNameRange().shiftRight(identifier.getStartOffsetInParent());
                if (textRange == null) {
                    MyMemberInplaceRenamer.$$$reportNull$$$0(5);
                }
                return textRange;
            }
            TextRange textRange = super.getRangeToRename(reference);
            if (textRange == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(6);
            }
            return textRange;
        }

        @NotNull
        protected TextRange getRangeToRename(@NotNull PsiElement element2) {
            SqlIdentifier identifier;
            if (element2 == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(7);
            }
            PsiElement nameElement = element2;
            if (element2 instanceof SqlReferenceExpression) {
                nameElement = ((SqlReferenceExpression)element2).getIdentifier();
            }
            if ((identifier = (SqlIdentifier)ObjectUtils.tryCast((Object)nameElement, SqlIdentifier.class)) != null) {
                TextRange textRange = identifier.getNameRange().shiftRight(identifier.getStartOffsetInParent());
                if (textRange == null) {
                    MyMemberInplaceRenamer.$$$reportNull$$$0(8);
                }
                return textRange;
            }
            TextRange textRange = super.getRangeToRename(element2);
            if (textRange == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(9);
            }
            return textRange;
        }

        @NotNull
        protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
            MyMemberInplaceRenamer myMemberInplaceRenamer = new MyMemberInplaceRenamer(variable, this.getSubstituted(), editor, initialName, this.myOldName);
            if (myMemberInplaceRenamer == null) {
                MyMemberInplaceRenamer.$$$reportNull$$$0(10);
            }
            return myMemberInplaceRenamer;
        }

        protected boolean performRefactoring() {
            if (this.myInsertedName != null && !this.checkPrefix(this.myInsertedName)) {
                final PsiNamedElement variable = this.getVariable();
                if (variable != null) {
                    String cont = "Continue editing";
                    String cancel2 = "Cancel";
                    String ignore = "Rename anyway";
                    BaseListPopupStep<String> step = new BaseListPopupStep<String>("Identifier should start with `" + this.myForcedPrefix + "`", new String[]{"Continue editing", "Cancel", "Rename anyway"}){

                        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                            if (selectedValue.equals("Rename anyway")) {
                                myForcedPrefix = null;
                            }
                            this.performRefactoringRename(myInsertedName, myMarkAction);
                            int offset = variable.getTextOffset();
                            this.restoreCaretOffset(offset);
                            if (selectedValue.equals("Continue editing")) {
                                this.createInplaceRenamerToRestart(variable, myEditor, myInsertedName).performInplaceRefactoring(myNameSuggestions);
                            }
                            return FINAL_CHOICE;
                        }

                        public boolean isMnemonicsNavigationEnabled() {
                            return true;
                        }
                    };
                    step.setDefaultOptionIndex(0);
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(this.myEditor);
                }
                return true;
            }
            return super.performRefactoring();
        }

        protected boolean acceptReference(PsiReference reference) {
            String referenceText;
            PsiElement element2 = reference.getElement();
            if (element2 instanceof SqlReferenceExpression) {
                referenceText = ((SqlReferenceExpression)element2).getName();
            } else if (element2 instanceof SqlIdentifier) {
                referenceText = ((SqlIdentifier)element2).getName();
            } else {
                TextRange textRange = reference.getRangeInElement();
                referenceText = element2.getText().substring(textRange.getStartOffset(), textRange.getEndOffset());
            }
            return Comparing.strEqual((String)referenceText, (String)this.myElementToRename.getName(), (boolean)false);
        }

        protected SearchScope getReferencesSearchScope(VirtualFile file) {
            PsiElement scope = SqlImplUtil.getResolveScope(PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument()));
            return scope != null ? new LocalSearchScope(scope) : super.getReferencesSearchScope(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToRename";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/refactoring/rename/inplace/SqlInplaceRenameHandler$MyMemberInplaceRenamer";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeToRename";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInplaceRenamerToRestart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getForcedPrefix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "checkPrefix";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getRangeToRename";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

