/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.jetbrains.php.framework.FrameworkCurrentInputData;
import com.jetbrains.php.framework.completion.FrameworkLookupElement;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDataService;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkDocumentationProvider
extends DocumentationProviderEx {
    public static final Key<Object> FRAMEWORKS_PSI_ELEMENT_KEY = new Key("FRAMEWORKS_PSI_ELEMENT");
    private static final Key<FrameworkDocElement> FRAMEWORK_DUMMY_PSI_ELEMENT_KEY = new Key("FRAMEWORK_DUMMY_PSI_ELEMENT_KEY");

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        if (!(element instanceof FrameworkDocElement)) {
            return null;
        }
        return ((FrameworkDocElement)element).updateTitleAndGetHelp();
    }

    public FrameworkDocElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (!(object instanceof FrameworkLookupElement)) {
            return null;
        }
        FrameworkLookupElement lookupElement = (FrameworkLookupElement)object;
        PsiFile editorPsiFile = lookupElement.getPsiFile();
        FrameworkDocElement dummyFile = (FrameworkDocElement)((Object)editorPsiFile.getUserData(FRAMEWORK_DUMMY_PSI_ELEMENT_KEY));
        if (dummyFile == null) {
            dummyFile = FrameworkDocumentationProvider.initializeDummyFile(psiManager, (PsiElement)editorPsiFile, "");
        }
        dummyFile.updateWithLookupElement(lookupElement);
        return dummyFile;
    }

    private static FrameworkDocElement initializeDummyFile(PsiManager psiManager, @NotNull PsiElement originalElement, @Nullable String commandText) {
        if (originalElement == null) {
            FrameworkDocumentationProvider.$$$reportNull$$$0(0);
        }
        FrameworkDocElement docElement = new FrameworkDocElement(psiManager, commandText);
        originalElement.putUserData(FRAMEWORK_DUMMY_PSI_ELEMENT_KEY, (Object)docElement);
        return docElement;
    }

    @Nullable
    public FrameworkDocElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        if (editor == null) {
            FrameworkDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (file == null) {
            FrameworkDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (file.getUserData(FRAMEWORKS_PSI_ELEMENT_KEY) == null) {
            return null;
        }
        FrameworkDocElement dummyFile = (FrameworkDocElement)((Object)file.getUserData(FRAMEWORK_DUMMY_PSI_ELEMENT_KEY));
        if (dummyFile == null) {
            dummyFile = FrameworkDocumentationProvider.initializeDummyFile(file.getManager(), (PsiElement)file, file.getText());
        }
        dummyFile.updateWithSimpleText(file.getText());
        return dummyFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/framework/FrameworkDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeDummyFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomDocumentationElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FrameworkDocElement
    extends FakePsiElement {
        @NotNull
        private final PsiManager myPsiManager;
        @NotNull
        private final DummyHolder myDummyHolder;
        @Nullable
        private FrameworkLookupElement myLookupElement;
        private String myTitle;
        @Nullable
        private String myCommandText;

        private FrameworkDocElement(@NotNull PsiManager psiManager, @Nullable String commandText) {
            if (psiManager == null) {
                FrameworkDocElement.$$$reportNull$$$0(0);
            }
            this.myCommandText = "";
            this.myPsiManager = psiManager;
            this.myCommandText = commandText;
            this.myDummyHolder = DummyHolderFactory.createHolder((PsiManager)this.myPsiManager, null);
        }

        public void setTitle(String title) {
            this.myTitle = title;
        }

        public void updateWithLookupElement(@NotNull FrameworkLookupElement lookupElement) {
            if (lookupElement == null) {
                FrameworkDocElement.$$$reportNull$$$0(1);
            }
            this.myLookupElement = lookupElement;
            this.myCommandText = this.myLookupElement.getCommandForHelp();
        }

        public void updateWithSimpleText(@NotNull String commandText) {
            if (commandText == null) {
                FrameworkDocElement.$$$reportNull$$$0(2);
            }
            this.myLookupElement = null;
            this.myCommandText = commandText;
        }

        @NotNull
        public String getCommandText() {
            String string = StringUtil.notNullize((String)this.myCommandText);
            if (string == null) {
                FrameworkDocElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        public PsiElement getParent() {
            return this.myDummyHolder;
        }

        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                @Nullable
                public String getPresentableText() {
                    return myTitle;
                }

                @Nullable
                public String getLocationString() {
                    return null;
                }

                @Nullable
                public Icon getIcon(boolean unused) {
                    return null;
                }
            };
        }

        public PsiManager getManager() {
            return this.myPsiManager;
        }

        @Nullable
        public String updateTitleAndGetHelp() {
            if (this.myLookupElement != null) {
                this.setTitle(this.myLookupElement.getTitleForHelp());
                return this.myLookupElement.getHelp();
            }
            String providedDoc = FrameworkDocElement.findProvidedDoc(this);
            if (StringUtil.isEmpty((String)providedDoc)) {
                return null;
            }
            return providedDoc;
        }

        @Nullable
        private static String findProvidedDoc(FrameworkDocElement element) {
            FrameworkDataService dataService;
            String userText = element.getCommandText();
            FrameworkCurrentInputData data = FrameworkCurrentInputData.countInputData(userText, (dataService = FrameworkDataService.getInstance(element.getProject())).getCommands());
            FrameworkCommand command = data.findCommand(true, false);
            if (command == null) {
                Map<String, String> aliasesAndHelps = dataService.getAliasesAndHelp();
                for (String alias : aliasesAndHelps.keySet()) {
                    if (!userText.equals(alias = alias.trim()) && !userText.startsWith(alias + " ")) continue;
                    element.setTitle(alias);
                    return aliasesAndHelps.get(alias);
                }
                return null;
            }
            element.setTitle(command.getAliasedBasicText());
            return command.getHelp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookupElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandText";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/framework/FrameworkDocumentationProvider$FrameworkDocElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/framework/FrameworkDocumentationProvider$FrameworkDocElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updateWithLookupElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateWithSimpleText";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

