/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.util;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.util.TemplateMatcher;

public class NamedTemplateMatcher
extends TemplateMatcher {
    protected final String myName;

    public NamedTemplateMatcher(XmlDocument document, String name) {
        super(document);
        this.myName = name;
    }

    @Override
    protected boolean matches(XmlTag element) {
        if (XsltSupport.isTemplate(element, true)) {
            XmlAttribute attribute = element.getAttribute("name", null);
            if (this.myName == null || attribute != null && this.myName.equals(attribute.getValue())) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ResolveUtil.Matcher changeDocument(XmlDocument document) {
        return new NamedTemplateMatcher(document, this.myName);
    }

    @Override
    public ResolveUtil.Matcher variantMatcher() {
        return new NamedTemplateMatcher(this.myDocument, null);
    }
}

