/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.support.jaxen;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.context.functions.XPathFunctionProvider;
import org.intellij.plugins.xpathView.XPathExpressionGenerator;
import org.intellij.plugins.xpathView.support.XPathSupport;
import org.intellij.plugins.xpathView.support.jaxen.PsiXPath;
import org.intellij.plugins.xpathView.support.jaxen.extensions.FunctionImplementation;
import org.intellij.plugins.xpathView.util.Namespace;
import org.intellij.plugins.xpathView.util.NamespaceCollector;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.UnresolvableException;
import org.jaxen.XPath;
import org.jaxen.XPathFunctionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XPathSupportImpl
extends XPathSupport {
    private static final Logger LOG = Logger.getInstance((String)"org.intellij.plugins.xpathView.support.jaxen.XPathSupportImpl");

    XPathSupportImpl() {
    }

    @Override
    public XPath createXPath(@NotNull XmlFile file, String expression) throws JaxenException {
        if (file == null) {
            XPathSupportImpl.$$$reportNull$$$0(0);
        }
        PsiXPath xpath = new PsiXPath(file, expression);
        xpath.setFunctionContext((FunctionContext)new MyXPathFunctionContext());
        xpath.setNamespaceContext((NamespaceContext)new MySimpleNamespaceContext(NamespaceCollector.findNamespaces(file)));
        return xpath;
    }

    @Override
    public XPath createXPath(@Nullable XmlFile psiFile, String expression, @NotNull Collection<Namespace> namespaces) throws JaxenException {
        if (namespaces == null) {
            XPathSupportImpl.$$$reportNull$$$0(1);
        }
        PsiXPath xpath = new PsiXPath(psiFile, expression);
        xpath.setFunctionContext((FunctionContext)new MyXPathFunctionContext());
        xpath.setNamespaceContext((NamespaceContext)new MySimpleNamespaceContext(NamespaceCollector.convert(namespaces)));
        return xpath;
    }

    @Override
    public String getUniquePath(XmlElement element, XmlTag context) {
        return XPathExpressionGenerator.getUniquePath(element, context);
    }

    @Override
    public String getPath(XmlElement element, XmlTag context) {
        return XPathExpressionGenerator.getPath(element, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "namespaces";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/xpathView/support/jaxen/XPathSupportImpl";
        objectArray[2] = "createXPath";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyXPathFunctionContext
    extends XPathFunctionContext {
        MyXPathFunctionContext() {
            List<Pair<QName, ? extends Function>> functions = XPathFunctionProvider.getAvailableFunctions(XPathSupport.TYPE);
            for (Pair<QName, ? extends Function> function : functions) {
                String namespaceURI;
                Function f = (Function)function.getSecond();
                QName name = (QName)function.getFirst();
                String string = namespaceURI = "".equals(name.getNamespaceURI()) ? null : name.getNamespaceURI();
                if (f instanceof FunctionImplementation) {
                    this.registerFunction(namespaceURI, name.getLocalPart(), ((FunctionImplementation)f).getImplementation());
                    continue;
                }
                try {
                    super.getFunction(namespaceURI, name.getPrefix(), name.getLocalPart());
                }
                catch (UnresolvableException e) {
                    LOG.info("Warning: Unresolvable extension function: " + name + " - " + f);
                }
            }
        }
    }

    private static class MySimpleNamespaceContext
    extends SimpleNamespaceContext {
        MySimpleNamespaceContext(Map<String, String> map) {
            super(map);
        }

        public String translateNamespacePrefixToUri(String prefix) {
            String uri = super.translateNamespacePrefixToUri(prefix);
            if (prefix != null && prefix.length() > 0) {
                if (uri == null) {
                    LOG.debug("Undefined prefix: " + prefix);
                    return "urn:xpathview:undefined-namespace";
                }
                return uri;
            }
            LOG.debug("Empty prefix, returning null (uri=" + uri + ")");
            return null;
        }
    }
}

