/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.openapi.application.PathMacros;
import com.intellij.util.SmartList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

final class MacroComboBoxModel
extends AbstractListModel<String>
implements ComboBoxModel<String> {
    private boolean withModuleDir;
    private List<String> macros;
    private Object selected;

    MacroComboBoxModel() {
    }

    public void useModuleDir(boolean withModuleDir) {
        if (this.withModuleDir == withModuleDir) {
            return;
        }
        this.withModuleDir = withModuleDir;
        if (this.macros == null) {
            return;
        }
        this.macros = this.createMacros();
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null ? this.selected == null : item.equals(this.selected)) {
            return;
        }
        this.selected = item;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public int getSize() {
        List<String> list2 = this.getMacros();
        return list2.size();
    }

    @Override
    public String getElementAt(int index) {
        List<String> list2 = this.getMacros();
        return 0 <= index && index < list2.size() ? list2.get(index) : null;
    }

    public List<String> getMacros() {
        if (this.macros == null) {
            this.macros = this.createMacros();
        }
        return this.macros;
    }

    private List<String> createMacros() {
        SmartList list2 = new SmartList();
        for (String name : PathMacros.getInstance().getUserMacroNames()) {
            list2.add("$" + name + "$");
        }
        if (this.withModuleDir) {
            list2.add("$MODULE_WORKING_DIR$");
        }
        return list2;
    }
}

