/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.locationResolving.JSFileUrlMappings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.wip.WipScript;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\u0006H&J4\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/debugger/JSFileFinderBase;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "()V", "fileMappings", "Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "doFindFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "findByName", "", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "doFindUrls", "", "file", "findFile", "getRemoteUrls", "isFileMatchingScript", "setFileMappings", "", "map", "intellij.javascript.debugger"})
public abstract class JSFileFinderBase
implements DebuggableFileFinder {
    private volatile JSFileUrlMappings fileMappings = new JSFileUrlMappings();

    @Override
    @Nullable
    public final VirtualFile findFile(@NotNull Url url, @NotNull Project project, boolean findByName2, @Nullable String sourceContent, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.fileMappings.findFile(url, !findByName2, sourceContent, script, (Function0<? extends VirtualFile>)((Function0)new Function0<VirtualFile>(this, url, project, findByName2, sourceContent, script){
            final /* synthetic */ JSFileFinderBase this$0;
            final /* synthetic */ Url $url;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $findByName;
            final /* synthetic */ String $sourceContent;
            final /* synthetic */ Script $script;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final VirtualFile invoke() {
                void var1_1;
                VirtualFile result2 = this.this$0.doFindFile(this.$url, this.$project, this.$findByName, this.$sourceContent, this.$script);
                if (result2 != null && this.$script != null && !JSFileFinderBase.access$isFileMatchingScript(this.this$0, result2, this.$script)) {
                    result2 = null;
                }
                return var1_1;
            }
            {
                this.this$0 = jSFileFinderBase;
                this.$url = url;
                this.$project = project;
                this.$findByName = bl;
                this.$sourceContent = string;
                this.$script = script;
                super(0);
            }
        }));
    }

    @Nullable
    protected VirtualFile doFindFile(@NotNull Url url, @NotNull Project project, boolean findByName2, @Nullable String sourceContent, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return FileResolverByContentKt.resolveFileBySourceUrl(project, url, sourceContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isFileMatchingScript(VirtualFile file, Script script) {
        if (file.isDirectory()) {
            return false;
        }
        if (script.getLine() == 0) {
            Closeable closeable = new BufferedReader(new InputStreamReader(file.getInputStream(), file.getCharset()));
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)closeable;
                int c = reader.read();
                int count = 0;
                int newLineCount = 0;
                while (c != -1) {
                    ++count;
                    if (c == 10) {
                        ++newLineCount;
                    }
                    c = reader.read();
                }
                if (script.getEndLine() < newLineCount || script.getEndLine() > newLineCount + 2) {
                    JavaScriptDebugProcessKt.getLOG().debug("Incorrect file " + file.getCanonicalPath() + " found by url " + script.getUrl() + ": script.endLine = " + script.getEndLine() + ", file.endLine = " + newLineCount);
                    boolean bl = false;
                    return bl;
                }
                int sourceParam = ("\n//# sourceURL=" + script.getUrl()).length();
                if (script instanceof WipScript && ((WipScript)script).getLength() != count && ((WipScript)script).getLength() != count + 66 && ((WipScript)script).getLength() != count + 63 && ((WipScript)script).getLength() != count + 65 && ((WipScript)script).getLength() != count + 67 && (!((WipScript)script).getHasSourceURL() || ((WipScript)script).getLength() - sourceParam != count && ((WipScript)script).getLength() - sourceParam + 1 != count)) {
                    JavaScriptDebugProcessKt.getLOG().debug("Incorrect file " + file.getCanonicalPath() + " found by url " + script.getUrl() + ": script.length = " + ((WipScript)script).getLength() + ", " + "file.length = " + file.getLength());
                    boolean bl = false;
                    return bl;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public final List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.fileMappings.findUrls(file, (Function0<? extends List<? extends Url>>)((Function0)new Function0<List<? extends Url>>(this, file){
            final /* synthetic */ JSFileFinderBase this$0;
            final /* synthetic */ VirtualFile $file;

            @NotNull
            public final List<Url> invoke() {
                return this.this$0.doFindUrls(this.$file);
            }
            {
                this.this$0 = jSFileFinderBase;
                this.$file = virtualFile;
                super(0);
            }
        }));
    }

    @NotNull
    public abstract List<Url> doFindUrls(@NotNull VirtualFile var1);

    public final void setFileMappings(@NotNull JSFileUrlMappings map) {
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        this.fileMappings = map;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.findNavigatable(this, url, project);
    }

    @Override
    public boolean canSetRemoteUrl(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.canSetRemoteUrl(this, file, project);
    }

    @Override
    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return DebuggableFileFinder.DefaultImpls.isOnlySourceMappedBreakpoints(this, file);
    }

    public static final /* synthetic */ boolean access$isFileMatchingScript(JSFileFinderBase $this, @NotNull VirtualFile file, @NotNull Script script) {
        return $this.isFileMatchingScript(file, script);
    }
}

