/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class StringReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeValue(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in String Reference Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private final void executeValue(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        String str = (String)oid.getObject();
        JdwpString.writeString(os, str);
    }
}

