/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.gui.session.ToolsPopupAccessor;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.ISyntaxHighlightTokenMatcherFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.UndoHandlerImpl;
import net.sourceforge.squirrel_sql.client.session.parser.IParserEventsProcessorFactory;

public class EntryPanelManager {
    private ISession _session;
    private ISQLEntryPanel _entry;
    private JComponent _component;

    public EntryPanelManager(ISession session) {
        this._session = session;
    }

    public void init(ISyntaxHighlightTokenMatcherFactory syntaxHighlightTokenMatcherFactory, ToolsPopupAccessor tpa) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(IParserEventsProcessorFactory.class.getName(), null);
        if (null != syntaxHighlightTokenMatcherFactory) {
            props.put(ISyntaxHighlightTokenMatcherFactory.class.getName(), syntaxHighlightTokenMatcherFactory);
        }
        if (null != tpa) {
            props.put(ToolsPopupAccessor.class.getName(), tpa);
        }
        this._entry = this._session.getApplication().getSQLEntryPanelFactory().createSQLEntryPanel(this._session, props);
        this._component = this._entry.getTextComponent();
        if (!this._entry.getDoesTextComponentHaveScroller()) {
            this._component = new JScrollPane(this._entry.getTextComponent());
            this._component.setBorder(BorderFactory.createEmptyBorder());
        }
        new UndoHandlerImpl(this._session.getApplication(), this._entry);
    }

    public JComponent getComponent() {
        this.checkInit();
        return this._component;
    }

    private void checkInit() {
        if (null == this._component) {
            throw new IllegalStateException("Call init() before using this object");
        }
    }

    public ISQLEntryPanel getEntryPanel() {
        this.checkInit();
        return this._entry;
    }

    public void requestFocus() {
        this.checkInit();
        this._entry.requestFocus();
    }

    protected ISession getSession() {
        return this._session;
    }
}

