/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.provisional.service.security;

import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEvent;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationListener;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AuthorizationEngine {
    private EventManager manager = new EventManager();
    private EventDispatcher dispatcher = new AuthEventDispatcher();
    private final ServiceTracker listenerTracker;
    static /* synthetic */ Class class$0;

    public AuthorizationEngine(BundleContext context) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.service.security.AuthorizationListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerTracker = new ServiceTracker(context, clazz.getName(), null);
        this.listenerTracker.open();
    }

    public final void authorize(SignedContent content, Object context) {
        this.fireEvent(this.doAuthorize(content, context));
    }

    private void fireEvent(AuthorizationEvent event) {
        if (event == null) {
            return;
        }
        Object[] services = this.listenerTracker.getServices();
        if (services == null) {
            return;
        }
        CopyOnWriteIdentityMap listeners = new CopyOnWriteIdentityMap();
        listeners.putAll(services);
        ListenerQueue queue = new ListenerQueue(this.manager);
        queue.queueListeners(listeners.entrySet(), this.dispatcher);
        queue.dispatchEventSynchronous(0, event);
    }

    protected abstract AuthorizationEvent doAuthorize(SignedContent var1, Object var2);

    public abstract int getStatus();

    class AuthEventDispatcher
    implements EventDispatcher {
        AuthEventDispatcher() {
        }

        public void dispatchEvent(Object eventListener, Object listenerObject, int eventAction, Object eventObject) {
            ((AuthorizationListener)eventListener).authorizationEvent((AuthorizationEvent)eventObject);
        }
    }
}

