/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Point;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintView;
import net.sourceforge.squirrel_sql.plugins.graph.FoldingPoint;
import net.sourceforge.squirrel_sql.plugins.graph.GraphComponent;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopPane;
import net.sourceforge.squirrel_sql.plugins.graph.GroupDissolveChecker;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrame;

public class GraphDesktopManager
extends DefaultDesktopManager {
    private GraphDesktopPane _graphDesktopPane;
    private HashSet<FoldingPoint> _uniqueFoldingPointsBuffer = new HashSet();
    private GroupDissolveChecker _groupDissolveChecker = new GroupDissolveChecker();

    public GraphDesktopManager(GraphDesktopPane graphDesktopPane) {
        this._graphDesktopPane = graphDesktopPane;
    }

    @Override
    public void dragFrame(JComponent f, int newX, int newY) {
        int correctX = newX;
        int correctY = newY;
        if (f instanceof TableFrame) {
            TableFrame tf = (TableFrame)f;
            Point correctDelta = this.checkBounds(newX - f.getX(), newY - f.getY(), this._graphDesktopPane);
            correctX = f.getX() + correctDelta.x;
            correctY = f.getY() + correctDelta.y;
            this._groupDissolveChecker.tolerantlyCheckGroupDissolve(tf, correctDelta, this._graphDesktopPane);
            for (TableFrame current : this._graphDesktopPane.getGroupFrames()) {
                if (current == tf) continue;
                Point newLocation = new Point(current.getX() + correctDelta.x, current.getY() + correctDelta.y);
                current.setLocation(newLocation);
            }
            this.moveFoldingPoints(this._graphDesktopPane.getGroupFrames(), correctDelta);
        }
        super.dragFrame(f, correctX, correctY);
        this._graphDesktopPane.repaint();
    }

    private void moveFoldingPoints(List<TableFrame> movedTableFrames, Point delta) {
        for (TableFrame f1 : movedTableFrames) {
            for (TableFrame f2 : movedTableFrames) {
                if (f1 == f2) continue;
                this.fillFoldingPointsBetween(this._uniqueFoldingPointsBuffer, f1, f2);
            }
        }
        for (FoldingPoint fp : this._uniqueFoldingPointsBuffer) {
            fp.moveBy(delta);
        }
        this._uniqueFoldingPointsBuffer.clear();
    }

    private void fillFoldingPointsBetween(HashSet<FoldingPoint> toFill, TableFrame f1, TableFrame f2) {
        Vector<GraphComponent> graphComponents = this._graphDesktopPane.getGraphComponents();
        for (GraphComponent graphComponent : graphComponents) {
            ConstraintView cv;
            if (!(graphComponent instanceof ConstraintView) || 0 >= (cv = (ConstraintView)graphComponent).getFoldingPoints().size() || !cv.isAttachedTo(f1) || !cv.isAttachedTo(f2)) continue;
            Vector<FoldingPoint> pointVector = cv.getFoldingPoints();
            for (FoldingPoint foldingPoint : pointVector) {
                toFill.add(foldingPoint);
            }
        }
    }

    @Override
    public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        if (f instanceof TableFrame) {
            TableFrame tf = (TableFrame)f;
            if (!this._graphDesktopPane.isGroupFrame(tf)) {
                this._graphDesktopPane.setGroupFrame(tf);
            }
            Point delta = new Point(newX - f.getX(), newY - f.getY());
            for (TableFrame current : this._graphDesktopPane.getGroupFrames()) {
                if (current == f) continue;
                current.setBounds(current.getX() + delta.x, current.getY() + delta.y, newWidth, newHeight);
            }
        }
        super.resizeFrame(f, newX, newY, newWidth, newHeight);
    }

    private Point checkBounds(int deltaX, int deltaY, GraphDesktopPane desktopPane) {
        Point rc = new Point(deltaX, deltaY);
        for (TableFrame current : desktopPane.getGroupFrames()) {
            Point newLocation = new Point(current.getX() + deltaX, current.getY() + deltaY);
            if (newLocation.x < 0 && rc.x < -current.getX()) {
                rc.x = -current.getX();
            }
            if (newLocation.y >= 0 || rc.y >= -current.getY()) continue;
            rc.y = -current.getY();
        }
        return rc;
    }
}

