/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.xmlbeans;

import java.io.File;
import java.io.IOException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphUtil;
import net.sourceforge.squirrel_sql.plugins.graph.link.LinkXmlBean;

public class DefaultGraphXmlSerializerConfig {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DefaultGraphXmlSerializerConfig.class);
    public static final String XML_BEAN_POSTFIX = ".graph.xml";
    public static final String LINK_PREFIX = "lnk_";
    GraphPlugin _plugin;
    private ISession _session;
    private String _graphFilePath;
    private LinkXmlBean _linkXmlBean;
    private String _pathOfLinkXmlFile;
    private String _title;

    public DefaultGraphXmlSerializerConfig(GraphPlugin plugin, ISession session, LinkXmlBean linkXmlBean, String pathOfLinkXmlFile) {
        this._linkXmlBean = linkXmlBean;
        this._pathOfLinkXmlFile = pathOfLinkXmlFile;
        this._init(plugin, session, this._linkXmlBean.getFilePathOfLinkedGraph());
    }

    public DefaultGraphXmlSerializerConfig(GraphPlugin plugin, ISession session, String graphFileName) {
        this._init(plugin, session, graphFileName);
    }

    private void _init(GraphPlugin plugin, ISession session, String graphFileName) {
        this._plugin = plugin;
        this._session = session;
        this._title = this._plugin.patchName(s_stringMgr.getString("graph.newGraph"), this._session);
        this._graphFilePath = null == graphFileName ? this.generateGraphFilePath(this._title) : graphFileName;
    }

    private String generateGraphFilePath(String title) {
        try {
            String url = this._session.getAlias().getUrl();
            return this.getFileName(this._plugin.getPluginUserSettingsFolder().getPath(), url, title);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLink() {
        return null != this._linkXmlBean;
    }

    public String getGraphFilePath() {
        return this._graphFilePath;
    }

    public LinkXmlBean getLinkXmlBean() {
        return this._linkXmlBean;
    }

    public void renameGraph(String newGraphName) {
        try {
            String url = this._session.getAlias().getUrl();
            String newGraphFile = this.getFileName(this._plugin.getPluginUserSettingsFolder().getPath(), url, newGraphName);
            if (new File(this._graphFilePath).exists()) {
                if (!new File(this._graphFilePath).renameTo(new File(newGraphFile))) {
                    String msg = "Failed to rename file: " + this._graphFilePath;
                    this._session.showErrorMessage(msg);
                    throw new IllegalStateException(msg);
                }
                String[] params = new String[]{this._graphFilePath, newGraphFile};
                this._session.showMessage(s_stringMgr.getString("graph.graphRenamed", params));
            }
            this._graphFilePath = newGraphFile;
            this._title = newGraphName;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getLinkPrefix(ISession session) {
        return LINK_PREFIX + StringUtilities.javaNormalize((String)session.getAlias().getUrl()) + ".";
    }

    private String getFileName(String path, String url, String title) {
        String graphFileName = GraphUtil.createGraphFileName(url, this._plugin.patchName(title, this._session));
        return path + File.separator + graphFileName + XML_BEAN_POSTFIX;
    }

    public String getTitle() {
        if (this.isLink()) {
            return this._linkXmlBean.getLinkName();
        }
        return this._title;
    }

    public void transformToLocalCopy() {
        try {
            String linkName = new File(this._pathOfLinkXmlFile).getName();
            String newGraphsName = linkName.substring(LINK_PREFIX.length(), linkName.length());
            this._graphFilePath = new File(this._plugin.getPluginUserSettingsFolder().getPath(), newGraphsName).getAbsolutePath();
            this._linkXmlBean = null;
            new File(this._pathOfLinkXmlFile).delete();
            this._pathOfLinkXmlFile = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkTargetWritable() {
        if (this.isLink() && !new File(this._graphFilePath).canWrite()) {
            String msg = s_stringMgr.getString("graph.link.cannotWrite", new Object[]{this._linkXmlBean.getNameOfLinkedGraph(), this._graphFilePath, this._pathOfLinkXmlFile});
            this._session.getApplication().getMessageHandler().showErrorMessage(msg);
            throw new IllegalStateException(msg);
        }
    }

    public void removeLink() {
        if (!this.isLink()) {
            throw new IllegalStateException("Not a link");
        }
        if (!new File(this._pathOfLinkXmlFile).delete()) {
            String msg = "Failed to remove link file: " + this._pathOfLinkXmlFile;
            this._session.showErrorMessage(msg);
            throw new IllegalStateException(msg);
        }
        this._session.showMessage(s_stringMgr.getString("graph.graphLinkRemoved", new Object[]{this._pathOfLinkXmlFile}));
    }

    public void setTitle(String title) {
        this._title = title;
        this._graphFilePath = this.generateGraphFilePath(title);
    }

    public boolean isLoadable() {
        return this.isLink() || null != this._graphFilePath && new File(this._graphFilePath).exists();
    }

    public void removeGraphFile() {
        if (new File(this._graphFilePath).exists()) {
            if (!new File(this._graphFilePath).delete()) {
                String msg = "Failed to remove file: " + this._graphFilePath;
                this._session.showErrorMessage(msg);
                throw new IllegalStateException(msg);
            }
            String[] params = new String[]{this._graphFilePath};
            this._session.showMessage(s_stringMgr.getString("graph.graphRemoved", params));
        }
    }

    public String getPathOfLinkXmlFile() {
        if (!this.isLink()) {
            throw new IllegalStateException("Not a link");
        }
        return this._pathOfLinkXmlFile;
    }
}

