/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolTipUI;

public class BaseToolTipUI
extends MetalToolTipUI {
    private boolean fancyLayout = false;
    private ComponentListener popupWindowListener = null;

    public static ComponentUI createUI(JComponent c) {
        return new BaseToolTipUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        int borderSize = AbstractLookAndFeel.getTheme().getTooltipBorderSize();
        int shadowSize = AbstractLookAndFeel.getTheme().getTooltipShadowSize();
        boolean bl = this.fancyLayout = DecorationHelper.isTranslucentWindowSupported() && ToolTipManager.sharedInstance().isLightWeightPopupEnabled();
        if (this.fancyLayout) {
            c.setBorder(BorderFactory.createEmptyBorder(borderSize, borderSize + shadowSize, borderSize + shadowSize, borderSize + shadowSize));
            c.setOpaque(false);
            Container parent = c.getParent();
            if (parent instanceof JPanel) {
                ((JPanel)c.getParent()).setOpaque(false);
            }
        } else {
            c.setBorder(BorderFactory.createEmptyBorder(borderSize, borderSize, borderSize, borderSize));
        }
    }

    protected void installListeners(JComponent c) {
        super.installListeners(c);
        this.popupWindowListener = new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                Window window = (Window)e.getComponent();
                DecorationHelper.setTranslucentWindow(window, false);
                window.removeComponentListener(BaseToolTipUI.this.popupWindowListener);
            }
        };
    }

    public void paint(Graphics g, JComponent c) {
        Container parent;
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposit = g2D.getComposite();
        Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int borderSize = AbstractLookAndFeel.getTheme().getTooltipBorderSize();
        int shadowSize = AbstractLookAndFeel.getTheme().getTooltipShadowSize();
        int w = c.getWidth();
        int h = c.getHeight();
        ColorUIResource backColor = AbstractLookAndFeel.getTheme().getTooltipBackgroundColor();
        boolean mediumWeight = false;
        for (parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getClass().getName().indexOf("MediumWeight") <= 0) continue;
            mediumWeight = true;
            break;
        }
        if (!mediumWeight && this.fancyLayout && shadowSize > 0) {
            Color cLo;
            Color cHi;
            for (parent = c.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getClass().getName().indexOf("HeavyWeightWindow") <= 0 || !(parent instanceof Window)) continue;
                Window window = (Window)parent;
                window.addComponentListener(this.popupWindowListener);
                DecorationHelper.setTranslucentWindow(window, true);
                break;
            }
            g2D.setColor(AbstractLookAndFeel.getTheme().getShadowColor());
            float[] composites = new float[]{0.01f, 0.02f, 0.04f, 0.06f, 0.08f, 0.12f};
            int shadowOffset = AbstractLookAndFeel.getTheme().isTooltipCastShadow() ? shadowSize : 0;
            for (int i = 0; i < shadowSize; ++i) {
                g2D.setComposite(AlphaComposite.getInstance(3, composites[i >= composites.length ? composites.length - 1 : i]));
                g2D.fillRoundRect(i + shadowOffset, borderSize + i, w - 2 * i - shadowOffset, h - borderSize - 2 * i, 12 - i, 12 - i);
            }
            g2D.setComposite(savedComposit);
            if (ColorHelper.getGrayValue(backColor) < 128) {
                g2D.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getBackgroundColor(), 20.0));
            } else {
                g2D.setColor(Color.white);
            }
            g2D.fillRoundRect(shadowSize, 0, w - 2 * shadowSize - 1, h - shadowSize - 1, shadowSize, shadowSize);
            g2D.setColor(ColorHelper.darker(backColor, 40.0));
            g2D.drawRoundRect(shadowSize, 0, w - 2 * shadowSize - 1, h - shadowSize - 1, shadowSize, shadowSize);
            g2D.setColor(ColorHelper.darker(backColor, 10.0));
            g2D.drawRect(borderSize + shadowSize - 1, borderSize - 1, w - 2 * borderSize - 2 * shadowSize + 1, h - 2 * borderSize - shadowSize + 1);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            BufferedImage bi = new BufferedImage(w, h, 1);
            Graphics2D big = bi.createGraphics();
            big.setClip(0, 0, w, h);
            Paint savedPaint = big.getPaint();
            if (ColorHelper.getGrayValue(backColor) < 128) {
                cHi = ColorHelper.brighter(backColor, 10.0);
                cLo = ColorHelper.darker(backColor, 20.0);
            } else {
                cHi = ColorHelper.brighter(backColor, 40.0);
                cLo = ColorHelper.darker(backColor, 5.0);
            }
            big.setPaint(new GradientPaint(0.0f, borderSize, cHi, 0.0f, h - 2 * borderSize - shadowSize, cLo));
            big.fillRect(borderSize + shadowSize, borderSize, w - 2 * borderSize - 2 * shadowSize, h - 2 * borderSize - shadowSize);
            big.setPaint(savedPaint);
            if (c instanceof JToolTip) {
                JToolTip tip = (JToolTip)c;
                if (tip.getComponent() != null && tip.getComponent().isEnabled()) {
                    c.setForeground(AbstractLookAndFeel.getTheme().getTooltipForegroundColor());
                } else {
                    c.setForeground(AbstractLookAndFeel.getTheme().getDisabledForegroundColor());
                }
            }
            super.paint(big, c);
            g2D.setClip(borderSize + shadowSize, borderSize, w - 2 * borderSize - 2 * shadowSize, h - 2 * borderSize - shadowSize);
            g2D.drawImage((Image)bi, 0, 0, null);
        } else {
            Color cLo;
            Color cHi;
            if (ColorHelper.getGrayValue(backColor) < 128) {
                g2D.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getBackgroundColor(), 20.0));
            } else {
                g2D.setColor(Color.white);
            }
            g2D.fillRect(0, 0, w, h);
            g2D.setColor(ColorHelper.darker(backColor, 40.0));
            g2D.drawRect(0, 0, w - 1, h - 1);
            g2D.setColor(ColorHelper.darker(backColor, 10.0));
            g2D.drawRect(borderSize - 1, borderSize - 1, w - (2 * borderSize - 1), h - (2 * borderSize - 1));
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            Paint savedPaint = g2D.getPaint();
            if (ColorHelper.getGrayValue(backColor) < 128) {
                cHi = ColorHelper.brighter(backColor, 10.0);
                cLo = ColorHelper.darker(backColor, 20.0);
            } else {
                cHi = ColorHelper.brighter(backColor, 40.0);
                cLo = ColorHelper.darker(backColor, 5.0);
            }
            g2D.setPaint(new GradientPaint(0.0f, borderSize, cHi, 0.0f, h - 2 * borderSize, cLo));
            g2D.fillRect(borderSize, borderSize, w - 2 * borderSize, h - 2 * borderSize);
            g2D.setPaint(savedPaint);
            super.paint(g, c);
        }
    }
}

