/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockDropReceiver;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.SplitContainer;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockEvent;
import com.vlsolutions.swing.docking.event.DockingActionSplitComponentEvent;
import com.vlsolutions.swing.docking.event.DockingActionSplitDockableContainerEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class DockingPanel
extends JPanel
implements DockDropReceiver {
    private static final long serialVersionUID = 1L;

    public DockingPanel() {
        super(new BorderLayout());
    }

    @Override
    public void processDockableDrag(DockDragEvent event) {
        this.scanContainer(event, false);
    }

    @Override
    public void processDockableDrop(DockDropEvent event) {
        this.scanContainer(event, true);
    }

    private void acceptDrop(DockEvent event, DockingConstants.Split position) {
        Container dragContainer = event.getDragSource().getDockableContainer();
        ((DockDropEvent)event).acceptDrop();
        if (dragContainer instanceof TabbedDockableContainer) {
            event.getDesktop().splitComponent((Component)this, dragContainer, position);
        } else {
            event.getDesktop().splitComponent((Component)this, event.getDragSource().getDockable(), position);
        }
    }

    private void acceptDrag(DockEvent event, DockingConstants.Split position, Shape shape) {
        Container dragContainer = event.getDragSource().getDockableContainer();
        Dockable dockable = event.getDragSource().getDockable();
        DockableState.Location initialState = dockable.getDockKey().getLocation();
        DockableState.Location nextState = DockableState.Location.DOCKED;
        if (dragContainer instanceof TabbedDockableContainer) {
            event.setDockingAction(new DockingActionSplitDockableContainerEvent(event.getDesktop(), initialState, nextState, this, dragContainer, position, 0.5f));
        } else {
            event.setDockingAction(new DockingActionSplitComponentEvent(event.getDesktop(), dockable, initialState, nextState, this, position, 0.5f));
        }
        ((DockDragEvent)event).acceptDrag(shape);
    }

    private void scanContainer(DockEvent event, boolean drop) {
        Point p = event.getMouseEvent().getPoint();
        Rectangle compBounds = this.getBounds();
        int distTop = p.y;
        int distLeft = p.x;
        int min = Math.min(distTop, distLeft);
        int distRight = compBounds.width - p.x;
        int distBottom = compBounds.height - p.y;
        int min2 = Math.min(distBottom, distRight);
        min = Math.min(min, min2);
        Dimension size = this.getSize();
        Dockable dragged = event.getDragSource().getDockable();
        Dimension draggedSize = dragged.getComponent().getParent().getSize();
        int bestHeight = (int)Math.min((double)draggedSize.height, (double)size.height * 0.5);
        int bestWidth = (int)Math.min((double)draggedSize.width, (double)size.width * 0.5);
        if (min == distTop) {
            if (drop) {
                this.acceptDrop(event, DockingConstants.SPLIT_TOP);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(0.0f, 0.0f, compBounds.width, bestHeight);
                this.acceptDrag(event, DockingConstants.SPLIT_TOP, r2d);
            }
        } else if (min == distLeft) {
            if (drop) {
                this.acceptDrop(event, DockingConstants.SPLIT_LEFT);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(0.0f, 0.0f, bestWidth, compBounds.height);
                this.acceptDrag(event, DockingConstants.SPLIT_LEFT, r2d);
            }
        } else if (min == distBottom) {
            if (drop) {
                this.acceptDrop(event, DockingConstants.SPLIT_BOTTOM);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(0.0f, compBounds.height - bestHeight, compBounds.width, bestHeight);
                this.acceptDrag(event, DockingConstants.SPLIT_BOTTOM, r2d);
            }
        } else if (drop) {
            this.acceptDrop(event, DockingConstants.SPLIT_RIGHT);
        } else {
            Rectangle2D.Float r2d = new Rectangle2D.Float(compBounds.width - bestWidth, 0.0f, bestWidth, compBounds.height);
            this.acceptDrag(event, DockingConstants.SPLIT_RIGHT, r2d);
        }
    }

    public void resetToPreferredSize() {
        Component mainComp = this.getComponent(0);
        if (mainComp instanceof SplitContainer) {
            ((SplitContainer)mainComp).resetToPreferredSizes();
        }
    }

    @Override
    public String toString() {
        return "DockingPanel[" + this.hashCode() + "]";
    }
}

