/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.util.Token;

public final class FuzzyMatcher {
    private FuzzyMatcher() {
    }

    public static byte[] buildSimilarityData(Token[] sourceTokens, Token[] matchTokens) {
        int len = matchTokens.length;
        byte[] result = new byte[len];
        boolean leftfound = true;
        for (int i = 0; i < len; ++i) {
            result[i] = 0;
            Token righttoken = null;
            if (i + 1 < len) {
                righttoken = matchTokens[i + 1];
            }
            boolean rightfound = i + 1 == len || DefaultTokenizer.isContains(sourceTokens, righttoken);
            Token token = matchTokens[i];
            boolean found = DefaultTokenizer.isContains(sourceTokens, token);
            if (!(!found || leftfound && rightfound)) {
                result[i] = 2;
            } else if (!found) {
                result[i] = 1;
            }
            leftfound = found;
        }
        return result;
    }

    public static int calcSimilarity(ISimilarityCalculator distanceCalculator, Token[] str, Token[] cand) {
        if (str.length == 0 && cand.length == 0) {
            return 0;
        }
        int ld = distanceCalculator.compute(str, cand);
        int similarity = 100 * (Math.max(str.length, cand.length) - ld) / Math.max(str.length, cand.length);
        return similarity;
    }
}

