/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2.impl;

import gen.core.project.RepositoryDefinition;
import java.io.File;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.omegat.core.team2.IRemoteRepository2;
import org.omegat.core.team2.ProjectTeamSettings;
import org.omegat.core.team2.impl.SVNAuthenticationManager;
import org.omegat.util.Log;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNRemoteRepository2
implements IRemoteRepository2 {
    private static final Logger LOGGER = Logger.getLogger(SVNRemoteRepository2.class.getName());
    RepositoryDefinition config;
    File baseDirectory;
    SVNClientManager ourClientManager;
    ProjectTeamSettings projectTeamSettings;

    @Override
    public void init(RepositoryDefinition repo, File dir, ProjectTeamSettings teamSettings) throws Exception {
        this.config = repo;
        this.baseDirectory = dir;
        this.projectTeamSettings = teamSettings;
        String predefinedUser = repo.getOtherAttributes().get(new QName("svnUsername"));
        String predefinedPass = repo.getOtherAttributes().get(new QName("svnPassword"));
        if (predefinedUser == null) {
            predefinedUser = SVNURL.parseURIEncoded((String)repo.getUrl()).getUserInfo();
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        SVNAuthenticationManager authManager = new SVNAuthenticationManager(repo.getUrl(), predefinedUser, predefinedPass, teamSettings);
        this.ourClientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
        if (this.baseDirectory.exists()) {
            this.ourClientManager.getWCClient().doCleanup(this.baseDirectory);
            this.ourClientManager.getWCClient().doRevert(new File[]{this.baseDirectory}, SVNDepth.fromRecurse((boolean)true), null);
        }
    }

    @Override
    public String getFileVersion(String file) throws Exception {
        File f = new File(this.baseDirectory, file);
        if (!f.exists()) {
            return null;
        }
        SVNInfo info = this.ourClientManager.getWCClient().doInfo(f, SVNRevision.BASE);
        Log.logDebug(LOGGER, "SVN committed revision for file {0} is {1}", file, info.getCommittedRevision().getNumber());
        return Long.toString(info.getCommittedRevision().getNumber());
    }

    @Override
    public void switchToVersion(String version) throws Exception {
        Log.logInfoRB("SVN_START", "checkout to " + version);
        SVNURL url = SVNURL.parseURIEncoded((String)SVNEncodingUtil.autoURIEncode((String)this.config.getUrl()));
        SVNRevision toRev = version != null ? SVNRevision.create((long)Long.parseLong(version)) : SVNRevision.HEAD;
        try {
            this.ourClientManager.getUpdateClient().doCheckout(url, this.baseDirectory, SVNRevision.HEAD, toRev, SVNDepth.INFINITY, false);
            Log.logInfoRB("SVN_FINISH", "checkout");
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "checkout", ex.getMessage());
            this.checkNetworkException(ex);
            throw ex;
        }
    }

    @Override
    public void addForCommit(String path) throws Exception {
        File f = new File(this.baseDirectory, path);
        this.ourClientManager.getWCClient().doAdd(f, true, false, true, SVNDepth.EMPTY, false, true);
    }

    @Override
    public void addForDeletion(String path) throws Exception {
        File f = new File(this.baseDirectory, path);
        this.ourClientManager.getWCClient().doDelete(f, true, false);
    }

    @Override
    public File getLocalDirectory() {
        return this.baseDirectory;
    }

    @Override
    public String[] getRecentlyDeletedFiles() throws Exception {
        final ArrayList deleted = new ArrayList();
        SVNInfo info = this.ourClientManager.getWCClient().doInfo(this.baseDirectory, SVNRevision.HEAD);
        SVNRevision currentRevision = info.getRevision();
        String settingKey = "lastDeleteCheckForName" + this.baseDirectory.getName();
        String sinceRevisionString = this.projectTeamSettings.get(settingKey);
        final SVNRevision sinceRevision = sinceRevisionString == null ? currentRevision : SVNRevision.parse((String)sinceRevisionString);
        final String repoPath = info.getPath();
        try {
            this.ourClientManager.getLogClient().doLog(new File[]{this.baseDirectory}, sinceRevision, currentRevision, false, true, 1000000L, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry en) throws SVNException {
                    if (en.getRevision() == sinceRevision.getNumber()) {
                        return;
                    }
                    Map changedPaths = en.getChangedPaths();
                    String prefix = "/" + repoPath + "/";
                    int prefixSize = prefix.length();
                    for (Map.Entry entry : changedPaths.entrySet()) {
                        SVNLogEntryPath path = (SVNLogEntryPath)entry.getValue();
                        String filePath = path.getPath();
                        if ("".equals(repoPath)) {
                            filePath = filePath.substring(1);
                        } else {
                            if (!filePath.startsWith(prefix)) continue;
                            filePath = filePath.substring(prefixSize);
                        }
                        filePath = filePath.replace('/', File.separatorChar);
                        if (path.getType() == 'D') {
                            deleted.add(filePath);
                            continue;
                        }
                        if (path.getType() != 'A') continue;
                        deleted.remove(filePath);
                    }
                }
            });
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
        this.projectTeamSettings.set(settingKey, Long.toString(currentRevision.getNumber()));
        String[] result = new String[deleted.size()];
        return deleted.toArray(result);
    }

    @Override
    public String commit(String[] onVersions, String comment) throws Exception {
        Log.logInfoRB("SVN_START", "commit");
        File[] forCommit = new File[]{this.baseDirectory};
        try {
            SVNCommitInfo info = this.ourClientManager.getCommitClient().doCommit(forCommit, false, comment, null, null, false, false, SVNDepth.INFINITY);
            Log.logDebug(LOGGER, "SVN committed into new revision {0}", info.getNewRevision());
            if (info.getNewRevision() < 0L) {
                info = new SVNCommitInfo(Long.parseLong(this.getFileVersion("")), null, null, null);
            }
            Log.logInfoRB("SVN_FINISH", "commit");
            return Long.toString(info.getNewRevision());
        }
        catch (SVNException ex) {
            if (Arrays.asList(SVNErrorCode.FS_TXN_OUT_OF_DATE, SVNErrorCode.WC_NOT_UP_TO_DATE, SVNErrorCode.FS_CONFLICT).contains(ex.getErrorMessage().getErrorCode())) {
                Log.logWarningRB("SVN_CONFLICT", new Object[0]);
                this.ourClientManager.getWCClient().doRevert(new File[]{this.baseDirectory}, SVNDepth.fromRecurse((boolean)true), null);
                return null;
            }
            Log.logErrorRB("SVN_ERROR", "commit", ex.getMessage());
            this.checkNetworkException((Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "commit", ex.getMessage());
            throw ex;
        }
    }

    void checkNetworkException(Exception ex) throws IRemoteRepository2.NetworkException {
        if (ex.getCause() instanceof SocketException) {
            throw new IRemoteRepository2.NetworkException(ex.getCause());
        }
        if (ex instanceof SVNException) {
            SVNException se = (SVNException)((Object)ex);
            if (se.getErrorMessage().getErrorCode().getCategory() == 175000) {
                throw new IRemoteRepository2.NetworkException(se);
            }
            if (Arrays.asList(SVNErrorCode.RA_SVN_IO_ERROR, SVNErrorCode.RA_SVN_CONNECTION_CLOSED).contains(se.getErrorMessage().getErrorCode())) {
                throw new IRemoteRepository2.NetworkException(se);
            }
        }
    }

    public static boolean isSVNRepository(String url) {
        try {
            DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
            SVNClientManager ourClientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)null);
            ourClientManager.getWCClient().doInfo(SVNURL.parseURIEncoded((String)SVNEncodingUtil.autoURIEncode((String)url)), SVNRevision.HEAD, SVNRevision.HEAD);
        }
        catch (SVNAuthenticationException ex) {
            return true;
        }
        catch (SVNException ex) {
            return false;
        }
        return true;
    }
}

