/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Arrays;
import org.trie4j.bv.SuccinctBitVector;

public class BytesRank1OnlySuccinctBitVector
implements Externalizable,
SuccinctBitVector {
    private static final int CACHE_WIDTH = 64;
    private byte[] bytes;
    private int size;
    private int[] countCache1;
    private static final int[] MASKS = new int[]{128, 192, 224, 240, 248, 252, 254, 255};
    private static final byte[] BITS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final byte[] BITCOUNTS1 = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final long serialVersionUID = -7658605229245494623L;

    public BytesRank1OnlySuccinctBitVector() {
        this(16);
    }

    public BytesRank1OnlySuccinctBitVector(int initialCapacity) {
        this.bytes = new byte[BytesRank1OnlySuccinctBitVector.containerCount(initialCapacity, 8)];
        this.countCache1 = new int[BytesRank1OnlySuccinctBitVector.containerCount(this.bytes.length, 8)];
    }

    public BytesRank1OnlySuccinctBitVector(byte[] bytes, int bits) {
        this.size = bits;
        this.bytes = Arrays.copyOf(bytes, BytesRank1OnlySuccinctBitVector.containerCount(bits, 8));
        this.countCache1 = new int[BytesRank1OnlySuccinctBitVector.containerCount(bytes.length, 8)];
        int sum = BITCOUNTS1[bytes[0] & 0xFF];
        int n = bytes.length;
        for (int i = 1; i < n; ++i) {
            if (i % 8 == 0) {
                this.countCache1[i / 8 - 1] = sum;
            }
            sum += BITCOUNTS1[bytes[i] & 0xFF];
        }
        if (this.countCache1.length > n / 8) {
            this.countCache1[n / 8] = sum;
        }
    }

    public BytesRank1OnlySuccinctBitVector(byte[] bytes, int size, int[] countCache1) {
        this.bytes = bytes;
        this.size = size;
        this.countCache1 = countCache1;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int[] getCountCache1() {
        return this.countCache1;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int n = Math.min(this.size, 32);
        for (int i = 0; i < n; ++i) {
            b.append((this.bytes[i / 8] & 128 >> i % 8) != 0 ? "1" : "0");
        }
        return b.toString();
    }

    @Override
    public boolean get(int pos) {
        return this.isOne(pos);
    }

    @Override
    public boolean isZero(int pos) {
        return (this.bytes[pos / 8] & BITS[pos % 8]) == 0;
    }

    @Override
    public boolean isOne(int pos) {
        return (this.bytes[pos / 8] & BITS[pos % 8]) != 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void trimToSize() {
        int size;
        int vectorSize = this.size / 8 + 1;
        this.bytes = Arrays.copyOf(this.bytes, Math.min(this.bytes.length, vectorSize));
        int blockSize = 8;
        int countCacheSize0 = size = vectorSize / blockSize + (vectorSize % blockSize != 0 ? 1 : 0);
        this.countCache1 = Arrays.copyOf(this.countCache1, Math.min(this.countCache1.length, countCacheSize0));
    }

    @Override
    public void append1() {
        int i = this.size / 8;
        int ci = this.size / 64;
        this.prepareAppend(i, ci);
        int n = ci;
        this.countCache1[n] = this.countCache1[n] + 1;
        int r = this.size % 8;
        int n2 = i;
        this.bytes[n2] = (byte)(this.bytes[n2] | BITS[r]);
        ++this.size;
    }

    @Override
    public void append0() {
        int i = this.size / 8;
        int ci = this.size / 64;
        this.prepareAppend(i, ci);
        ++this.size;
    }

    @Override
    public int select0(int num) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int next0(int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int select1(int num) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int rank0(int pos) {
        int ret;
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return (cn + 1) * 64 - this.countCache1[cn];
        }
        ret = cn > 0 ? (ret = cn * 64 - this.countCache1[cn - 1]) : 0;
        int n = pos / 8;
        for (int i = cn * 8; i < n; ++i) {
            ret += 8 - BITCOUNTS1[this.bytes[i] & 0xFF];
        }
        return ret + 8 - BITCOUNTS1[this.bytes[n] & MASKS[pos % 8]];
    }

    @Override
    public int rank1(int pos) {
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return this.countCache1[cn];
        }
        if (cn > 0) {
            int ret = this.countCache1[cn - 1];
            int n = pos / 8;
            for (int i = cn * 8; i < n; ++i) {
                ret += BITCOUNTS1[this.bytes[i] & 0xFF];
            }
            return ret + BITCOUNTS1[this.bytes[n] & MASKS[pos % 8]];
        }
        int ret = 0;
        int n = pos / 8;
        for (int i = 0; i < n; ++i) {
            ret += BITCOUNTS1[this.bytes[i] & 0xFF];
        }
        return ret + BITCOUNTS1[this.bytes[n] & MASKS[pos % 8]];
    }

    public void save(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(this.size);
        this.trimToSize();
        dos.writeInt(this.bytes.length);
        dos.write(this.bytes);
        dos.writeInt(this.countCache1.length);
        for (int e : this.countCache1) {
            dos.writeInt(e);
        }
        dos.flush();
    }

    public void load(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        this.size = dis.readInt();
        int vectorSize = dis.readInt();
        this.bytes = new byte[vectorSize];
        dis.read(this.bytes, 0, vectorSize);
        int size = dis.readInt();
        this.countCache1 = new int[size];
        for (int i = 0; i < size; ++i) {
            this.countCache1[i] = dis.readInt();
        }
    }

    private static int containerCount(int size, int unitSize) {
        return size / unitSize + (size % unitSize != 0 ? 1 : 0);
    }

    private int prepareAppend(int i, int ci) {
        if (i >= this.bytes.length) {
            this.extend();
        }
        if (this.size % 64 == 0 && ci > 0) {
            this.countCache1[ci] = this.countCache1[ci - 1];
        }
        return i;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bytes = (byte[])in.readObject();
        this.size = in.readInt();
        this.countCache1 = (int[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.bytes);
        out.writeInt(this.size);
        out.writeObject(this.countCache1);
    }

    private void extend() {
        int vectorSize = (int)((double)this.bytes.length * 1.2) + 1;
        this.bytes = Arrays.copyOf(this.bytes, vectorSize);
        int blockSize = 8;
        int size = vectorSize / blockSize + (vectorSize % blockSize != 0 ? 1 : 0);
        this.countCache1 = Arrays.copyOf(this.countCache1, size);
    }
}

