/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.NativeCell;
import org.apache.cassandra.db.composites.AbstractCellNameType;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.SimpleCType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractSimpleCellNameType
extends AbstractCellNameType {
    protected final AbstractType<?> type;
    static final Comparator<Cell> rightNativeCell = new Comparator<Cell>(){

        @Override
        public int compare(Cell o1, Cell o2) {
            return -((NativeCell)o2).compareToSimple(o1.name());
        }
    };
    static final Comparator<Cell> neitherNativeCell = new Comparator<Cell>(){

        @Override
        public int compare(Cell o1, Cell o2) {
            return AbstractSimpleCellNameType.compareUnsigned(o1.name(), o2.name());
        }
    };
    static final Comparator<Object> asymmetricRightNativeCell = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return -((NativeCell)o2).compareToSimple((Composite)o1);
        }
    };
    static final Comparator<Object> asymmetricNeitherNativeCell = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return AbstractSimpleCellNameType.compareUnsigned((Composite)o1, ((Cell)o2).name());
        }
    };

    protected AbstractSimpleCellNameType(AbstractType<?> type) {
        super(type.isByteOrderComparable());
        this.type = type;
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    static int compareUnsigned(Composite c1, Composite c2) {
        ByteBuffer b1 = c1.toByteBuffer();
        ByteBuffer b2 = c2.toByteBuffer();
        return ByteBufferUtil.compareUnsigned(b1, b2);
    }

    @Override
    public int compare(Composite c1, Composite c2) {
        if (this.isByteOrderComparable) {
            return AbstractSimpleCellNameType.compareUnsigned(c1, c2);
        }
        assert (!(c1.isEmpty() | c2.isEmpty()));
        return this.type.compare(c1.get(0), c2.get(0));
    }

    @Override
    protected Comparator<Cell> getByteOrderColumnComparator(boolean isRightNative) {
        if (isRightNative) {
            return rightNativeCell;
        }
        return neitherNativeCell;
    }

    @Override
    protected Comparator<Object> getByteOrderAsymmetricColumnComparator(boolean isRightNative) {
        if (isRightNative) {
            return asymmetricRightNativeCell;
        }
        return asymmetricNeitherNativeCell;
    }

    @Override
    public AbstractType<?> subtype(int i) {
        if (i != 0) {
            throw new IllegalArgumentException();
        }
        return this.type;
    }

    @Override
    protected CellName makeCellName(ByteBuffer[] components) {
        assert (components.length == 1);
        return this.cellFromByteBuffer(components[0]);
    }

    @Override
    public CBuilder builder() {
        return new SimpleCType.SimpleCBuilder(this);
    }

    @Override
    public AbstractType<?> asAbstractType() {
        return this.type;
    }

    @Override
    public CellNameType.Deserializer newDeserializer(DataInput in) {
        return new SimpleDeserializer(this, in);
    }

    private static class SimpleDeserializer
    implements CellNameType.Deserializer {
        private final AbstractSimpleCellNameType type;
        private ByteBuffer next;
        private final DataInput in;

        public SimpleDeserializer(AbstractSimpleCellNameType type, DataInput in) {
            this.type = type;
            this.in = in;
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.next == null) {
                this.maybeReadNext();
            }
            return this.next.hasRemaining();
        }

        @Override
        public boolean hasUnprocessed() throws IOException {
            return this.next != null;
        }

        @Override
        public int compareNextTo(Composite composite) throws IOException {
            this.maybeReadNext();
            if (composite.isEmpty()) {
                return this.next.hasRemaining() ? 1 : 0;
            }
            return this.type.subtype(0).compare(this.next, composite.get(0));
        }

        private void maybeReadNext() throws IOException {
            if (this.next != null) {
                return;
            }
            int length = this.in.readShort() & 0xFFFF;
            if (length == 0) {
                this.next = ByteBufferUtil.EMPTY_BYTE_BUFFER;
                return;
            }
            byte[] b = new byte[length];
            this.in.readFully(b);
            this.next = ByteBuffer.wrap(b);
        }

        @Override
        public Composite readNext() throws IOException {
            this.maybeReadNext();
            Composite c = this.type.fromByteBuffer(this.next);
            this.next = null;
            return c;
        }

        @Override
        public void skipNext() throws IOException {
            this.maybeReadNext();
            this.next = null;
        }
    }
}

