/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;

public class ValidationRequest
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new ValidationRequestSerializer();
    public final int gcBefore;

    public ValidationRequest(RepairJobDesc desc, int gcBefore) {
        super(RepairMessage.Type.VALIDATION_REQUEST, desc);
        this.gcBefore = gcBefore;
    }

    public String toString() {
        return "ValidationRequest{gcBefore=" + this.gcBefore + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationRequest that = (ValidationRequest)o;
        return this.gcBefore == that.gcBefore;
    }

    public int hashCode() {
        return this.gcBefore;
    }

    public static class ValidationRequestSerializer
    implements RepairMessage.MessageSerializer<ValidationRequest> {
        @Override
        public void serialize(ValidationRequest message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            out.writeInt(message.gcBefore);
        }

        @Override
        public ValidationRequest deserialize(DataInputPlus dis, int version) throws IOException {
            RepairJobDesc desc = RepairJobDesc.serializer.deserialize(dis, version);
            return new ValidationRequest(desc, dis.readInt());
        }

        @Override
        public long serializedSize(ValidationRequest message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            return size += (long)TypeSizes.sizeof(message.gcBefore);
        }
    }
}

