/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.PassphraseEncryptedStreamHeader;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PassphraseEncryptedOutputStream
extends OutputStream {
    private static final AtomicReference<Boolean> SUPPORTS_STRONG_ENCRYPTION = new AtomicReference();
    private static final int CIPHER_INITIALIZATION_VECTOR_LENGTH_BYTES = 16;
    private static final int BASELINE_KEY_FACTORY_KEY_LENGTH_BITS = 128;
    private static final int STRONG_KEY_FACTORY_KEY_LENGTH_BITS = 256;
    private static final int BASELINE_KEY_FACTORY_ITERATION_COUNT = 16384;
    private static final int STRONG_KEY_FACTORY_ITERATION_COUNT = 131072;
    private static final int KEY_FACTORY_SALT_LENGTH_BYTES = 16;
    private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String BASELINE_KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String STRONG_KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA512";
    private static final String BASELINE_MAC_ALGORITHM = "HmacSHA256";
    private static final String STRONG_MAC_ALGORITHM = "HmacSHA512";
    private final CipherOutputStream cipherOutputStream;
    private final PassphraseEncryptedStreamHeader encryptionHeader;

    public PassphraseEncryptedOutputStream(String passphrase, OutputStream wrappedOutputStream) throws GeneralSecurityException, IOException {
        this(passphrase.toCharArray(), wrappedOutputStream);
    }

    public PassphraseEncryptedOutputStream(char[] passphrase, OutputStream wrappedOutputStream) throws GeneralSecurityException, IOException {
        this(passphrase, wrappedOutputStream, null, false, true);
    }

    public PassphraseEncryptedOutputStream(String passphrase, OutputStream wrappedOutputStream, String keyIdentifier, boolean useStrongEncryption, boolean writeHeaderToStream) throws GeneralSecurityException, IOException {
        this(passphrase.toCharArray(), wrappedOutputStream, keyIdentifier, useStrongEncryption, writeHeaderToStream);
    }

    public PassphraseEncryptedOutputStream(char[] passphrase, OutputStream wrappedOutputStream, String keyIdentifier, boolean useStrongEncryption, boolean writeHeaderToStream) throws GeneralSecurityException, IOException {
        String macAlgorithm;
        int keyFactoryIterationCount;
        SecureRandom random = new SecureRandom();
        byte[] keyFactorySalt = new byte[16];
        random.nextBytes(keyFactorySalt);
        byte[] cipherInitializationVector = new byte[16];
        random.nextBytes(cipherInitializationVector);
        PassphraseEncryptedStreamHeader header = null;
        CipherOutputStream cipherStream = null;
        if (useStrongEncryption) {
            keyFactoryIterationCount = 131072;
            macAlgorithm = STRONG_MAC_ALGORITHM;
            Boolean supportsStrongEncryption = SUPPORTS_STRONG_ENCRYPTION.get();
            if (supportsStrongEncryption == null || Boolean.TRUE.equals(supportsStrongEncryption)) {
                try {
                    header = new PassphraseEncryptedStreamHeader(passphrase, STRONG_KEY_FACTORY_ALGORITHM, keyFactoryIterationCount, keyFactorySalt, 256, CIPHER_TRANSFORMATION, cipherInitializationVector, keyIdentifier, macAlgorithm);
                    Cipher cipher = header.createCipher(1);
                    if (writeHeaderToStream) {
                        header.writeTo(wrappedOutputStream);
                    }
                    cipherStream = new CipherOutputStream(wrappedOutputStream, cipher);
                    SUPPORTS_STRONG_ENCRYPTION.compareAndSet(null, Boolean.TRUE);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    SUPPORTS_STRONG_ENCRYPTION.set(Boolean.FALSE);
                }
            }
        } else {
            keyFactoryIterationCount = 16384;
            macAlgorithm = BASELINE_MAC_ALGORITHM;
        }
        if (cipherStream == null) {
            header = new PassphraseEncryptedStreamHeader(passphrase, BASELINE_KEY_FACTORY_ALGORITHM, keyFactoryIterationCount, keyFactorySalt, 128, CIPHER_TRANSFORMATION, cipherInitializationVector, keyIdentifier, macAlgorithm);
            Cipher cipher = header.createCipher(1);
            if (writeHeaderToStream) {
                header.writeTo(wrappedOutputStream);
            }
            cipherStream = new CipherOutputStream(wrappedOutputStream, cipher);
        }
        this.encryptionHeader = header;
        this.cipherOutputStream = cipherStream;
    }

    @Override
    public void write(int b) throws IOException {
        this.cipherOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.cipherOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.cipherOutputStream.write(b, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.cipherOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.cipherOutputStream.close();
    }

    public PassphraseEncryptedStreamHeader getEncryptionHeader() {
        return this.encryptionHeader;
    }
}

