/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class MainResponse {
    private String nodeName;
    private String version;
    private String clusterName;
    private String clusterUuid;
    private static final ObjectParser<MainResponse, Void> PARSER = new ObjectParser(MainResponse.class.getName(), true, MainResponse::new);

    private MainResponse() {
    }

    public MainResponse(String nodeName, String version, String clusterName, String clusterUuid) {
        this.nodeName = nodeName;
        this.version = version;
        this.clusterName = clusterName;
        this.clusterUuid = clusterUuid;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterUuid() {
        return this.clusterUuid;
    }

    public static MainResponse fromXContent(XContentParser parser) {
        return (MainResponse)PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MainResponse other = (MainResponse)o;
        return Objects.equals(this.nodeName, other.nodeName) && Objects.equals(this.version, other.version) && Objects.equals(this.clusterUuid, other.clusterUuid) && Objects.equals(this.clusterName, other.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.version, this.clusterUuid, this.clusterName);
    }

    static {
        PARSER.declareString((response, value) -> {
            response.nodeName = value;
        }, new ParseField("name", new String[0]));
        PARSER.declareString((response, value) -> {
            response.clusterName = value;
        }, new ParseField("cluster_name", new String[0]));
        PARSER.declareString((response, value) -> {
            response.clusterUuid = value;
        }, new ParseField("cluster_uuid", new String[0]));
        PARSER.declareString((response, value) -> {}, new ParseField("tagline", new String[0]));
        PARSER.declareObject((response, value) -> {
            response.version = (String)value.get("number");
        }, (parser, context) -> parser.map(), new ParseField("version", new String[0]));
    }
}

