/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.List;
import java.util.Stack;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupSwitchFactory
extends InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Stack<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        int i = offset + 4 & 0xFFFC;
        int defaultOffset = (code[i] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        int npairs = (code[i += 4] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        i += 4;
        int[] keys = new int[npairs];
        int[] offsets = new int[npairs];
        int j = 0;
        while (j < npairs) {
            keys[j] = (code[i] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
            offsets[j] = (code[i += 4] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
            i += 4;
            ++j;
        }
        Instruction key = stack.pop();
        list.add(new LookupSwitch(opcode, offset, lineNumber, key, defaultOffset, offsets, keys));
        return i - offset - 1;
    }
}

