/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspReader;

final class Mark {
    int cursor;
    int line;
    int col;
    String baseDir;
    char[] stream = null;
    private int fileId;
    private String fileName;
    private Stack<IncludeState> includeStack = null;
    private JspReader reader;
    private JspCompilationContext ctxt;

    Mark(JspReader reader, char[] inStream, int fileId, String name, String inBaseDir) {
        this.reader = reader;
        this.ctxt = reader.getJspCompilationContext();
        this.stream = inStream;
        this.cursor = 0;
        this.line = 1;
        this.col = 1;
        this.fileId = fileId;
        this.fileName = name;
        this.baseDir = inBaseDir;
        this.includeStack = new Stack();
    }

    Mark(Mark other) {
        this.init(other, false);
    }

    void update(int cursor, int line, int col) {
        this.cursor = cursor;
        this.line = line;
        this.col = col;
    }

    void init(Mark other, boolean singleFile) {
        this.cursor = other.cursor;
        this.line = other.line;
        this.col = other.col;
        if (!singleFile) {
            this.reader = other.reader;
            this.ctxt = other.ctxt;
            this.stream = other.stream;
            this.fileId = other.fileId;
            this.fileName = other.fileName;
            this.baseDir = other.baseDir;
            if (this.includeStack == null) {
                this.includeStack = new Stack();
            } else {
                this.includeStack.clear();
            }
            for (int i = 0; i < other.includeStack.size(); ++i) {
                this.includeStack.addElement((IncludeState)other.includeStack.elementAt(i));
            }
        }
    }

    Mark(JspCompilationContext ctxt, String filename, int line, int col) {
        this.reader = null;
        this.ctxt = ctxt;
        this.stream = null;
        this.cursor = 0;
        this.line = line;
        this.col = col;
        this.fileId = -1;
        this.fileName = filename;
        this.baseDir = "le-basedir";
        this.includeStack = null;
    }

    public void pushStream(char[] inStream, int inFileId, String name, String inBaseDir) {
        this.includeStack.push(new IncludeState(this.cursor, this.line, this.col, this.fileId, this.fileName, this.baseDir, this.stream));
        this.cursor = 0;
        this.line = 1;
        this.col = 1;
        this.fileId = inFileId;
        this.fileName = name;
        this.baseDir = inBaseDir;
        this.stream = inStream;
    }

    public Mark popStream() {
        if (this.includeStack.size() <= 0) {
            return null;
        }
        IncludeState state = this.includeStack.pop();
        this.cursor = state.cursor;
        this.line = state.line;
        this.col = state.col;
        this.fileId = state.fileId;
        this.fileName = state.fileName;
        this.baseDir = state.baseDir;
        this.stream = state.stream;
        return this;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.col;
    }

    public String toString() {
        return this.getFile() + "(" + this.line + "," + this.col + ")";
    }

    public String getFile() {
        return this.fileName;
    }

    public URL getURL() throws MalformedURLException {
        return this.ctxt.getResource(this.getFile());
    }

    public boolean equals(Object other) {
        if (other instanceof Mark) {
            Mark m = (Mark)other;
            return this.reader == m.reader && this.fileId == m.fileId && this.cursor == m.cursor && this.line == m.line && this.col == m.col;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.col;
        result = 31 * result + this.cursor;
        result = 31 * result + this.fileId;
        result = 31 * result + this.line;
        result = 31 * result + (this.reader == null ? 0 : this.reader.hashCode());
        return result;
    }

    private static class IncludeState {
        private final int cursor;
        private final int line;
        private final int col;
        private final int fileId;
        private final String fileName;
        private final String baseDir;
        private final char[] stream;

        IncludeState(int inCursor, int inLine, int inCol, int inFileId, String name, String inBaseDir, char[] inStream) {
            this.cursor = inCursor;
            this.line = inLine;
            this.col = inCol;
            this.fileId = inFileId;
            this.fileName = name;
            this.baseDir = inBaseDir;
            this.stream = inStream;
        }
    }
}

