/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PresenceListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.MessageWithSubjectFilter;
import org.jivesoftware.smack.filter.MessageWithThreadFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PossibleFromTypeFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.filter.ToMatchesFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.iqregister.packet.Registration;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.MucConfigFormManager;
import org.jivesoftware.smackx.muc.MucEnterConfiguration;
import org.jivesoftware.smackx.muc.MucMessageInterceptor;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.filter.MUCUserStatusCodeFilter;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCAdmin;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jivesoftware.smackx.muc.packet.MUCOwner;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;

public class MultiUserChat {
    private static final Logger LOGGER = Logger.getLogger(MultiUserChat.class.getName());
    private final XMPPConnection connection;
    private final EntityBareJid room;
    private final MultiUserChatManager multiUserChatManager;
    private final Map<EntityFullJid, Presence> occupantsMap = new ConcurrentHashMap<EntityFullJid, Presence>();
    private final Set<InvitationRejectionListener> invitationRejectionListeners = new CopyOnWriteArraySet<InvitationRejectionListener>();
    private final Set<SubjectUpdatedListener> subjectUpdatedListeners = new CopyOnWriteArraySet<SubjectUpdatedListener>();
    private final Set<UserStatusListener> userStatusListeners = new CopyOnWriteArraySet<UserStatusListener>();
    private final Set<ParticipantStatusListener> participantStatusListeners = new CopyOnWriteArraySet<ParticipantStatusListener>();
    private final Set<MessageListener> messageListeners = new CopyOnWriteArraySet<MessageListener>();
    private final Set<PresenceListener> presenceListeners = new CopyOnWriteArraySet<PresenceListener>();
    private final Set<Consumer<PresenceBuilder>> presenceInterceptors = new CopyOnWriteArraySet<Consumer<PresenceBuilder>>();
    private final StanzaFilter fromRoomFilter;
    private final StanzaFilter fromRoomGroupchatFilter;
    private final AtomicInteger presenceInterceptorCount = new AtomicInteger();
    private final Consumer<PresenceBuilder> presenceInterceptor = presenceBuilder -> {
        for (Consumer<PresenceBuilder> interceptor : this.presenceInterceptors) {
            interceptor.accept((PresenceBuilder)presenceBuilder);
        }
    };
    private final StanzaListener messageListener;
    private final StanzaListener presenceListener;
    private final StanzaListener subjectListener;
    private static final StanzaFilter DECLINE_FILTER = new AndFilter(MessageTypeFilter.NORMAL, new StanzaExtensionFilter("x", "http://jabber.org/protocol/muc#user"));
    private final StanzaListener declinesListener;
    private String subject;
    private EntityFullJid myRoomJid;
    private StanzaCollector messageCollector;
    private DiscoverInfo mucServiceDiscoInfo;
    private volatile boolean processedReflectedSelfPresence;
    private CopyOnWriteArrayList<MucMessageInterceptor> messageInterceptors;

    MultiUserChat(XMPPConnection connection, EntityBareJid room, final MultiUserChatManager multiUserChatManager) {
        this.connection = connection;
        this.room = room;
        this.multiUserChatManager = multiUserChatManager;
        this.messageInterceptors = MultiUserChatManager.getMessageInterceptors();
        this.fromRoomFilter = FromMatchesFilter.create(room);
        this.fromRoomGroupchatFilter = new AndFilter(this.fromRoomFilter, MessageTypeFilter.GROUPCHAT);
        this.messageListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
                Message message = (Message)packet;
                for (MessageListener listener : MultiUserChat.this.messageListeners) {
                    listener.processMessage(message);
                }
            }
        };
        this.subjectListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                Message msg = (Message)packet;
                EntityFullJid from = msg.getFrom().asEntityFullJidIfPossible();
                MultiUserChat.this.subject = msg.getSubject();
                for (SubjectUpdatedListener listener : MultiUserChat.this.subjectUpdatedListeners) {
                    listener.subjectUpdated(msg.getSubject(), from);
                }
            }
        };
        this.presenceListener = new StanzaListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processStanza(Stanza packet) {
                Presence presence = (Presence)packet;
                EntityFullJid from = presence.getFrom().asEntityFullJidIfPossible();
                if (from == null) {
                    return;
                }
                EntityFullJid myRoomJID = MultiUserChat.this.myRoomJid;
                boolean isUserStatusModification = presence.getFrom().equals(myRoomJID);
                MUCUser mucUser = MUCUser.from(packet);
                switch (presence.getType()) {
                    case available: {
                        Presence oldPresence;
                        if (!MultiUserChat.this.processedReflectedSelfPresence && mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110)) {
                            MultiUserChat.this.processedReflectedSelfPresence = true;
                            3 var7_7 = this;
                            synchronized (var7_7) {
                                this.notify();
                            }
                        }
                        if ((oldPresence = MultiUserChat.this.occupantsMap.put(from, presence)) != null) {
                            Iterator mucExtension = MUCUser.from(oldPresence);
                            MUCAffiliation oldAffiliation = ((MUCUser)((Object)mucExtension)).getItem().getAffiliation();
                            MUCRole oldRole = ((MUCUser)((Object)mucExtension)).getItem().getRole();
                            MUCAffiliation newAffiliation = mucUser.getItem().getAffiliation();
                            MUCRole newRole = mucUser.getItem().getRole();
                            MultiUserChat.this.checkRoleModifications(oldRole, newRole, isUserStatusModification, from);
                            MultiUserChat.this.checkAffiliationModifications(oldAffiliation, newAffiliation, isUserStatusModification, from);
                            break;
                        }
                        for (ParticipantStatusListener listener : MultiUserChat.this.participantStatusListeners) {
                            listener.joined(from);
                        }
                        break;
                    }
                    case unavailable: {
                        MultiUserChat.this.occupantsMap.remove(from);
                        if (mucUser != null && mucUser.hasStatus()) {
                            if (isUserStatusModification) {
                                MultiUserChat.this.userHasLeft();
                            }
                            MultiUserChat.this.checkPresenceCode(mucUser.getStatus(), isUserStatusModification, mucUser, from);
                        } else if (!isUserStatusModification) {
                            for (ParticipantStatusListener listener : MultiUserChat.this.participantStatusListeners) {
                                listener.left(from);
                            }
                        }
                        Destroy destroy = mucUser.getDestroy();
                        if (destroy != null) {
                            EntityBareJid alternateMucJid = destroy.getJid();
                            MultiUserChat alternateMuc = alternateMucJid == null ? null : multiUserChatManager.getMultiUserChat(alternateMucJid);
                            for (UserStatusListener listener : MultiUserChat.this.userStatusListeners) {
                                listener.roomDestroyed(alternateMuc, destroy.getReason());
                            }
                        }
                        if (isUserStatusModification) {
                            for (Object listener : MultiUserChat.this.userStatusListeners) {
                                listener.removed(mucUser, presence);
                            }
                        } else {
                            for (Object listener : MultiUserChat.this.participantStatusListeners) {
                                listener.parted(from);
                            }
                        }
                        break;
                    }
                }
                for (PresenceListener listener : MultiUserChat.this.presenceListeners) {
                    listener.processPresence(presence);
                }
            }
        };
        this.declinesListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                Message message = (Message)packet;
                MUCUser mucUser = MUCUser.from(packet);
                MUCUser.Decline rejection = mucUser.getDecline();
                if (rejection == null) {
                    return;
                }
                MultiUserChat.this.fireInvitationRejectionListeners(message, rejection);
            }
        };
    }

    public EntityBareJid getRoom() {
        return this.room;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Presence enter(MucEnterConfiguration conf) throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        Presence reflectedSelfPresence;
        DomainBareJid mucService = this.room.asDomainBareJid();
        this.mucServiceDiscoInfo = this.multiUserChatManager.getMucServiceDiscoInfo(mucService);
        if (this.mucServiceDiscoInfo == null) {
            throw new MultiUserChatException.NotAMucServiceException(this);
        }
        Presence joinPresence = conf.getJoinPresence(this);
        this.connection.addStanzaListener(this.messageListener, this.fromRoomGroupchatFilter);
        AndFilter presenceFromRoomFilter = new AndFilter(this.fromRoomFilter, StanzaTypeFilter.PRESENCE, PossibleFromTypeFilter.ENTITY_FULL_JID);
        this.connection.addStanzaListener(this.presenceListener, presenceFromRoomFilter);
        this.connection.addStanzaListener(this.subjectListener, new AndFilter(this.fromRoomFilter, MessageWithSubjectFilter.INSTANCE, new NotFilter(MessageTypeFilter.ERROR), new NotFilter(MessageWithBodiesFilter.INSTANCE), new NotFilter(MessageWithThreadFilter.INSTANCE)));
        this.connection.addStanzaListener(this.declinesListener, new AndFilter(this.fromRoomFilter, DECLINE_FILTER));
        this.messageCollector = this.connection.createStanzaCollector(this.fromRoomGroupchatFilter);
        AndFilter responseFilter = new AndFilter(StanzaTypeFilter.PRESENCE, new OrFilter(new AndFilter(FromMatchesFilter.createBare(this.getRoom()), MUCUserStatusCodeFilter.STATUS_110_PRESENCE_TO_SELF), new AndFilter(FromMatchesFilter.createFull(joinPresence.getTo()), new StanzaIdFilter(joinPresence), PresenceTypeFilter.ERROR)));
        this.processedReflectedSelfPresence = false;
        StanzaCollector presenceStanzaCollector = null;
        try {
            StanzaCollector selfPresenceCollector = this.connection.createStanzaCollectorAndSend(responseFilter, joinPresence);
            StanzaCollector.Configuration presenceStanzaCollectorConfguration = StanzaCollector.newConfiguration().setCollectorToReset(selfPresenceCollector).setStanzaFilter(presenceFromRoomFilter);
            presenceStanzaCollector = this.connection.createStanzaCollector(presenceStanzaCollectorConfguration);
            reflectedSelfPresence = (Presence)selfPresenceCollector.nextResultOrThrow(conf.getTimeout());
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            this.removeConnectionCallbacks();
            throw e;
        }
        finally {
            if (presenceStanzaCollector != null) {
                presenceStanzaCollector.cancel();
            }
        }
        StanzaListener e = this.presenceListener;
        synchronized (e) {
            while (!this.processedReflectedSelfPresence) {
                this.presenceListener.wait();
            }
        }
        Resourcepart receivedNickname = reflectedSelfPresence.getFrom().getResourceOrThrow();
        this.setNickname(receivedNickname);
        this.multiUserChatManager.addJoinedRoom(this.room);
        return reflectedSelfPresence;
    }

    private void setNickname(Resourcepart nickname) {
        this.myRoomJid = JidCreate.entityFullFrom(this.room, nickname);
    }

    public MucEnterConfiguration.Builder getEnterConfigurationBuilder(Resourcepart nickname) {
        return new MucEnterConfiguration.Builder(nickname, this.connection);
    }

    public synchronized MucCreateConfigFormHandle create(Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException {
        if (this.isJoined()) {
            throw new MultiUserChatException.MucAlreadyJoinedException();
        }
        MucCreateConfigFormHandle mucCreateConfigFormHandle = this.createOrJoin(nickname);
        if (mucCreateConfigFormHandle != null) {
            return mucCreateConfigFormHandle;
        }
        try {
            this.leave();
        }
        catch (MultiUserChatException.MucNotJoinedException e) {
            LOGGER.log(Level.INFO, "Unexpected MucNotJoinedException", e);
        }
        throw new MultiUserChatException.MissingMucCreationAcknowledgeException();
    }

    public synchronized MucCreateConfigFormHandle createOrJoin(Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.NotAMucServiceException {
        MucEnterConfiguration mucEnterConfiguration = this.getEnterConfigurationBuilder(nickname).build();
        return this.createOrJoin(mucEnterConfiguration);
    }

    public synchronized MucCreateConfigFormHandle createOrJoin(MucEnterConfiguration mucEnterConfiguration) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.NotAMucServiceException {
        if (this.isJoined()) {
            throw new MultiUserChatException.MucAlreadyJoinedException();
        }
        Presence presence = this.enter(mucEnterConfiguration);
        MUCUser mucUser = MUCUser.from(presence);
        if (mucUser != null && mucUser.getStatus().contains(MUCUser.Status.ROOM_CREATED_201)) {
            return new MucCreateConfigFormHandle();
        }
        return null;
    }

    public MucCreateConfigFormHandle createOrJoinIfNecessary(Resourcepart nickname, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        if (this.isJoined()) {
            return null;
        }
        MucEnterConfiguration mucEnterConfiguration = this.getEnterConfigurationBuilder(nickname).withPassword(password).build();
        try {
            return this.createOrJoin(mucEnterConfiguration);
        }
        catch (MultiUserChatException.MucAlreadyJoinedException e) {
            return null;
        }
    }

    public void join(Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        MucEnterConfiguration.Builder builder2 = this.getEnterConfigurationBuilder(nickname);
        this.join(builder2.build());
    }

    public void join(Resourcepart nickname, String password) throws XMPPException.XMPPErrorException, InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, MultiUserChatException.NotAMucServiceException {
        MucEnterConfiguration.Builder builder2 = this.getEnterConfigurationBuilder(nickname).withPassword(password);
        this.join(builder2.build());
    }

    public synchronized void join(MucEnterConfiguration mucEnterConfiguration) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        if (this.isJoined()) {
            try {
                this.leaveSync();
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException | MultiUserChatException.MucNotJoinedException e) {
                LOGGER.log(Level.WARNING, "Could not leave MUC prior joining, assuming we are not joined", e);
            }
        }
        this.enter(mucEnterConfiguration);
    }

    public boolean isJoined() {
        return this.myRoomJid != null;
    }

    @Deprecated
    public synchronized Presence leaveSync() throws SmackException.NotConnectedException, InterruptedException, MultiUserChatException.MucNotJoinedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        return this.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Presence leave() throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, MultiUserChatException.MucNotJoinedException {
        Presence reflectedLeavePresence;
        EntityFullJid myRoomJid = this.myRoomJid;
        if (myRoomJid == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        Presence leavePresence = ((PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.unavailable).to(myRoomJid)).build();
        ArrayList<StanzaFilter> reflectedLeavePresenceFilters = new ArrayList<StanzaFilter>(3);
        reflectedLeavePresenceFilters.add(StanzaTypeFilter.PRESENCE);
        reflectedLeavePresenceFilters.add(new OrFilter(new AndFilter(FromMatchesFilter.createFull(myRoomJid), PresenceTypeFilter.UNAVAILABLE, MUCUserStatusCodeFilter.STATUS_110_PRESENCE_TO_SELF), new AndFilter(this.fromRoomFilter, PresenceTypeFilter.ERROR)));
        if (this.serviceSupportsStableIds()) {
            reflectedLeavePresenceFilters.add(new StanzaIdFilter(leavePresence));
        }
        AndFilter reflectedLeavePresenceFilter = new AndFilter(reflectedLeavePresenceFilters);
        try {
            reflectedLeavePresence = (Presence)this.connection.createStanzaCollectorAndSend(reflectedLeavePresenceFilter, leavePresence).nextResultOrThrow();
        }
        finally {
            this.userHasLeft();
        }
        return reflectedLeavePresence;
    }

    public MucConfigFormManager getConfigFormManager() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return new MucConfigFormManager(this);
    }

    public Form getConfigurationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.get);
        IQ answer = (IQ)this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
        DataForm dataForm = DataForm.from(answer, "http://jabber.org/protocol/muc#roomconfig");
        return new Form(dataForm);
    }

    public void sendConfigurationForm(FillableForm form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DataForm dataForm = form != null ? form.getDataFormToSubmit() : DataForm.builder().build();
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        iq.addExtension(dataForm);
        this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
    }

    public Form getRegistrationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.get);
        reg.setTo(this.room);
        IQ result2 = (IQ)this.connection.createStanzaCollectorAndSend(reg).nextResultOrThrow();
        DataForm dataForm = DataForm.from(result2);
        return new Form(dataForm);
    }

    public void sendRegistrationForm(FillableForm form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.set);
        reg.setTo(this.room);
        reg.addExtension(form.getDataFormToSubmit());
        this.connection.createStanzaCollectorAndSend(reg).nextResultOrThrow();
    }

    public void destroy(String reason2, EntityBareJid alternateJID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        Destroy destroy = new Destroy(alternateJID, reason2);
        iq.setDestroy(destroy);
        try {
            this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
        }
        catch (XMPPException.XMPPErrorException e) {
            throw e;
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
            this.userHasLeft();
            throw e;
        }
        this.userHasLeft();
    }

    public void invite(EntityBareJid user, String reason2) throws SmackException.NotConnectedException, InterruptedException {
        this.invite(this.connection.getStanzaFactory().buildMessageStanza(), user, reason2);
    }

    @Deprecated
    public void invite(Message message, EntityBareJid user, String reason2) throws SmackException.NotConnectedException, InterruptedException {
        message.setTo(this.room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Invite invite = new MUCUser.Invite(reason2, user);
        mucUser.setInvite(invite);
        message.addExtension(mucUser);
        this.connection.sendStanza(message);
    }

    public void invite(MessageBuilder messageBuilder, EntityBareJid user, String reason2) throws SmackException.NotConnectedException, InterruptedException {
        messageBuilder.to(this.room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Invite invite = new MUCUser.Invite(reason2, user);
        mucUser.setInvite(invite);
        messageBuilder.addExtension(mucUser);
        Message message = messageBuilder.build();
        this.connection.sendStanza(message);
    }

    public boolean addInvitationRejectionListener(InvitationRejectionListener listener) {
        return this.invitationRejectionListeners.add(listener);
    }

    public boolean removeInvitationRejectionListener(InvitationRejectionListener listener) {
        return this.invitationRejectionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationRejectionListeners(Message message, MUCUser.Decline rejection) {
        EntityBareJid invitee = rejection.getFrom();
        String reason2 = rejection.getReason();
        InvitationRejectionListener[] invitationRejectionListenerArray = this.invitationRejectionListeners;
        synchronized (this.invitationRejectionListeners) {
            InvitationRejectionListener[] listeners = new InvitationRejectionListener[this.invitationRejectionListeners.size()];
            this.invitationRejectionListeners.toArray(listeners);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            for (InvitationRejectionListener listener : listeners) {
                listener.invitationDeclined(invitee, reason2, message, rejection);
            }
            return;
        }
    }

    public boolean addSubjectUpdatedListener(SubjectUpdatedListener listener) {
        return this.subjectUpdatedListeners.add(listener);
    }

    public boolean removeSubjectUpdatedListener(SubjectUpdatedListener listener) {
        return this.subjectUpdatedListeners.remove(listener);
    }

    public void addPresenceInterceptor(Consumer<PresenceBuilder> presenceInterceptor) {
        boolean added = this.presenceInterceptors.add(presenceInterceptor);
        if (!added) {
            return;
        }
        int currentCount = this.presenceInterceptorCount.incrementAndGet();
        if (currentCount == 1) {
            this.connection.addPresenceInterceptor(this.presenceInterceptor, ToMatchesFilter.create(this.room).asPredicate(Presence.class));
        }
    }

    public void removePresenceInterceptor(Consumer<PresenceBuilder> presenceInterceptor) {
        boolean removed = this.presenceInterceptors.remove(presenceInterceptor);
        if (!removed) {
            return;
        }
        int currentCount = this.presenceInterceptorCount.decrementAndGet();
        if (currentCount == 0) {
            this.connection.removePresenceInterceptor(presenceInterceptor);
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public String getReservedNickname() throws SmackException, InterruptedException {
        try {
            DiscoverInfo result2 = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(this.room, "x-roomuser-item");
            Iterator<DiscoverInfo.Identity> iterator2 = result2.getIdentities().iterator();
            if (iterator2.hasNext()) {
                DiscoverInfo.Identity identity = iterator2.next();
                return identity.getName();
            }
        }
        catch (XMPPException e) {
            LOGGER.log(Level.SEVERE, "Error retrieving room nickname", e);
        }
        return null;
    }

    public Resourcepart getNickname() {
        EntityFullJid myRoomJid = this.myRoomJid;
        if (myRoomJid == null) {
            return null;
        }
        return myRoomJid.getResourcepart();
    }

    public synchronized void changeNickname(Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.MucNotJoinedException {
        Objects.requireNonNull(nickname, "Nickname must not be null or blank.");
        if (!this.isJoined()) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        EntityFullJid jid = JidCreate.entityFullFrom(this.room, nickname);
        Presence joinPresence = ((PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().to(jid)).ofType(Presence.Type.available).build();
        AndFilter responseFilter = new AndFilter(FromMatchesFilter.createFull(jid), new StanzaTypeFilter(Presence.class));
        StanzaCollector response2 = this.connection.createStanzaCollectorAndSend(responseFilter, joinPresence);
        response2.nextResultOrThrow();
        this.setNickname(nickname);
    }

    public void changeAvailabilityStatus(String status, Presence.Mode mode) throws SmackException.NotConnectedException, InterruptedException, MultiUserChatException.MucNotJoinedException {
        EntityFullJid myRoomJid = this.myRoomJid;
        if (myRoomJid == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        Presence joinPresence = ((PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().to(myRoomJid)).ofType(Presence.Type.available).setStatus(status).setMode(mode).build();
        this.connection.sendStanza(joinPresence);
    }

    public void kickParticipant(Resourcepart nickname, String reason2) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nickname, MUCRole.none, reason2);
    }

    public void requestVoice() throws SmackException.NotConnectedException, InterruptedException {
        DataForm.Builder form = DataForm.builder().setFormType("http://jabber.org/protocol/muc#request");
        TextSingleFormField.Builder requestVoiceField = FormField.textSingleBuilder("muc#role");
        requestVoiceField.setLabel("Requested role");
        requestVoiceField.setValue("participant");
        form.addField(requestVoiceField.build());
        Message message = ((MessageBuilder)((MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().to(this.room)).addExtension(form.build())).build();
        this.connection.sendStanza(message);
    }

    public void grantVoice(Collection<Resourcepart> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nicknames, MUCRole.participant);
    }

    public void grantVoice(Resourcepart nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nickname, MUCRole.participant, null);
    }

    public void revokeVoice(Collection<Resourcepart> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nicknames, MUCRole.visitor);
    }

    public void revokeVoice(Resourcepart nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nickname, MUCRole.visitor, null);
    }

    public void banUsers(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.outcast);
    }

    public void banUser(Jid jid, String reason2) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.outcast, reason2);
    }

    public void grantMembership(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.member);
    }

    public void grantMembership(Jid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.member, null);
    }

    public void revokeMembership(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.none);
    }

    public void revokeMembership(Jid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.none, null);
    }

    public void grantModerator(Collection<Resourcepart> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nicknames, MUCRole.moderator);
    }

    public void grantModerator(Resourcepart nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nickname, MUCRole.moderator, null);
    }

    public void revokeModerator(Collection<Resourcepart> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nicknames, MUCRole.participant);
    }

    public void revokeModerator(Resourcepart nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nickname, MUCRole.participant, null);
    }

    public void grantOwnership(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.owner);
    }

    public void grantOwnership(Jid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.owner, null);
    }

    public void revokeOwnership(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.admin);
    }

    public void revokeOwnership(Jid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.admin, null);
    }

    public void grantAdmin(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.admin);
    }

    public void grantAdmin(Jid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.admin);
    }

    public void revokeAdmin(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.admin);
    }

    public void revokeAdmin(EntityJid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.member);
    }

    private void changeAffiliationByAdmin(Jid jid, MUCAffiliation affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, affiliation, null);
    }

    private void changeAffiliationByAdmin(Jid jid, MUCAffiliation affiliation, String reason2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        MUCItem item = new MUCItem(affiliation, jid, reason2);
        iq.addItem(item);
        this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeAffiliationByAdmin(Collection<? extends Jid> jids, MUCAffiliation affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        for (Jid jid : jids) {
            MUCItem item = new MUCItem(affiliation, jid);
            iq.addItem(item);
        }
        this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeRole(Resourcepart nickname, MUCRole role, String reason2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        MUCItem item = new MUCItem(role, nickname, reason2);
        iq.addItem(item);
        this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeRole(Collection<Resourcepart> nicknames, MUCRole role) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        for (Resourcepart nickname : nicknames) {
            MUCItem item = new MUCItem(role, nickname);
            iq.addItem(item);
        }
        this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
    }

    public int getOccupantsCount() {
        return this.occupantsMap.size();
    }

    public List<EntityFullJid> getOccupants() {
        return new ArrayList<EntityFullJid>(this.occupantsMap.keySet());
    }

    public Presence getOccupantPresence(EntityFullJid user) {
        return this.occupantsMap.get(user);
    }

    public Occupant getOccupant(EntityFullJid user) {
        Presence presence = this.getOccupantPresence(user);
        if (presence != null) {
            return new Occupant(presence);
        }
        return null;
    }

    public boolean addParticipantListener(PresenceListener listener) {
        return this.presenceListeners.add(listener);
    }

    public boolean removeParticipantListener(PresenceListener listener) {
        return this.presenceListeners.remove(listener);
    }

    public List<Affiliate> getOwners() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.owner);
    }

    public List<Affiliate> getAdmins() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.admin);
    }

    public List<Affiliate> getMembers() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.member);
    }

    public List<Affiliate> getOutcasts() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.outcast);
    }

    private List<Affiliate> getAffiliatesByAdmin(MUCAffiliation affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.get);
        MUCItem item = new MUCItem(affiliation);
        iq.addItem(item);
        MUCAdmin answer = (MUCAdmin)this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
        ArrayList<Affiliate> affiliates = new ArrayList<Affiliate>();
        for (MUCItem mucadminItem : answer.getItems()) {
            affiliates.add(new Affiliate(mucadminItem));
        }
        return affiliates;
    }

    public List<Occupant> getModerators() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getOccupants(MUCRole.moderator);
    }

    public List<Occupant> getParticipants() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getOccupants(MUCRole.participant);
    }

    private List<Occupant> getOccupants(MUCRole role) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.get);
        MUCItem item = new MUCItem(role);
        iq.addItem(item);
        MUCAdmin answer = (MUCAdmin)this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
        ArrayList<Occupant> participants = new ArrayList<Occupant>();
        for (MUCItem mucadminItem : answer.getItems()) {
            participants.add(new Occupant(mucadminItem));
        }
        return participants;
    }

    public void sendMessage(String text) throws SmackException.NotConnectedException, InterruptedException {
        Message message = this.buildMessage().setBody(text).build();
        this.connection.sendStanza(message);
    }

    public Chat createPrivateChat(EntityFullJid occupant, ChatMessageListener listener) {
        return ChatManager.getInstanceFor(this.connection).createChat(occupant, listener);
    }

    @Deprecated
    public Message createMessage() {
        return ((MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().ofType(Message.Type.groupchat).to(this.room)).build();
    }

    public MessageBuilder buildMessage() {
        return (MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().ofType(Message.Type.groupchat).to(this.room);
    }

    @Deprecated
    public void sendMessage(Message message) throws SmackException.NotConnectedException, InterruptedException {
        this.sendMessage(message.asBuilder());
    }

    public MessageView sendMessage(MessageBuilder messageBuilder) throws SmackException.NotConnectedException, InterruptedException {
        for (MucMessageInterceptor interceptor : this.messageInterceptors) {
            interceptor.intercept(messageBuilder, this);
        }
        Message message = ((MessageBuilder)messageBuilder.to(this.room)).ofType(Message.Type.groupchat).build();
        this.connection.sendStanza(message);
        return message;
    }

    public Message pollMessage() throws MultiUserChatException.MucNotJoinedException {
        if (this.messageCollector == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() throws MultiUserChatException.MucNotJoinedException, InterruptedException {
        if (this.messageCollector == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long timeout2) throws MultiUserChatException.MucNotJoinedException, InterruptedException {
        if (this.messageCollector == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        return (Message)this.messageCollector.nextResult(timeout2);
    }

    public boolean addMessageListener(MessageListener listener) {
        return this.messageListeners.add(listener);
    }

    public boolean removeMessageListener(MessageListener listener) {
        return this.messageListeners.remove(listener);
    }

    public boolean addMessageInterceptor(MucMessageInterceptor interceptor) {
        return this.messageInterceptors.add(interceptor);
    }

    public boolean removeMessageInterceptor(MucMessageInterceptor interceptor) {
        return this.messageInterceptors.remove(interceptor);
    }

    public void changeSubject(final String subject) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MessageBuilder message = this.buildMessage();
        message.setSubject(subject);
        AndFilter responseFilter = new AndFilter(this.fromRoomGroupchatFilter, new StanzaFilter(){

            @Override
            public boolean accept(Stanza packet) {
                Message msg = (Message)packet;
                return subject.equals(msg.getSubject());
            }
        });
        StanzaCollector response2 = this.connection.createStanzaCollectorAndSend(responseFilter, message.build());
        response2.nextResultOrThrow();
    }

    private void removeConnectionCallbacks() {
        this.connection.removeStanzaListener(this.messageListener);
        this.connection.removeStanzaListener(this.presenceListener);
        this.connection.removeStanzaListener(this.subjectListener);
        this.connection.removeStanzaListener(this.declinesListener);
        this.connection.removePresenceInterceptor(this.presenceInterceptor);
        if (this.messageCollector != null) {
            this.messageCollector.cancel();
            this.messageCollector = null;
        }
    }

    private synchronized void userHasLeft() {
        this.occupantsMap.clear();
        this.myRoomJid = null;
        this.multiUserChatManager.removeJoinedRoom(this.room);
        this.removeConnectionCallbacks();
    }

    public boolean addUserStatusListener(UserStatusListener listener) {
        return this.userStatusListeners.add(listener);
    }

    public boolean removeUserStatusListener(UserStatusListener listener) {
        return this.userStatusListeners.remove(listener);
    }

    public boolean addParticipantStatusListener(ParticipantStatusListener listener) {
        return this.participantStatusListeners.add(listener);
    }

    public boolean removeParticipantStatusListener(ParticipantStatusListener listener) {
        return this.participantStatusListeners.remove(listener);
    }

    private void checkRoleModifications(MUCRole oldRole, MUCRole newRole, boolean isUserModification, EntityFullJid from) {
        block30: {
            block29: {
                if ((MUCRole.visitor.equals((Object)oldRole) || MUCRole.none.equals((Object)oldRole)) && MUCRole.participant.equals((Object)newRole)) {
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.voiceGranted();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.voiceGranted(from);
                        }
                    }
                } else if (MUCRole.participant.equals((Object)oldRole) && (MUCRole.visitor.equals((Object)newRole) || MUCRole.none.equals((Object)newRole))) {
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.voiceRevoked();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.voiceRevoked(from);
                        }
                    }
                }
                if (MUCRole.moderator.equals((Object)oldRole) || !MUCRole.moderator.equals((Object)newRole)) break block29;
                if (MUCRole.visitor.equals((Object)oldRole) || MUCRole.none.equals((Object)oldRole)) {
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.voiceGranted();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.voiceGranted(from);
                        }
                    }
                }
                if (isUserModification) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.moderatorGranted();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.moderatorGranted(from);
                    }
                }
                break block30;
            }
            if (!MUCRole.moderator.equals((Object)oldRole) || MUCRole.moderator.equals((Object)newRole)) break block30;
            if (MUCRole.visitor.equals((Object)newRole) || MUCRole.none.equals((Object)newRole)) {
                if (isUserModification) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.voiceRevoked();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.voiceRevoked(from);
                    }
                }
            }
            if (isUserModification) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.moderatorRevoked();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.moderatorRevoked(from);
                }
            }
        }
    }

    private void checkAffiliationModifications(MUCAffiliation oldAffiliation, MUCAffiliation newAffiliation, boolean isUserModification, EntityFullJid from) {
        block30: {
            block31: {
                block29: {
                    if (MUCAffiliation.owner.equals((Object)oldAffiliation) && !MUCAffiliation.owner.equals((Object)newAffiliation)) {
                        if (isUserModification) {
                            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                                userStatusListener.ownershipRevoked();
                            }
                        } else {
                            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                                participantStatusListener.ownershipRevoked(from);
                            }
                        }
                    } else if (MUCAffiliation.admin.equals((Object)oldAffiliation) && !MUCAffiliation.admin.equals((Object)newAffiliation)) {
                        if (isUserModification) {
                            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                                userStatusListener.adminRevoked();
                            }
                        } else {
                            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                                participantStatusListener.adminRevoked(from);
                            }
                        }
                    } else if (MUCAffiliation.member.equals((Object)oldAffiliation) && !MUCAffiliation.member.equals((Object)newAffiliation)) {
                        if (isUserModification) {
                            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                                userStatusListener.membershipRevoked();
                            }
                        } else {
                            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                                participantStatusListener.membershipRevoked(from);
                            }
                        }
                    }
                    if (MUCAffiliation.owner.equals((Object)oldAffiliation) || !MUCAffiliation.owner.equals((Object)newAffiliation)) break block29;
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.ownershipGranted();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.ownershipGranted(from);
                        }
                    }
                    break block30;
                }
                if (MUCAffiliation.admin.equals((Object)oldAffiliation) || !MUCAffiliation.admin.equals((Object)newAffiliation)) break block31;
                if (isUserModification) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.adminGranted();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.adminGranted(from);
                    }
                }
                break block30;
            }
            if (MUCAffiliation.member.equals((Object)oldAffiliation) || !MUCAffiliation.member.equals((Object)newAffiliation)) break block30;
            if (isUserModification) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.membershipGranted();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.membershipGranted(from);
                }
            }
        }
    }

    private void checkPresenceCode(Set<MUCUser.Status> statusCodes, boolean isUserModification, MUCUser mucUser, EntityFullJid from) {
        if (statusCodes.contains(MUCUser.Status.KICKED_307)) {
            if (isUserModification) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.kicked(mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.kicked(from, mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
            }
        }
        if (statusCodes.contains(MUCUser.Status.BANNED_301)) {
            if (isUserModification) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.banned(mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.banned(from, mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
            }
        }
        if (statusCodes.contains(MUCUser.Status.REMOVED_AFFIL_CHANGE_321) && isUserModification) {
            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                userStatusListener.membershipRevoked();
            }
        }
        if (statusCodes.contains(MUCUser.Status.NEW_NICKNAME_303)) {
            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                participantStatusListener.nicknameChanged(from, mucUser.getItem().getNick());
            }
        }
    }

    public XMPPConnection getXmppConnection() {
        return this.connection;
    }

    public boolean serviceSupportsStableIds() {
        return DiscoverInfo.nullSafeContainsFeature(this.mucServiceDiscoInfo, "http://jabber.org/protocol/muc#stable_id");
    }

    public String toString() {
        return "MUC: " + this.room + "(" + this.connection.getUser() + ")";
    }

    public class MucCreateConfigFormHandle {
        public void makeInstant() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
            MultiUserChat.this.sendConfigurationForm(null);
        }

        public MucConfigFormManager getConfigFormManager() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
            return MultiUserChat.this.getConfigFormManager();
        }
    }
}

