/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataWks
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = 4550031993619542554L;
    private final Inet4Address address;
    private final IpNumber protocol;
    private final byte[] bitMap;
    private final List<Integer> portNumbers;

    public static DnsRDataWks newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataWks(rawData, offset, length);
    }

    private DnsRDataWks(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 5) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a DnsRDataWks (").append(5).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        int cursor = 0;
        this.address = ByteArrays.getInet4Address(rawData, offset);
        this.protocol = IpNumber.getInstance(ByteArrays.getByte(rawData, offset + (cursor += 4)));
        this.bitMap = ++cursor < length ? ByteArrays.getSubArray(rawData, offset + cursor, length - cursor) : new byte[0];
        if (this.bitMap.length > 8192) {
            throw new IllegalRawDataException("Length of bitMap must be less than 8193. bitMap.length: " + this.bitMap.length);
        }
        this.portNumbers = this.toPortNumbers(this.bitMap);
    }

    private DnsRDataWks(Builder builder2) {
        if (builder2 == null || builder2.address == null || builder2.protocol == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.address: ").append(builder2.address).append(" builder.protocol: ").append(builder2.protocol);
            throw new NullPointerException(sb.toString());
        }
        this.address = builder2.address;
        this.protocol = builder2.protocol;
        if (builder2.bitMap != null) {
            if (builder2.bitMap.length > 8192) {
                throw new IllegalArgumentException("Length of bitMap must be less than 8193. builder.bitMap.length: " + builder2.bitMap.length);
            }
            this.bitMap = ByteArrays.clone(builder2.bitMap);
            this.portNumbers = this.toPortNumbers(this.bitMap);
        } else if (builder2.portNumbers != null) {
            this.portNumbers = new ArrayList<Integer>(builder2.portNumbers);
            if (this.portNumbers.size() != 0) {
                Collections.sort(this.portNumbers);
                int lastIdx = this.portNumbers.size() - 1;
                int maxPortNum = this.portNumbers.get(lastIdx);
                if ((maxPortNum & 0xFFFF0000) != 0) {
                    throw new IllegalArgumentException("(port & 0xFFFF0000) must be zero. port: " + maxPortNum);
                }
                this.bitMap = new byte[maxPortNum / 8 + 1];
                for (int num : this.portNumbers) {
                    int n = num / 8;
                    this.bitMap[n] = (byte)(this.bitMap[n] | 128 >> num % 8);
                }
            } else {
                this.bitMap = new byte[0];
            }
        } else {
            throw new NullPointerException("Both bitMap and portNumbers are null.");
        }
    }

    private List<Integer> toPortNumbers(byte[] bitMap) {
        ArrayList<Integer> portNums = new ArrayList<Integer>();
        int portNum = 0;
        for (byte octet : bitMap) {
            int numShifts = 7;
            while (numShifts >= 0) {
                if ((octet >> numShifts & 1) != 0) {
                    portNums.add(portNum);
                }
                --numShifts;
                ++portNum;
            }
        }
        return portNums;
    }

    public Inet4Address getAddress() {
        return this.address;
    }

    public IpNumber getProtocol() {
        return this.protocol;
    }

    public byte[] getBitMap() {
        return ByteArrays.clone(this.bitMap);
    }

    public List<Integer> getPortNumbers() {
        return new ArrayList<Integer>(this.portNumbers);
    }

    @Override
    public int length() {
        return 5 + this.bitMap.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] data2 = new byte[this.length()];
        int cursor = 0;
        System.arraycopy(this.address.getAddress(), 0, data2, cursor, 4);
        System.arraycopy(ByteArrays.toByteArray((Byte)this.protocol.value()), 0, data2, cursor += 4, 1);
        System.arraycopy(this.bitMap, 0, data2, ++cursor, this.bitMap.length);
        return data2;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("WKS RDATA:").append(ls).append(indent).append("  ADDRESS: ").append(this.address.getHostAddress()).append(ls).append(indent).append("  PROTOCOL: ").append(this.protocol).append(ls).append(indent).append("  BIT MAP: 0x").append(ByteArrays.toHexString(this.bitMap, "")).append(ls).append(indent).append("  PORTS: ");
        Iterator<Integer> iter = this.portNumbers.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.address.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.bitMap);
        result2 = 31 * result2 + this.protocol.hashCode();
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnsRDataWks other = (DnsRDataWks)obj;
        if (!this.address.equals(other.address)) {
            return false;
        }
        if (!Arrays.equals(this.bitMap, other.bitMap)) {
            return false;
        }
        return this.protocol.equals(other.protocol);
    }

    public static final class Builder {
        private Inet4Address address;
        private IpNumber protocol;
        private byte[] bitMap = null;
        private List<Integer> portNumbers = null;

        public Builder() {
        }

        private Builder(DnsRDataWks obj) {
            this.address = obj.address;
            this.protocol = obj.protocol;
            this.bitMap = obj.bitMap;
        }

        public Builder address(Inet4Address address) {
            this.address = address;
            return this;
        }

        public Builder protocol(IpNumber protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder bitMap(byte[] bitMap) {
            this.bitMap = bitMap;
            this.portNumbers = null;
            return this;
        }

        public Builder portNumbers(List<Integer> portNumbers) {
            this.portNumbers = portNumbers;
            this.bitMap = null;
            return this;
        }

        public DnsRDataWks build() {
            return new DnsRDataWks(this);
        }
    }
}

