/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.core.JavaPsiBundle;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public enum AccessModifier {
    PUBLIC("public"),
    PROTECTED("protected"),
    PACKAGE_LOCAL("packageLocal"),
    PRIVATE("private");

    public static final @Unmodifiable List<AccessModifier> ALL_MODIFIERS;
    private static final @Unmodifiable List<AccessModifier> PUBLIC_PACKAGE;
    private static final @Unmodifiable List<AccessModifier> PUBLIC_PRIVATE;
    @NotNull
    @PsiModifier.ModifierConstant
    private final String myModifier;

    private AccessModifier(String modifier) {
        if (modifier == null) {
            AccessModifier.$$$reportNull$$$0(0);
        }
        this.myModifier = modifier;
    }

    @NotNull
    @PsiModifier.ModifierConstant
    public String toPsiModifier() {
        String string2 = this.myModifier;
        if (string2 == null) {
            AccessModifier.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public boolean hasModifier(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            AccessModifier.$$$reportNull$$$0(2);
        }
        return owner.hasModifierProperty(this.toPsiModifier());
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static AccessModifier fromKeyword(@Nullable PsiKeyword keyword) {
        return keyword == null ? null : AccessModifier.fromPsiModifier(keyword.getText());
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static AccessModifier fromPsiModifier(@Nullable String modifier) {
        if (modifier == null) {
            return null;
        }
        switch (modifier) {
            case "public": {
                return PUBLIC;
            }
            case "protected": {
                return PROTECTED;
            }
            case "packageLocal": {
                return PACKAGE_LOCAL;
            }
            case "private": {
                return PRIVATE;
            }
        }
        return null;
    }

    public static AccessModifier fromModifierList(@NotNull PsiModifierList modifierList2) {
        if (modifierList2 == null) {
            AccessModifier.$$$reportNull$$$0(3);
        }
        if (modifierList2.hasModifierProperty("private")) {
            return PRIVATE;
        }
        if (modifierList2.hasModifierProperty("packageLocal")) {
            return PACKAGE_LOCAL;
        }
        if (modifierList2.hasModifierProperty("protected")) {
            return PROTECTED;
        }
        return PUBLIC;
    }

    public boolean isWeaker(@NotNull AccessModifier other) {
        if (other == null) {
            AccessModifier.$$$reportNull$$$0(4);
        }
        return this.compareTo(other) < 0;
    }

    @Nls
    public String toString() {
        return JavaPsiBundle.visibilityPresentation(this.toPsiModifier());
    }

    @NotNull
    public static @Unmodifiable List<AccessModifier> getAvailableModifiers(@NotNull PsiMember member) {
        if (member == null) {
            AccessModifier.$$$reportNull$$$0(5);
        }
        PsiClass containingClass = member.getContainingClass();
        if (member instanceof PsiField) {
            if (member instanceof PsiEnumConstant || containingClass == null || containingClass.isInterface()) {
                List<AccessModifier> list = Collections.emptyList();
                if (list == null) {
                    AccessModifier.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<AccessModifier> list = ALL_MODIFIERS;
            if (list == null) {
                AccessModifier.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            if (containingClass == null || containingClass.isEnum() && method.isConstructor()) {
                List<AccessModifier> list = Collections.emptyList();
                if (list == null) {
                    AccessModifier.$$$reportNull$$$0(8);
                }
                return list;
            }
            if (JavaPsiRecordUtil.getRecordComponentForAccessor(method) != null) {
                List<AccessModifier> list = Collections.singletonList(PUBLIC);
                if (list == null) {
                    AccessModifier.$$$reportNull$$$0(9);
                }
                return list;
            }
            if (JavaPsiRecordUtil.isCompactConstructor(method) || JavaPsiRecordUtil.isExplicitCanonicalConstructor(method) || method instanceof LightRecordCanonicalConstructor) {
                PsiModifierList list = containingClass.getModifierList();
                if (list != null) {
                    AccessModifier classModifier = AccessModifier.fromModifierList(list);
                    List<AccessModifier> list2 = ContainerUtil.filter(ALL_MODIFIERS, m -> !classModifier.isWeaker((AccessModifier)((Object)m)));
                    if (list2 == null) {
                        AccessModifier.$$$reportNull$$$0(10);
                    }
                    return list2;
                }
                List<AccessModifier> list3 = Collections.singletonList(PUBLIC);
                if (list3 == null) {
                    AccessModifier.$$$reportNull$$$0(11);
                }
                return list3;
            }
            if (containingClass.isInterface()) {
                if (method.getBody() != null && PsiUtil.isLanguageLevel9OrHigher(member)) {
                    List<AccessModifier> list = PUBLIC_PRIVATE;
                    if (list == null) {
                        AccessModifier.$$$reportNull$$$0(12);
                    }
                    return list;
                }
                List<AccessModifier> list = Collections.singletonList(PUBLIC);
                if (list == null) {
                    AccessModifier.$$$reportNull$$$0(13);
                }
                return list;
            }
            AccessModifier minAccess = AccessModifier.getMinAccess(method);
            if (minAccess != PRIVATE) {
                List<AccessModifier> list = ContainerUtil.filter(ALL_MODIFIERS, mod -> mod.compareTo(minAccess) <= 0);
                if (list == null) {
                    AccessModifier.$$$reportNull$$$0(14);
                }
                return list;
            }
            List<AccessModifier> list = ALL_MODIFIERS;
            if (list == null) {
                AccessModifier.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (member instanceof PsiClass) {
            if (PsiUtil.isLocalOrAnonymousClass((PsiClass)member)) {
                List<AccessModifier> list = Collections.emptyList();
                if (list == null) {
                    AccessModifier.$$$reportNull$$$0(16);
                }
                return list;
            }
            if (containingClass == null) {
                List<AccessModifier> list = PUBLIC_PACKAGE;
                if (list == null) {
                    AccessModifier.$$$reportNull$$$0(17);
                }
                return list;
            }
            List<AccessModifier> list = ALL_MODIFIERS;
            if (list == null) {
                AccessModifier.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<AccessModifier> list = Collections.emptyList();
        if (list == null) {
            AccessModifier.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private static AccessModifier getMinAccess(PsiMethod method) {
        HierarchicalMethodSignature superSignature;
        PsiMethod superMethod;
        AccessModifier current;
        if (method.isConstructor() || method.hasModifierProperty("static")) {
            AccessModifier accessModifier = PRIVATE;
            if (accessModifier == null) {
                AccessModifier.$$$reportNull$$$0(20);
            }
            return accessModifier;
        }
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        AccessModifier lowest = PRIVATE;
        Iterator<HierarchicalMethodSignature> iterator2 = signature.getSuperSignatures().iterator();
        while (iterator2.hasNext() && (!(current = AccessModifier.fromModifierList((superMethod = (superSignature = iterator2.next()).getMethod()).getModifierList())).isWeaker(lowest) || method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod(superMethod, method) || !PsiUtil.isAccessible(method.getProject(), superMethod, method, null) || (lowest = current) != PUBLIC)) {
        }
        AccessModifier accessModifier = lowest;
        if (accessModifier == null) {
            AccessModifier.$$$reportNull$$$0(21);
        }
        return accessModifier;
    }

    static {
        ALL_MODIFIERS = Arrays.asList(AccessModifier.values());
        PUBLIC_PACKAGE = Arrays.asList(PUBLIC, PACKAGE_LOCAL);
        PUBLIC_PRIVATE = Arrays.asList(PUBLIC, PRIVATE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/AccessModifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/AccessModifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiModifier";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableModifiers";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasModifier";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isWeaker";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableModifiers";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

