/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.util.ui.EDT;
import java.awt.EventQueue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThreadingAssertions {
    public static void assertEventDispatchThread() {
        if (!EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.throwThreadAccessException("Access is allowed from Event Dispatch Thread (EDT) only");
        }
    }

    private static void throwThreadAccessException(@NotNull @NonNls String message) {
        if (message == null) {
            ThreadingAssertions.$$$reportNull$$$0(1);
        }
        throw ThreadingAssertions.createThreadAccessException(message);
    }

    @NotNull
    private static RuntimeExceptionWithAttachments createThreadAccessException(@NonNls @NotNull String message) {
        if (message == null) {
            ThreadingAssertions.$$$reportNull$$$0(2);
        }
        return new RuntimeExceptionWithAttachments(message + "; see " + "https://jb.gg/ij-platform-threading" + " for details\n" + ThreadingAssertions.getThreadDetails(), new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString()));
    }

    @NotNull
    private static String getThreadDetails() {
        Thread current = Thread.currentThread();
        Thread edt = EDT.getEventDispatchThread();
        String string2 = "Current thread: " + ThreadingAssertions.describe(current) + " (EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + ")\nSystemEventQueueThread: " + (edt == current ? "(same)" : ThreadingAssertions.describe(edt));
        if (string2 == null) {
            ThreadingAssertions.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    private static String describe(@Nullable Thread o) {
        String string2 = o == null ? "null" : o + " " + System.identityHashCode(o);
        if (string2 == null) {
            ThreadingAssertions.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadDetails";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "throwThreadAccessException";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createThreadAccessException";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

