/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.GitHistoryParser;
import org.opensolaris.opengrok.history.GitTagEntry;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.history.TagEntry;
import org.opensolaris.opengrok.util.Executor;

public class GitRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.git";
    public static final String CMD_FALLBACK = "git";
    private static final String BLAME = "blame";
    private static final int CSET_LEN = 8;
    private static final String ABBREV_LOG = "--abbrev=8";
    private static final String ABBREV_BLAME = "--abbrev=7";
    private static final Pattern BLAME_PATTERN = Pattern.compile("^\\W*(\\w+).+?\\((\\D+).*$");

    public GitRepository() {
        this.type = CMD_FALLBACK;
        this.datePattern = "EEE MMM dd hh:mm:ss yyyy ZZZZ";
    }

    private String getCorrectPath(String fileName, String revision) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        String path = "";
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add(BLAME);
        cmd.add("-c");
        cmd.add(ABBREV_LOG);
        cmd.add("-C");
        cmd.add(fileName);
        File directory = new File(this.directoryName);
        Executor exec = new Executor(cmd, directory);
        int status = exec.exec();
        if (status != 0) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get blame list in resolving correct path");
            return path;
        }
        try (BufferedReader in = new BufferedReader(exec.getOutputReader());){
            String pattern = "^\\W*" + revision + " (.+?) .*$";
            Pattern commitPattern = Pattern.compile(pattern);
            String line = "";
            Matcher matcher = commitPattern.matcher(line);
            while ((line = in.readLine()) != null) {
                matcher.reset(line);
                if (!matcher.find()) continue;
                path = matcher.group(1);
                break;
            }
        }
        return path;
    }

    Executor getHistoryLogExecutor(File file, String sinceRevision) throws IOException {
        String abs = file.getCanonicalPath();
        String filename = "";
        if (abs.length() > this.directoryName.length()) {
            filename = abs.substring(this.directoryName.length() + 1);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("log");
        cmd.add("--abbrev-commit");
        cmd.add(ABBREV_LOG);
        cmd.add("--name-only");
        cmd.add("--pretty=fuller");
        if (sinceRevision != null) {
            cmd.add(sinceRevision + "..");
        }
        if (filename.length() > 0) {
            cmd.add(filename);
        }
        return new Executor(cmd, new File(this.getDirectoryName()));
    }

    Reader newLogReader(InputStream input) throws IOException {
        return new InputStreamReader(input, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getHistoryGet(String parent, String basename, String rev) {
        ByteArrayInputStream ret = null;
        File directory = new File(this.directoryName);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        Process process = null;
        try {
            int len;
            String filename = new File(parent, basename).getCanonicalPath().substring(this.directoryName.length() + 1);
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            String[] argv = new String[]{this.cmd, "show", rev + ":" + filename};
            process = Runtime.getRuntime().exec(argv, null, directory);
            InputStream in = process.getInputStream();
            boolean error = true;
            while ((len = in.read(buffer)) != -1) {
                error = false;
                if (len <= 0) continue;
                output.write(buffer, 0, len);
            }
            if (error) {
                process.destroy();
                String path = this.getCorrectPath(filename, rev);
                argv[2] = rev + ":" + path;
                process = Runtime.getRuntime().exec(argv, null, directory);
                in = process.getInputStream();
                while ((len = in.read(buffer)) != -1) {
                    if (len <= 0) continue;
                    output.write(buffer, 0, len);
                }
            }
            ret = new ByteArrayInputStream(output.toByteArray());
        }
        catch (Exception exp) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get history: " + exp.getClass().toString(), exp);
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException exp) {
                    process.destroy();
                }
            }
        }
        return ret;
    }

    @Override
    public Annotation annotate(File file, String revision) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add(BLAME);
        cmd.add("-c");
        cmd.add(ABBREV_BLAME);
        if (revision != null) {
            cmd.add(revision);
        }
        cmd.add(file.getName());
        Executor exec = new Executor(cmd, file.getParentFile());
        int status = exec.exec();
        if (status != 0) {
            cmd.clear();
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            cmd.add(this.cmd);
            cmd.add(BLAME);
            cmd.add("-c");
            cmd.add(ABBREV_BLAME);
            cmd.add("-C");
            cmd.add(file.getName());
            exec = new Executor(cmd, file.getParentFile());
            status = exec.exec();
            if (status != 0) {
                OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get blame list");
            }
            try (BufferedReader in = new BufferedReader(exec.getOutputReader());){
                String pattern = "^\\W*" + revision + " (.+?) .*$";
                Pattern commitPattern = Pattern.compile(pattern);
                String line = "";
                Matcher matcher = commitPattern.matcher(line);
                while ((line = in.readLine()) != null) {
                    matcher.reset(line);
                    if (!matcher.find()) continue;
                    String filepath = matcher.group(1);
                    cmd.clear();
                    this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
                    cmd.add(this.cmd);
                    cmd.add(BLAME);
                    cmd.add("-c");
                    cmd.add(ABBREV_BLAME);
                    if (revision != null) {
                        cmd.add(revision);
                    }
                    cmd.add("--");
                    cmd.add(filepath);
                    File directory = new File(this.directoryName);
                    exec = new Executor(cmd, directory);
                    status = exec.exec();
                    if (status != 0) {
                        OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get blame details for modified file path");
                    }
                    break;
                }
            }
        }
        if (status != 0) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to get annotations for: \"{0}\" Exit code: {1}", new Object[]{file.getAbsolutePath(), String.valueOf(status)});
        }
        return this.parseAnnotation(this.newLogReader(exec.getOutputStream()), file.getName());
    }

    protected Annotation parseAnnotation(Reader input, String fileName) throws IOException {
        BufferedReader in = new BufferedReader(input);
        Annotation ret = new Annotation(fileName);
        String line = "";
        int lineno = 0;
        Matcher matcher = BLAME_PATTERN.matcher(line);
        while ((line = in.readLine()) != null) {
            ++lineno;
            matcher.reset(line);
            if (matcher.find()) {
                String rev = matcher.group(1);
                String author = matcher.group(2).trim();
                ret.addLine(rev, author, true);
                continue;
            }
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Error: did not find annotation in line {0}: [{1}] of {2}", new Object[]{String.valueOf(lineno), line, fileName});
        }
        return ret;
    }

    @Override
    public boolean fileHasAnnotation(File file) {
        return true;
    }

    @Override
    public void update() throws IOException {
        File directory = new File(this.getDirectoryName());
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("config");
        cmd.add("--list");
        Executor executor = new Executor(cmd, directory);
        if (executor.exec() != 0) {
            throw new IOException(executor.getErrorString());
        }
        if (executor.getOutputString().indexOf("remote.origin.url=") != -1) {
            cmd.clear();
            cmd.add(this.cmd);
            cmd.add("pull");
            cmd.add("-n");
            cmd.add("-q");
            if (executor.exec() != 0) {
                throw new IOException(executor.getErrorString());
            }
        }
    }

    @Override
    public boolean fileHasHistory(File file) {
        return true;
    }

    @Override
    boolean isRepositoryFor(File file) {
        if (file.isDirectory()) {
            File f = new File(file, ".git");
            return f.exists() && f.isDirectory();
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        if (this.working == null) {
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            this.working = GitRepository.checkCmd(this.cmd, "--help");
        }
        return this.working;
    }

    @Override
    boolean hasHistoryForDirectories() {
        return true;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return this.getHistory(file, null);
    }

    @Override
    History getHistory(File file, String sinceRevision) throws HistoryException {
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        History result = new GitHistoryParser().parse(file, this, sinceRevision);
        if (env.isTagsEnabled()) {
            this.assignTagsInHistory(result);
        }
        return result;
    }

    @Override
    boolean hasFileBasedTags() {
        return true;
    }

    private TagEntry buildTagEntry(File directory, String tags) throws HistoryException, IOException {
        String hash = null;
        Date date = null;
        ArrayList<String> argv = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("log");
        argv.add("--format=commit:%H" + System.getProperty("line.separator") + "Date:%at");
        argv.add("-r");
        argv.add(tags + "^.." + tags);
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb.directory(directory);
        Process process = null;
        process = pb.start();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                String[] parts;
                if (line.startsWith("commit")) {
                    parts = line.split(":");
                    if (parts.length < 2) {
                        throw new HistoryException("Tag line contains more than 2 columns: " + line);
                    }
                    hash = parts[1];
                }
                if (!line.startsWith("Date")) continue;
                parts = line.split(":");
                if (parts.length < 2) {
                    throw new HistoryException("Tag line contains more than 2 columns: " + line);
                }
                date = new Date((long)Integer.parseInt(parts[1]) * 1000L);
            }
        }
        if (process != null) {
            try {
                process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                process.destroy();
            }
        }
        if (date == null) {
            date = new Date(0L);
        }
        GitTagEntry result = new GitTagEntry(hash, date, tags);
        return result;
    }

    @Override
    protected void buildTagList(File directory) {
        this.tagList = new TreeSet();
        ArrayList<String> argv = new ArrayList<String>();
        LinkedList<String> tagsList = new LinkedList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("tag");
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb.directory(directory);
        Process process = null;
        try {
            process = pb.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    tagsList.add(line);
                }
            }
        }
        catch (IOException e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to read tag list: {0}", e.getMessage());
            this.tagList = null;
        }
        if (process != null) {
            try {
                process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                process.destroy();
            }
        }
        try {
            for (String tags : tagsList) {
                TagEntry tagEntry = this.buildTagEntry(directory, tags);
                this.tagList.add(tagEntry);
            }
        }
        catch (HistoryException e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to parse tag list: {0}", e.getMessage());
            this.tagList = null;
        }
        catch (IOException e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to read tag list: {0}", e.getMessage());
            this.tagList = null;
        }
    }
}

