/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as g,html as l,nothing as u}from"lit";import{property as f,state as b,customElement as h}from"lit/decorators.js";import{until as v}from"lit/directives/until.js";import"@typo3/backend/element/spinner-element.js";import"@typo3/backend/element/icon-element.js";import{copyToClipboard as $}from"@typo3/backend/copy-to-clipboard.js";import w from"@typo3/backend/notification.js";import{lll as m}from"@typo3/core/lit-helper.js";import{markdown as k}from"@typo3/core/directive/markdown.js";import S from"@typo3/core/ajax/ajax-request.js";import{SettingsMode as y,sanitizeSettingsMode as E}from"@typo3/backend/settings/enum/settings-mode.enum.js";var c=function(p,t,n,i){var e=arguments.length,s=e<3?t:i===null?i=Object.getOwnPropertyDescriptor(t,n):i,a;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")s=Reflect.decorate(p,t,n,i);else for(var o=p.length-1;o>=0;o--)(a=p[o])&&(s=(e<3?a(s):e>3?a(t,n,s):a(t,n))||s);return e>3&&s&&Object.defineProperty(t,n,s),s};let d=class extends g{constructor(){super(...arguments),this.mode=y.basic,this.hasChange=!1,this.typeElement=null}createRenderRoot(){return this}render(){const{value:t,systemDefault:n,definition:i}=this.setting;return l`<div class=${`settings-item settings-item-${i.type} ${this.hasChange?"has-change":""}`} tabindex=0 data-status=${JSON.stringify(t)===JSON.stringify(n)?"none":"modified"}><div class=settings-item-indicator></div><div class=settings-item-title><label for=${`setting-${i.key}`} class=settings-item-label>${i.label}</label><div class=settings-item-description>${k(i.description??"","minimal")}</div>${this.mode===y.advanced?l`<div class=settings-item-key>${i.key}</div>`:u}</div><div class=settings-item-control>${v(this.renderField(),l`<typo3-backend-spinner></typo3-backend-spinner>`)}</div><div class=settings-item-message></div><div class=settings-item-actions>${this.renderActions()}</div></div>`}async renderField(){const{definition:t,value:n,typeImplementation:i}=this.setting;let e=this.typeElement;if(!e){const o=await import(i);if(!("componentName"in o))throw new Error(`module ${i} is missing the "componentName" export`);e=document.createElement(o.componentName),this.typeElement=e,e.addEventListener("typo3:setting:changed",r=>{this.hasChange=JSON.stringify(this.setting.value)!==JSON.stringify(r.detail.value)})}const s=Object.entries(t.enum||{}),a={key:t.key,formid:`setting-${t.key}`,name:`settings[${t.key}]`,value:Array.isArray(n)?JSON.stringify(n):String(n),debug:this.mode===y.advanced,readonly:t.readonly,enum:s.length>0?JSON.stringify(Object.fromEntries(s)):!1,default:Array.isArray(t.default)?JSON.stringify(t.default):String(t.default)};for(const[o,r]of Object.entries(a)){if(typeof r=="boolean"){r&&!e.hasAttribute(o)&&e.setAttribute(o,""),!r&&e.hasAttribute(o)&&e.removeAttribute(o);continue}e.getAttribute(o)!==r&&e.setAttribute(o,r)}return e}renderActions(){const{definition:t}=this.setting;return l`<div class=dropdown><button class=dropdown-toggle type=button data-bs-toggle=dropdown aria-expanded=false><typo3-backend-icon identifier=actions-cog size=small></typo3-backend-icon><span class=visually-hidden>More actions</span></button><ul class=dropdown-menu><li><button class="dropdown-item dropdown-item-spaced" type=button ?disabled=${t.readonly} @click=${()=>this.setToDefaultValue()}><typo3-backend-icon identifier=actions-undo size=small></typo3-backend-icon>${m("settingseditor.edit.resetSetting")}</button></li>${this.mode===y.advanced?l`<li><hr class=dropdown-divider></li><li><typo3-copy-to-clipboard text=${t.key} class="dropdown-item dropdown-item-spaced"><typo3-backend-icon identifier=actions-clipboard size=small></typo3-backend-icon>${m("settingseditor.edit.copySettingsIdentifier")}</typo3-copy-to-clipboard></li>${this.dumpuri?l`<li><button class="dropdown-item dropdown-item-spaced" type=button @click=${()=>this.copyAsYaml()}><typo3-backend-icon identifier=actions-clipboard-paste size=small></typo3-backend-icon>${m("settingseditor.edit.copyAsYaml")}</button></li>`:u}`:u}</ul></div>`}setToDefaultValue(){this.typeElement&&(this.typeElement.value=this.setting.systemDefault)}async copyAsYaml(){const t=new FormData(this.typeElement.form),n=`settings[${this.setting.definition.key}]`,i=t.get(n),e=new FormData;e.append("specificSetting",this.setting.definition.key),e.append(n,i);const a=await(await new S(this.dumpuri).post(e)).resolve();typeof a.yaml=="string"?$(a.yaml):(console.warn("Value can not be copied to clipboard.",typeof a.yaml),w.error(m("copyToClipboard.error")))}};c([f({type:Object})],d.prototype,"setting",void 0),c([f({type:String})],d.prototype,"dumpuri",void 0),c([f({type:String,converter:E})],d.prototype,"mode",void 0),c([b()],d.prototype,"hasChange",void 0),d=c([h("typo3-backend-editable-setting")],d);export{d as EditableSettingElement};
