'''OpenGL extension EXT.discard_framebuffer

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.discard_framebuffer to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a new command, DiscardFramebufferEXT, which 
	causes the contents of the named framebuffer attachable images to become 
	undefined.  The contents of the specified buffers are undefined until a 
	subsequent operation modifies the content, and only the modified region 
	is guaranteed to hold valid content.  Effective usage of this command 
	may provide an implementation with new optimization opportunities.
	
	Some OpenGL ES implementations cache framebuffer images in a small pool 
	of fast memory.  Before rendering, these implementations must load the
	existing contents of one or more of the logical buffers (color, depth, 
	stencil, etc.) into this memory.  After rendering, some or all of these 
	buffers are likewise stored back to external memory so their contents can
	be used again in the future.  In many applications, some or all of the 
	logical buffers  are cleared at the start of rendering.  If so, the 
	effort to load or store those buffers is wasted.
	
	Even without this extension, if a frame of rendering begins with a full-
	screen Clear, an OpenGL ES implementation may optimize away the loading
	of framebuffer contents prior to rendering the frame.  With this extension, 
	an application can use DiscardFramebufferEXT to signal that framebuffer 
	contents will no longer be needed.  In this case an OpenGL ES 
	implementation may also optimize away the storing back of framebuffer 
	contents after rendering the frame.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/discard_framebuffer.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.discard_framebuffer import *
from OpenGL.raw.GLES2.EXT.discard_framebuffer import _EXTENSION_NAME

def glInitDiscardFramebufferEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glDiscardFramebufferEXT.attachments size not checked against numAttachments
glDiscardFramebufferEXT=wrapper.wrapper(glDiscardFramebufferEXT).setInputArraySize(
    'attachments', None
)
### END AUTOGENERATED SECTION