/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;

public class DecimalFormatManager
implements Serializable {
    private DecimalSymbols defaultDFS;
    private HashMap<StructuredQName, DecimalSymbols> formatTable = new HashMap(10);

    public DecimalFormatManager() {
        this.defaultDFS = new DecimalSymbols();
    }

    public DecimalSymbols getDefaultDecimalFormat() {
        return this.defaultDFS;
    }

    public DecimalSymbols getNamedDecimalFormat(StructuredQName qName) {
        DecimalSymbols ds = this.formatTable.get(qName);
        if (ds == null) {
            return null;
        }
        return ds;
    }

    public DecimalSymbols obtainNamedDecimalFormat(StructuredQName qName) {
        DecimalSymbols ds = this.formatTable.get(qName);
        if (ds == null) {
            ds = new DecimalSymbols();
            this.formatTable.put(qName, ds);
        }
        return ds;
    }

    public void checkConsistency() throws XPathException {
        this.defaultDFS.checkConsistency(null);
        for (Map.Entry<StructuredQName, DecimalSymbols> entry : this.formatTable.entrySet()) {
            entry.getValue().checkConsistency(entry.getKey());
        }
    }
}

