/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.util;

public class MemoryDiagnostics
implements Runnable {
    Thread t = new Thread(this);
    private volatile boolean shutdown = false;
    private static int sleepTimeMills = 10000;

    public MemoryDiagnostics() {
        this.t.setName("MemoryDiagnosticsThread");
        this.t.start();
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            this.printMemoryUsage();
            this.gc();
            try {
                Thread.sleep(sleepTimeMills);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void printMemoryUsage() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long max = Runtime.getRuntime().maxMemory();
        System.out.println("MemoryDiagnostics.printMemoryUsage: Total=" + total);
        System.out.println("MemoryDiagnostics.printMemoryUsage: Free=" + free);
        System.out.println("MemoryDiagnostics.printMemoryUsage: Max=" + max);
        if (total > max / 2L) {
            System.out.println("Memory allocation > 50%, running GC");
            this.gc();
        }
    }

    public void gc() {
        System.gc();
    }

    public void shutdown() {
        this.t.interrupt();
    }
}

