/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel.completions;

import java.util.Collections;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParserLogger;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SQLCompletion;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SQLSchema;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLStatement;

public class SQLTable
extends SQLCompletion {
    public String catalog;
    public String schema;
    public String name;
    public String alias;
    private SQLStatement statement;

    public SQLTable(SQLStatement statement, int start) {
        super(start);
        ParserLogger.log("SQLTable: " + start);
        this.statement = statement;
    }

    public SQLTable(SQLStatement statement, int start, int end) {
        super(start);
        ParserLogger.log("SQLTable: " + start + " " + end);
        this.statement = statement;
        this.setEndPosition(end);
    }

    public SQLStatement getStatement() {
        return this.statement;
    }

    public void setCatalog(String catalog, int pos) {
        this.catalog = catalog;
        this.setEndPosition(pos + catalog.length() - 1);
    }

    public void setSchema(String schema, int pos) {
        this.schema = schema;
        this.setEndPosition(pos + schema.length() - 1);
    }

    public void setName(String name, int pos) {
        this.name = name;
        this.setEndPosition(pos + name.length() - 1);
    }

    public void setAlias(String alias, int pos) {
        this.alias = alias;
        this.setEndPosition(pos + alias.length() - 1);
    }

    public SQLSchema.Table[] getCompletions(int position) {
        String tb = this.name != null && position > this.startPosition ? this.name.substring(0, position - this.startPosition) : null;
        List<SQLSchema.Table> tables = this.getStatement().getTables(this.catalog, this.schema, tb);
        Collections.sort(tables);
        return tables.toArray(new SQLSchema.Table[tables.size()]);
    }

    @Override
    protected boolean isConcrete() {
        return this.name != null;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public boolean mustReplace(int position) {
        return this.name != null && position >= this.startPosition && position <= this.endPosition;
    }

    @Override
    public String getText(int position, String option) {
        return option;
    }
}

