/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.GraphMainPanelTab;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.link.CopyGraphAction;
import net.sourceforge.squirrel_sql.plugins.graph.window.GraphWindowControllerListener;

public class GraphWindowController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GraphWindowController.class);
    private ISession _session;
    private GraphPlugin _plugin;
    private GraphMainPanelTab _graphMainPanelTab;
    private int _tabIdx;
    private GraphWindowControllerListener _listener;
    private boolean _link;
    private JCheckBox _chkStayOnTop;
    private JButton _btnReturn;
    private JButton _btnRemove;
    private JButton _btnCopyGraph;
    private JPanel _contentPanel;
    private JDialog _dlgWindow;
    private JFrame _frameWindow;
    private SessionAdapter _sessionAdapter;
    private WindowAdapter _windowAdapter;

    public GraphWindowController(ISession session, GraphPlugin plugin, GraphMainPanelTab graphMainPanelTab, int tabIdx, Rectangle tabBoundsOnScreen, GraphWindowControllerListener listener, boolean link) {
        this._session = session;
        this._plugin = plugin;
        this._graphMainPanelTab = graphMainPanelTab;
        this._tabIdx = tabIdx;
        this._listener = listener;
        this._link = link;
        this._contentPanel = new JPanel(new BorderLayout());
        this._contentPanel.add((Component)this.createTopPanel(), "North");
        this._contentPanel.add(graphMainPanelTab.getComponent(), "Center");
        this._sessionAdapter = new SessionAdapter(){

            public void sessionClosing(SessionEvent evt) {
                GraphWindowController.this.onSessionClosing(evt);
            }
        };
        this._session.getApplication().getSessionManager().addSessionListener((ISessionListener)this._sessionAdapter);
        this._windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GraphWindowController.this.onWindowClosing();
            }
        };
        this.showDialogWindow(tabBoundsOnScreen, this.createTitle(graphMainPanelTab));
        this._chkStayOnTop.setSelected(true);
        this._chkStayOnTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphWindowController.this.onStayOnTopChanged();
            }
        });
        this._btnReturn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphWindowController.this.onReturn();
            }
        });
        this._btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphWindowController.this.onRemove();
            }
        });
        this._btnCopyGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphWindowController.this.onCopyGraph();
            }
        });
    }

    private void onCopyGraph() {
        CopyGraphAction.copyGraph(this._plugin.getGraphControllerForMainTab(this._graphMainPanelTab, this._session));
    }

    private String createTitle(GraphMainPanelTab graphMainPanelTab) {
        String ret = graphMainPanelTab.getTitle();
        if (this._link) {
            ret = ret + " " + s_stringMgr.getString("graph.link.linkTitlePostfix");
        }
        return ret;
    }

    private void onSessionClosing(SessionEvent evt) {
        if (evt.getSession() == this._session) {
            this.close();
            this._session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this._sessionAdapter);
        }
    }

    private void showDialogWindow(Rectangle bounds, String title) {
        if (null != this._frameWindow) {
            title = this._frameWindow.getTitle();
            bounds = this._frameWindow.getBounds();
            Point locOnScreen = this._frameWindow.getLocationOnScreen();
            bounds.x = locOnScreen.x;
            bounds.y = locOnScreen.y;
            this._frameWindow.setVisible(false);
            this._frameWindow.removeWindowListener(this._windowAdapter);
            this._frameWindow.getContentPane().removeAll();
            this._frameWindow.dispose();
            this._frameWindow = null;
        }
        Frame owningFrame = GUIUtils.getOwningFrame((Component)this._session.getObjectTreeAPIOfActiveSessionWindow().getDetailTabComp());
        this._dlgWindow = new JDialog(owningFrame);
        this._dlgWindow.setTitle(title);
        this._dlgWindow.getContentPane().setLayout(new GridLayout(1, 1));
        this._dlgWindow.getContentPane().add(this._contentPanel);
        this._dlgWindow.setBounds(bounds);
        this._dlgWindow.addWindowListener(this._windowAdapter);
        this._dlgWindow.setVisible(true);
    }

    private void showFrameWindow(Rectangle bounds, String title) {
        if (null != this._dlgWindow) {
            title = this._dlgWindow.getTitle();
            bounds = this._dlgWindow.getBounds();
            Point locOnScreen = this._dlgWindow.getLocationOnScreen();
            bounds.x = locOnScreen.x;
            bounds.y = locOnScreen.y;
            this._dlgWindow.setVisible(false);
            this._dlgWindow.removeWindowListener(this._windowAdapter);
            this._dlgWindow.getContentPane().removeAll();
            this._dlgWindow.dispose();
            this._dlgWindow = null;
        }
        ImageIcon appIcon = this._session.getApplication().getResources().getIcon("AppIcon");
        this._frameWindow = new JFrame();
        this._frameWindow.setTitle(title);
        this._frameWindow.setIconImage(appIcon.getImage());
        this._frameWindow.getContentPane().setLayout(new GridLayout(1, 1));
        this._frameWindow.getContentPane().add(this._contentPanel);
        this._frameWindow.setBounds(bounds);
        this._frameWindow.addWindowListener(this._windowAdapter);
        this._frameWindow.setVisible(true);
    }

    private void onReturn() {
        this.close();
        this.onWindowClosing();
    }

    private void onRemove() {
        this._graphMainPanelTab.removeGraph();
    }

    void close() {
        if (null != this._dlgWindow) {
            this._dlgWindow.setVisible(false);
            this._dlgWindow.dispose();
        } else if (null != this._frameWindow) {
            this._frameWindow.setVisible(false);
            this._frameWindow.dispose();
        }
    }

    private void onStayOnTopChanged() {
        if (this._chkStayOnTop.isSelected()) {
            this.showDialogWindow(null, null);
        } else {
            this.showFrameWindow(null, null);
        }
    }

    private JPanel createTopPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._chkStayOnTop = new JCheckBox(s_stringMgr.getString("graph.window.stayOnTop"));
        ret.add((Component)this._chkStayOnTop, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._btnReturn = new JButton(s_stringMgr.getString("graph.window.return"));
        ret.add((Component)this._btnReturn, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._btnRemove = new JButton(s_stringMgr.getString("graph.window.removeGraph"));
        ret.add((Component)this._btnRemove, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._btnCopyGraph = new JButton(s_stringMgr.getString("graph.window.copyGraph"));
        this._btnCopyGraph.setToolTipText(s_stringMgr.getString("graph.window.copyGraphToolTip"));
        this._btnCopyGraph.setIcon(new GraphPluginResources((IPlugin)this._plugin).getIcon("copyGraph"));
        ret.add((Component)this._btnCopyGraph, gbc);
        gbc = new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        return ret;
    }

    private void onWindowClosing() {
        this._listener.closing(this._tabIdx);
    }

    public void rename(String newName) {
        if (null != this._dlgWindow) {
            this._dlgWindow.setTitle(newName);
        } else {
            this._frameWindow.setTitle(newName);
        }
    }

    public void returnToTab() {
        this.onReturn();
    }

    public Component getComponent() {
        if (null != this._dlgWindow) {
            return this._dlgWindow;
        }
        if (null != this._frameWindow) {
            return this._frameWindow;
        }
        throw new IllegalStateException("Neiterh window nor dialog");
    }

    public void changedFromLinkToLocalCopy() {
        this._link = false;
        this._graphMainPanelTab.changedFromLinkToLocalCopy();
        if (null != this._dlgWindow) {
            this._dlgWindow.setTitle(this.createTitle(this._graphMainPanelTab));
        } else {
            this._frameWindow.setTitle(this.createTitle(this._graphMainPanelTab));
        }
    }
}

