/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix.gateway;

import com.zabbix.gateway.ZabbixException;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BinaryProtocolSpeaker {
    private static final Logger logger = LoggerFactory.getLogger(BinaryProtocolSpeaker.class);
    private static final byte[] PROTOCOL_HEADER = new byte[]{90, 66, 88, 68, 1};
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private Socket socket;
    private DataInputStream dis = null;
    private BufferedOutputStream bos = null;

    BinaryProtocolSpeaker(Socket socket) {
        this.socket = socket;
    }

    String getRequest() throws IOException, ZabbixException {
        this.dis = new DataInputStream(this.socket.getInputStream());
        logger.debug("reading Zabbix protocol header");
        byte[] byArray = new byte[5];
        this.dis.readFully(byArray);
        if (!Arrays.equals(byArray, PROTOCOL_HEADER)) {
            throw new ZabbixException("bad protocol header: %02X %02X %02X %02X %02X", byArray[0], byArray[1], byArray[2], byArray[3], byArray[4]);
        }
        logger.debug("reading 8 bytes of data length");
        byArray = new byte[8];
        this.dis.readFully(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long l = byteBuffer.getLong();
        if (0L > l || l > Integer.MAX_VALUE) {
            throw new ZabbixException("bad data length: %d", l);
        }
        logger.debug("reading {} bytes of request data", (Object)l);
        byArray = new byte[(int)l];
        this.dis.readFully(byArray);
        String string = new String(byArray, UTF8_CHARSET);
        logger.debug("received the following data in request: {}", (Object)string);
        return string;
    }

    void sendResponse(String string) throws IOException, ZabbixException {
        this.bos = new BufferedOutputStream(this.socket.getOutputStream());
        logger.debug("sending the following data in response: {}", (Object)string);
        byte[] byArray = PROTOCOL_HEADER;
        this.bos.write(byArray, 0, byArray.length);
        byte[] byArray2 = string.getBytes(UTF8_CHARSET);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong(byArray2.length);
        byArray = byteBuffer.array();
        this.bos.write(byArray, 0, byArray.length);
        byArray = byArray2;
        this.bos.write(byArray, 0, byArray.length);
        this.bos.flush();
    }

    void close() {
        try {
            if (null != this.dis) {
                this.dis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (null != this.bos) {
                this.bos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (null != this.socket) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

