/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.typo3;

import java.io.BufferedReader;
import java.util.regex.Matcher;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.typo3.Typo3Dialect;
import org.omegat.util.OStrings;

public class Typo3Filter
extends XMLFilter {
    public Typo3Filter() {
        super(new Typo3Dialect());
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("TYPO3_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.xml", null, null)};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public boolean isFileSupported(BufferedReader reader) {
        XMLDialect dialect = this.getDialect();
        if (dialect.getConstraints() == null || dialect.getConstraints().isEmpty()) {
            return true;
        }
        try {
            char[] cbuf = new char[65536];
            int cbufLen = reader.read(cbuf);
            String buf = new String(cbuf, 0, cbufLen);
            Matcher matcher = Typo3Dialect.TYPO3_ROOT_TAG.matcher(buf);
            if (matcher.find()) {
                return true;
            }
            matcher = Typo3Dialect.TYPO3_ROOT_TAG2.matcher(buf);
            if (!matcher.find()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

