/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.common;

import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.common.EntryInfoPane;

public abstract class EntryInfoThreadPane<T>
extends EntryInfoPane<T>
implements IEntryEventListener {
    protected volatile SourceTextEntry currentlyProcessedEntry;

    public EntryInfoThreadPane(boolean useApplicationFont) {
        super(useApplicationFont);
        CoreEvents.registerEntryEventListener(this);
    }

    @Override
    public void onNewFile(String activeFileName) {
        this.currentlyProcessedEntry = null;
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        this.currentlyProcessedEntry = newEntry;
        this.startSearchThread(newEntry);
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case CREATE: 
            case LOAD: {
                this.currentlyProcessedEntry = null;
                this.onProjectOpen();
                break;
            }
            case CLOSE: {
                this.currentlyProcessedEntry = null;
                this.onProjectClose();
                break;
            }
        }
    }

    protected abstract void startSearchThread(SourceTextEntry var1);

    protected abstract void setFoundResult(SourceTextEntry var1, T var2);

    protected void setError(Exception ex) {
    }
}

