/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.List;
import java.util.Locale;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.omegat.core.Core;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;
import org.omegat.util.Token;

public final class EditorUtils {
    private EditorUtils() {
    }

    public static int getWordStart(JTextComponent c, int offs) throws BadLocationException {
        int result = Utilities.getWordStart(c, offs);
        char ch = c.getDocument().getText(result, 1).charAt(0);
        if (EditorUtils.isDirectionChar(ch)) {
            ++result;
        }
        return result;
    }

    public static int getWordEnd(JTextComponent c, int offs) throws BadLocationException {
        char ch;
        int result = Utilities.getWordEnd(c, offs);
        if (result > 0 && EditorUtils.isDirectionChar(ch = c.getDocument().getText(result - 1, 1).charAt(0))) {
            --result;
        }
        return result;
    }

    private static boolean isDirectionChar(char ch) {
        return ch == '\u202a' || ch == '\u202b' || ch == '\u202c' || ch == '\u200e' || ch == '\u200f';
    }

    public static String removeDirectionChars(String text) {
        return text.replaceAll("[\u202a\u202b\u202c\u200e\u200f]", "");
    }

    public static String removeDirectionCharsAroundTags(String text, SourceTextEntry ste) {
        for (ProtectedPart pp : ste.getProtectedParts()) {
            int pos = -1;
            while ((pos = ((String)text).indexOf(pp.getTextInSourceSegment(), pos + 1)) >= 0) {
                if (!EditorUtils.hasBidiAroundTag((String)text, pp.getTextInSourceSegment(), pos)) continue;
                text = ((String)text).substring(0, pos - 2) + pp.getTextInSourceSegment() + ((String)text).substring(pos + pp.getTextInSourceSegment().length() + 2);
            }
        }
        return text;
    }

    public static String doChangeCase(String input, IEditor.CHANGE_CASE_TO toWhat) {
        Locale locale = Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
        ITokenizer tokenizer = Core.getProject().getTargetTokenizer();
        return EditorUtils.doChangeCase(input, toWhat, locale, tokenizer);
    }

    public static String doChangeCase(String input, IEditor.CHANGE_CASE_TO toWhat, Locale locale, ITokenizer tokenizer) {
        Token[] tokenList = tokenizer.tokenizeVerbatim(input);
        if (toWhat == IEditor.CHANGE_CASE_TO.CYCLE) {
            int lower = 0;
            int upper = 0;
            int title = 0;
            int ambiguous = 0;
            int mixed = 0;
            for (Token token : tokenList) {
                String word = token.getTextFromString(input);
                if (!EditorUtils.canChangeTokenCase(word)) continue;
                if (StringUtil.isLowerCase(word)) {
                    ++lower;
                    continue;
                }
                boolean isTitle = StringUtil.isTitleCase(word);
                boolean isUpper = StringUtil.isUpperCase(word);
                if (isTitle && isUpper) {
                    ++ambiguous;
                    continue;
                }
                if (isTitle) {
                    ++title;
                    continue;
                }
                if (isUpper) {
                    ++upper;
                    continue;
                }
                if (!StringUtil.isMixedCase(word)) continue;
                ++mixed;
            }
            if (lower == 0 && title == 0 && upper == 0 && mixed == 0 && ambiguous == 0) {
                return input;
            }
            toWhat = EditorUtils.determineTargetCase(lower, upper, title, mixed, ambiguous);
        }
        StringBuilder buffer = new StringBuilder(input);
        int lengthIncrement = 0;
        for (Token token : tokenList) {
            String result;
            String tokText = token.getTextFromString(input);
            if (!EditorUtils.canChangeTokenCase(tokText)) continue;
            if (toWhat == IEditor.CHANGE_CASE_TO.LOWER) {
                result = tokText.toLowerCase(locale);
            } else if (toWhat == IEditor.CHANGE_CASE_TO.UPPER) {
                result = tokText.toUpperCase(locale);
            } else if (toWhat == IEditor.CHANGE_CASE_TO.TITLE) {
                result = StringUtil.toTitleCase(tokText, locale);
            } else if (toWhat == IEditor.CHANGE_CASE_TO.SENTENCE) {
                result = StringUtil.toTitleCase(tokText, locale);
                toWhat = IEditor.CHANGE_CASE_TO.LOWER;
            } else {
                result = tokText;
            }
            buffer.replace(token.getOffset() + lengthIncrement, token.getLength() + token.getOffset() + lengthIncrement, result);
            lengthIncrement += result.length() - token.getLength();
        }
        return buffer.toString();
    }

    private static boolean canChangeTokenCase(String token) {
        return Character.isLetter(token.codePointAt(0));
    }

    private static IEditor.CHANGE_CASE_TO determineTargetCase(int lower, int upper, int title, int mixed, int ambiguous) {
        int presentCaseTypes = 0;
        if (lower > 0) {
            ++presentCaseTypes;
        }
        if (upper > 0) {
            ++presentCaseTypes;
        }
        if (title > 0) {
            ++presentCaseTypes;
        }
        if (mixed > 0) {
            ++presentCaseTypes;
        }
        if ((title > 0 || ambiguous > 0) && lower > 0 && upper == 0 && mixed == 0) {
            return IEditor.CHANGE_CASE_TO.TITLE;
        }
        if (mixed > 0 || presentCaseTypes > 1) {
            return IEditor.CHANGE_CASE_TO.UPPER;
        }
        if (lower > 0) {
            return IEditor.CHANGE_CASE_TO.SENTENCE;
        }
        if (title > 0) {
            return IEditor.CHANGE_CASE_TO.UPPER;
        }
        if (upper > 0) {
            return IEditor.CHANGE_CASE_TO.LOWER;
        }
        if (ambiguous > 0) {
            return IEditor.CHANGE_CASE_TO.LOWER;
        }
        return IEditor.CHANGE_CASE_TO.UPPER;
    }

    public static String replaceGlossaryEntries(String text) {
        Locale locale = Core.getProject().getProjectProperties().getSourceLanguage().getLocale();
        ITokenizer tokenizer = Core.getProject().getSourceTokenizer();
        return EditorUtils.replaceGlossaryEntries(text, Core.getGlossaryManager().getGlossaryEntries(text), locale, tokenizer);
    }

    public static String replaceGlossaryEntries(String text, List<GlossaryEntry> entries, Locale locale, ITokenizer tokenizer) {
        if (StringUtil.isEmpty(text) || entries == null || entries.isEmpty()) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        String[] haystack = tokenizer.tokenizeVerbatimToStrings(text);
        for (int i = 0; i < haystack.length; ++i) {
            String tok = haystack[i];
            boolean replaced = false;
            for (GlossaryEntry e : entries) {
                String[] needle = tokenizer.tokenizeVerbatimToStrings(e.getSrcText());
                if (!EditorUtils.tokensPresentAt(needle, haystack, i, true)) continue;
                String toAppend = e.getLocText();
                if (!EditorUtils.tokensPresentAt(needle, haystack, i, false)) {
                    toAppend = StringUtil.matchCapitalization(toAppend, tok, locale);
                }
                sb.append(toAppend);
                replaced = true;
                i += needle.length - 1;
                break;
            }
            if (replaced) continue;
            sb.append(tok);
        }
        return sb.toString();
    }

    private static boolean tokensPresentAt(String[] needle, String[] haystack, int offset, boolean ignoreCase) {
        if (offset < 0 || offset + needle.length > haystack.length) {
            return false;
        }
        for (int i = 0; i < needle.length; ++i) {
            String hayToken = haystack[i + offset];
            String needleToken = needle[i];
            if (!(ignoreCase ? !hayToken.equalsIgnoreCase(needleToken) : !hayToken.equals(needleToken))) continue;
            return false;
        }
        return true;
    }

    public static String addBidiAroundTags(String text, SourceTextEntry ste) {
        List<TagUtil.Tag> tags = TagUtil.buildTagList(text, ste.getProtectedParts());
        int pos = 0;
        StringBuilder s = new StringBuilder(text.length() * 12 / 10);
        for (TagUtil.Tag t : tags) {
            if (pos < t.pos) {
                s.append(text.substring(pos, t.pos));
            }
            s.append('\u200f');
            s.append('\u200e');
            s.append(t.tag);
            s.append('\u200e');
            s.append('\u200f');
            pos = t.pos + t.tag.length();
        }
        if (pos < text.length()) {
            s.append(text.substring(pos));
        }
        return s.toString();
    }

    public static boolean hasBidiAroundTag(String text, String tag, int pos) {
        try {
            boolean has = true;
            if (text.charAt(pos - 1) != '\u200e' || text.charAt(pos - 2) != '\u200f') {
                has = false;
            }
            if (text.charAt(pos + tag.length()) != '\u200e' || text.charAt(pos + tag.length() + 1) != '\u200f') {
                has = false;
            }
            return has;
        }
        catch (StringIndexOutOfBoundsException ex) {
            return false;
        }
    }
}

