/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.tools.MultiKeyProperties;
import org.languagetool.tools.StringTools;

public final class Languages {
    private static final List<Language> LANGUAGES = Languages.getAllLanguages();
    private static final String PROPERTIES_PATH = "META-INF/org/languagetool/language-module.properties";
    private static final String PROPERTIES_KEY = "languageClasses";

    private Languages() {
    }

    public static List<Language> get() {
        ArrayList<Language> result = new ArrayList<Language>();
        for (Language lang : LANGUAGES) {
            if ("xx".equals(lang.getShortName())) continue;
            result.add(lang);
        }
        return Collections.unmodifiableList(result);
    }

    public static List<Language> getWithDemoLanguage() {
        return LANGUAGES;
    }

    private static List<Language> getAllLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        HashSet<String> languageClassNames = new HashSet<String>();
        try {
            Enumeration<URL> propertyFiles = Language.class.getClassLoader().getResources(PROPERTIES_PATH);
            while (propertyFiles.hasMoreElements()) {
                URL url = propertyFiles.nextElement();
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    MultiKeyProperties props = new MultiKeyProperties(inputStream);
                    List<String> classNamesStr = props.getProperty(PROPERTIES_KEY);
                    if (classNamesStr == null) {
                        throw new RuntimeException("Key 'languageClasses' not found in " + url);
                    }
                    for (String classNames : classNamesStr) {
                        String[] classNamesSplit;
                        for (String className : classNamesSplit = classNames.split("\\s*,\\s*")) {
                            if (languageClassNames.contains(className)) continue;
                            languages.add(Languages.createLanguageObjects(url, className));
                            languageClassNames.add(className);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(languages);
    }

    private static Language createLanguageObjects(URL url, String className) {
        try {
            Class<?> aClass = Class.forName(className);
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            return (Language)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class '" + className + "' specified in " + url + " could not be found in classpath", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Object for class '" + className + "' specified in " + url + " could not created", e);
        }
    }

    @Nullable
    public static Language getLanguageForName(String languageName) {
        for (Language element : LANGUAGES) {
            if (!languageName.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public static Language getLanguageForShortName(String langCode) {
        Language language = Languages.getLanguageForShortNameOrNull(langCode);
        if (language == null) {
            ArrayList<String> codes = new ArrayList<String>();
            for (Language realLanguage : LANGUAGES) {
                codes.add(realLanguage.getShortNameWithCountryAndVariant());
            }
            Collections.sort(codes);
            throw new IllegalArgumentException("'" + langCode + "' is not a language code known to LanguageTool." + " Supported language codes are: " + StringUtils.join(codes, (String)", ") + ". The list of languages is read from " + PROPERTIES_PATH + " in the Java classpath. See http://wiki.languagetool.org/java-api for details.");
        }
        return language;
    }

    public static boolean isLanguageSupported(String langCode) {
        return Languages.getLanguageForShortNameOrNull(langCode) != null;
    }

    public static Language getLanguageForLocale(Locale locale) {
        Language language = Languages.getLanguageForLanguageNameAndCountry(locale);
        if (language != null) {
            return language;
        }
        Language firstFallbackLanguage = Languages.getLanguageForLanguageNameOnly(locale);
        if (firstFallbackLanguage != null) {
            return firstFallbackLanguage;
        }
        for (Language aLanguage : LANGUAGES) {
            if (!aLanguage.getShortNameWithCountryAndVariant().equals("en-US")) continue;
            return aLanguage;
        }
        throw new RuntimeException("No appropriate language found, not even en-US. Supported languages: " + Languages.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Language getLanguageForShortNameOrNull(String langCode) {
        Language element;
        StringTools.assureSet(langCode, "langCode");
        Language result = null;
        if (langCode.contains("-x-")) {
            Language element2;
            Iterator<Language> iterator = LANGUAGES.iterator();
            do {
                if (!iterator.hasNext()) return result;
            } while (!(element2 = iterator.next()).getShortName().equalsIgnoreCase(langCode));
            return element2;
        }
        if (langCode.contains("-")) {
            Language element3;
            String[] parts = langCode.split("-");
            if (parts.length == 2) {
                Language element4;
                Iterator<Language> element2 = LANGUAGES.iterator();
                do {
                    if (!element2.hasNext()) return result;
                } while (!parts[0].equalsIgnoreCase((element4 = element2.next()).getShortName()) || element4.getCountries().length != 1 || !parts[1].equalsIgnoreCase(element4.getCountries()[0]));
                return element4;
            }
            if (parts.length != 3) throw new IllegalArgumentException("'" + langCode + "' isn't a valid language code");
            Iterator<Language> element2 = LANGUAGES.iterator();
            do {
                if (!element2.hasNext()) return result;
            } while (!parts[0].equalsIgnoreCase((element3 = element2.next()).getShortName()) || element3.getCountries().length != 1 || !parts[1].equalsIgnoreCase(element3.getCountries()[0]) || !parts[2].equalsIgnoreCase(element3.getVariant()));
            return element3;
        }
        Iterator<Language> iterator = LANGUAGES.iterator();
        do {
            if (!iterator.hasNext()) return result;
        } while (!langCode.equalsIgnoreCase((element = iterator.next()).getShortName()));
        return element;
    }

    @Nullable
    private static Language getLanguageForLanguageNameAndCountry(Locale locale) {
        for (Language language : LANGUAGES) {
            List<String> countryVariants;
            if (!language.getShortName().equals(locale.getLanguage()) || !(countryVariants = Arrays.asList(language.getCountries())).contains(locale.getCountry())) continue;
            return language;
        }
        return null;
    }

    @Nullable
    private static Language getLanguageForLanguageNameOnly(Locale locale) {
        for (Language language : LANGUAGES) {
            Language defaultVariant;
            if (!language.getShortName().equals(locale.getLanguage()) || !language.hasVariant() || (defaultVariant = language.getDefaultLanguageVariant()) == null) continue;
            return defaultVariant;
        }
        for (Language language : LANGUAGES) {
            if (!language.getShortName().equals(locale.getLanguage()) || language.hasVariant()) continue;
            return language;
        }
        return null;
    }
}

