/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.cliffc.high_scale_lib.NonBlockingHashtable;

public class Hashtable<K, V>
extends NonBlockingHashtable<K, V> {
    private static final long serialVersionUID = 1421746759512286392L;
    private final float loadFactor = 0.75f;
    private int threshold = 3;

    public Hashtable() {
    }

    public Hashtable(int initialCapacity) {
        super(initialCapacity);
    }

    public Hashtable(int initialCapacity, float loadFactor) {
        super(initialCapacity);
        if (!(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public Hashtable(Map<? extends K, ? extends V> t) {
        this.putAll(t);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Hashtable t = (Hashtable)this.clone();
        s.defaultWriteObject();
        s.writeInt((int)((float)t.size() / 0.75f));
        s.writeInt(t.size());
        for (Object K : this.keySet()) {
            Object V = this.get(K);
            s.writeObject(K);
            s.writeObject(V);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initialize();
        int origlength = s.readInt();
        int elements = s.readInt();
        for (int i = 0; i < elements; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }
}

