/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.authenticator;

import java.security.Principal;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.ClusterValve;
import org.apache.catalina.cluster.authenticator.ClusterSingleSignOnListener;
import org.apache.catalina.cluster.authenticator.SingleSignOnMessage;

public class ClusterSingleSignOn
extends SingleSignOn
implements ClusterValve {
    protected static String info = "org.apache.catalina.cluster.authenticator.ClusterSingleSignOn/1.0";
    protected int messageNumber = 0;
    private ClusterSingleSignOnListener clusterSSOListener = null;
    private CatalinaCluster cluster = null;

    public String getInfo() {
        return info;
    }

    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    public void start() throws LifecycleException {
        super.start();
        this.clusterSSOListener = new ClusterSingleSignOnListener();
        this.clusterSSOListener.setClusterSSO(this);
        try {
            Container host;
            CatalinaCluster cluster = this.getCluster();
            if (cluster == null && (host = this.getContainer()) != null && host instanceof Host) {
                cluster = host.getCluster();
                if (cluster != null && cluster instanceof CatalinaCluster) {
                    this.setCluster(cluster);
                } else {
                    Container engine = host.getParent();
                    if (engine != null && engine instanceof Engine) {
                        cluster = engine.getCluster();
                        if (cluster != null && cluster instanceof CatalinaCluster) {
                            this.setCluster(cluster);
                        }
                    } else {
                        cluster = null;
                    }
                }
            }
            if (cluster == null) {
                throw new LifecycleException("There is no Cluster for ClusterSingleSignOn");
            }
            cluster.addClusterListener(this.clusterSSOListener);
        }
        catch (Throwable t) {
            throw new LifecycleException("ClusterSingleSignOn exception during clusterLoad " + t);
        }
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.getCluster() != null && this.getCluster() instanceof CatalinaCluster) {
            this.getCluster().removeClusterListener(this.clusterSSOListener);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ClusterSingleSignOn[");
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    protected void associate(String ssoId, Session session) {
        boolean addSession = true;
        SingleSignOnEntry entry = this.lookup(ssoId);
        if (entry != null) {
            boolean bl = addSession = !entry.sessionExists(session);
        }
        if (addSession) {
            this.sendSSOId(ssoId, session, 1);
            this.associateLocal(ssoId, session);
        }
    }

    protected void associateLocal(String ssoId, Session session) {
        super.associate(ssoId, session);
    }

    protected void deregister(String ssoId, Session session) {
        this.sendSSOId(ssoId, session, 2);
        this.deregisterLocal(ssoId, session);
    }

    protected void deregisterLocal(String ssoId, Session session) {
        super.deregister(ssoId, session);
    }

    protected void deregister(String ssoId) {
        this.sendSSOId(ssoId, null, 3);
        this.deregisterLocal(ssoId);
    }

    protected void deregisterLocal(String ssoId) {
        super.deregister(ssoId);
    }

    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        this.sendSSOIdWithAuth(ssoId, authType, username, password, 4);
        this.registerLocal(ssoId, principal, authType, username, password);
    }

    protected void registerLocal(String ssoId, Principal principal, String authType, String username, String password) {
        super.register(ssoId, principal, authType, username, password);
    }

    protected void update(String ssoId, Principal principal, String authType, String username, String password) {
        this.sendSSOIdWithAuth(ssoId, authType, username, password, 5);
        this.updateLocal(ssoId, principal, authType, username, password);
    }

    protected void updateLocal(String ssoId, Principal principal, String authType, String username, String password) {
        super.update(ssoId, principal, authType, username, password);
    }

    protected void removeSession(String ssoId, Session session) {
        this.sendSSOId(ssoId, session, 6);
        this.removeSessionLocal(ssoId, session);
    }

    protected void removeSessionLocal(String ssoId, Session session) {
        super.removeSession(ssoId, session);
    }

    protected void sendSSOId(String ssoId, Session session, int action) {
        if (this.cluster != null) {
            Manager mgr;
            ++this.messageNumber;
            String sessionId = null;
            if (session != null) {
                sessionId = session.getId();
            }
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, sessionId);
            if (session != null && (mgr = session.getManager()) != null && mgr instanceof ClusterManager) {
                msg.setContextName(((ClusterManager)mgr).getName());
            }
            this.send(msg, action);
        }
    }

    protected void sendSSOIdWithAuth(String ssoId, String authType, String username, String password, int action) {
        if (this.cluster != null) {
            ++this.messageNumber;
            SingleSignOnMessage msg = new SingleSignOnMessage(this.cluster.getLocalMember(), ssoId, null);
            msg.setAuthType(authType);
            msg.setUsername(username);
            msg.setPassword(password);
            this.send(msg, action);
        }
    }

    protected void send(SingleSignOnMessage msg, int action) {
        msg.setAction(action);
        this.cluster.sendClusterDomain(msg);
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("SingleSignOnMessage Send with action " + action));
        }
    }
}

