/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.event;

import java.awt.AWTEvent;
import java.awt.Component;
import java.util.Map;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.event.Event;

public class DockingEvent
extends Event {
    public static final int DRAG_STARTED = 0;
    public static final int DROP_STARTED = 1;
    public static final int DOCKING_COMPLETE = 2;
    public static final int DOCKING_CANCELED = 3;
    public static final int UNDOCKING_COMPLETE = 4;
    public static final int UNDOCKING_STARTED = 5;
    private DockingPort oldPort;
    private DockingPort newPort;
    private boolean consumed;
    private AWTEvent trigger;
    private String region;
    private boolean overWindow;
    private Map dragContext;

    public DockingEvent(Dockable source, DockingPort oldPort, DockingPort newPort, int eventType, Map context) {
        this(source, oldPort, newPort, eventType, null, context);
    }

    public DockingEvent(Dockable source, DockingPort oldPort, DockingPort newPort, int eventType, AWTEvent trigger, Map context) {
        super(source, eventType);
        this.oldPort = oldPort;
        this.newPort = newPort;
        this.trigger = trigger;
        this.region = "UNKNOWN";
        this.dragContext = context;
        this.setOverWindow(true);
    }

    public DockingPort getOldDockingPort() {
        return this.oldPort;
    }

    public DockingPort getNewDockingPort() {
        return this.newPort;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void consume() {
        this.consumed = true;
    }

    public AWTEvent getTrigger() {
        return this.trigger;
    }

    public void setTrigger(AWTEvent trigger) {
        this.trigger = trigger;
    }

    public Object getTriggerSource() {
        return this.trigger == null ? null : this.trigger.getSource();
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        if (!DockingManager.isValidDockingRegion(region)) {
            region = "UNKNOWN";
        }
        this.region = region;
    }

    public boolean isOverWindow() {
        return this.overWindow;
    }

    public void setOverWindow(boolean overWindow) {
        this.overWindow = overWindow;
    }

    public Dockable getDockable() {
        return (Dockable)this.getSource();
    }

    public Component getComponent() {
        return this.getDockable().getComponent();
    }

    public Map getDragContext() {
        return this.dragContext;
    }
}

