/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.mac;

import gnu.crypto.mac.BaseMac;
import gnu.crypto.prng.LimitReachedException;
import gnu.crypto.prng.UMacGenerator;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

public class UHash32
extends BaseMac {
    private static final BigInteger PRIME_19 = BigInteger.valueOf(524287L);
    private static final BigInteger PRIME_32 = BigInteger.valueOf(0xFFFFFFFBL);
    private static final BigInteger PRIME_36 = BigInteger.valueOf(0xFFFFFFFFBL);
    private static final BigInteger PRIME_64 = new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -59});
    private static final BigInteger PRIME_128 = new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 97});
    static final BigInteger TWO = BigInteger.valueOf(2);
    static final long BOUNDARY = TWO.shiftLeft(17).longValue();
    static final BigInteger LOWER_RANGE = TWO.pow(64).subtract(TWO.pow(32));
    static final BigInteger UPPER_RANGE = TWO.pow(128).subtract(TWO.pow(96));
    static final byte[] ALL_ZEROES = new byte[32];
    int streams;
    L1Hash32[] l1hash;

    public UHash32() {
        super("uhash32");
    }

    private UHash32(UHash32 that) {
        this();
        this.streams = that.streams;
        if (that.l1hash != null) {
            this.l1hash = new L1Hash32[that.streams];
            for (int i = 0; i < that.streams; ++i) {
                if (that.l1hash[i] == null) continue;
                this.l1hash[i] = (L1Hash32)that.l1hash[i].clone();
            }
        }
    }

    static final BigInteger prime(int n) {
        switch (n) {
            case 19: {
                return PRIME_19;
            }
            case 32: {
                return PRIME_32;
            }
            case 36: {
                return PRIME_36;
            }
            case 64: {
                return PRIME_64;
            }
            case 128: {
                return PRIME_128;
            }
        }
        throw new IllegalArgumentException("Undefined prime(" + String.valueOf(n) + ")");
    }

    public Object clone() {
        return new UHash32(this);
    }

    public int macSize() {
        return 8;
    }

    public void init(Map attributes) throws InvalidKeyException, IllegalStateException {
        byte[] K = (byte[])attributes.get("gnu.crypto.mac.key.material");
        if (K == null) {
            throw new InvalidKeyException("Null Key");
        }
        if (K.length != 16) {
            throw new InvalidKeyException("Invalid Key length: " + String.valueOf(K.length));
        }
        this.streams = 2;
        UMacGenerator kdf1 = new UMacGenerator();
        UMacGenerator kdf2 = new UMacGenerator();
        UMacGenerator kdf3 = new UMacGenerator();
        UMacGenerator kdf4 = new UMacGenerator();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gnu.crypto.cipher.key.material", K);
        map.put("gnu.crypto.prng.umac.index", new Integer(0));
        kdf1.init(map);
        map.put("gnu.crypto.prng.umac.index", new Integer(1));
        kdf2.init(map);
        map.put("gnu.crypto.prng.umac.index", new Integer(2));
        kdf3.init(map);
        map.put("gnu.crypto.prng.umac.index", new Integer(3));
        kdf4.init(map);
        byte[] L1Key = new byte[1024 + (this.streams - 1) * 16];
        try {
            kdf1.nextBytes(L1Key, 0, L1Key.length);
        }
        catch (LimitReachedException x) {
            x.printStackTrace(System.err);
            throw new RuntimeException("KDF for L1Key reached limit");
        }
        this.l1hash = new L1Hash32[this.streams];
        for (int i = 0; i < this.streams; ++i) {
            byte[] k1 = new byte[1024];
            System.arraycopy(L1Key, i * 16, k1, 0, 1024);
            byte[] k2 = new byte[24];
            try {
                kdf2.nextBytes(k2, 0, 24);
            }
            catch (LimitReachedException x) {
                x.printStackTrace(System.err);
                throw new RuntimeException("KDF for L2Key reached limit");
            }
            byte[] k31 = new byte[64];
            try {
                kdf3.nextBytes(k31, 0, 64);
            }
            catch (LimitReachedException x) {
                x.printStackTrace(System.err);
                throw new RuntimeException("KDF for L3Key1 reached limit");
            }
            byte[] k32 = new byte[4];
            try {
                kdf4.nextBytes(k32, 0, 4);
            }
            catch (LimitReachedException x) {
                x.printStackTrace(System.err);
                throw new RuntimeException("KDF for L3Key2 reached limit");
            }
            L1Hash32 mac = new L1Hash32(this);
            mac.init(k1, k2, k31, k32);
            this.l1hash[i] = mac;
        }
    }

    public void update(byte b) {
        for (int i = 0; i < this.streams; ++i) {
            this.l1hash[i].update(b);
        }
    }

    public void update(byte[] b, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            this.update(b[offset + i]);
        }
    }

    public byte[] digest() {
        byte[] result = new byte[8];
        for (int i = 0; i < this.streams; ++i) {
            byte[] partialResult = this.l1hash[i].digest();
            System.arraycopy(partialResult, 0, result, 4 * i, 4);
        }
        this.reset();
        return result;
    }

    public void reset() {
        for (int i = 0; i < this.streams; ++i) {
            this.l1hash[i].reset();
        }
    }

    public boolean selfTest() {
        return true;
    }

    class L3Hash32
    implements Cloneable {
        private /* synthetic */ UHash32 this$0;
        private static final long PRIME_36 = 0xFFFFFFFFBL;
        private int[] k;

        private /* synthetic */ void finit$() {
            this.k = new int[9];
        }

        L3Hash32(UHash32 this$0, byte[] K1, byte[] K2) {
            this.this$0 = this$0;
            this.finit$();
            if (K1.length != 64) {
                throw new ExceptionInInitializerError("K1 length is not 64");
            }
            if (K2.length != 4) {
                throw new ExceptionInInitializerError("K2 length is not 4");
            }
            int j = 0;
            for (int i = 0; i < 8; ++i) {
                long kk = ((long)K1[j++] & (long)255) << 56 | ((long)K1[j++] & (long)255) << 48 | ((long)K1[j++] & (long)255) << 40 | ((long)K1[j++] & (long)255) << 32 | ((long)K1[j++] & (long)255) << 24 | ((long)K1[j++] & (long)255) << 16 | ((long)K1[j++] & (long)255) << 8 | (long)K1[j++] & (long)255;
                this.k[i] = (int)(kk % 0xFFFFFFFFBL);
            }
            this.k[8] = K2[0] << 24 | (K2[1] & 0xFF) << 16 | (K2[2] & 0xFF) << 8 | K2[3] & 0xFF;
        }

        private L3Hash32(UHash32 this$0, int[] k) {
            this.this$0 = this$0;
            this.finit$();
            this.k = k;
        }

        public Object clone() {
            return new L3Hash32(this.this$0, (int[])this.k.clone());
        }

        byte[] digest(byte[] M) {
            if (M.length != 16) {
                throw new IllegalArgumentException("M length is not 16");
            }
            long y = 0L;
            int j = 0;
            for (int i = 0; i < 8; ++i) {
                long m = ((long)M[j++] & (long)255) << 8 | (long)M[j++] & (long)255;
                y += m * ((long)this.k[i] & 0xFFFFFFFFL) % 0xFFFFFFFFBL;
            }
            int Y = (int)y ^ this.k[8];
            return new byte[]{(byte)(Y >>> 24), (byte)(Y >>> 16), (byte)(Y >>> 8), (byte)Y};
        }
    }

    class L2Hash32
    implements Cloneable {
        private /* synthetic */ UHash32 this$0;
        private BigInteger k64;
        private BigInteger k128;
        private BigInteger y;
        private boolean highBound;
        private long bytesSoFar;
        private ByteArrayOutputStream buffer;

        L2Hash32(UHash32 this$0, byte[] K) {
            this.this$0 = this$0;
            if (K.length != 24) {
                throw new ExceptionInInitializerError("K length is not 24");
            }
            int i = 0;
            this.k64 = new BigInteger(1, new byte[]{K[i++] & 1, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF, K[i++] & 1, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF});
            this.k128 = new BigInteger(1, new byte[]{K[i++] & 1, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF, K[i++] & 1, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF, K[i++] & 1, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF, K[i++] & 1, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF, K[i++] & 0xFFFFFFFF});
            this.y = BigInteger.ONE;
            this.highBound = false;
            this.bytesSoFar = 0L;
        }

        private L2Hash32(UHash32 this$0, L2Hash32 that) {
            this.this$0 = this$0;
            this.k64 = that.k64;
            this.k128 = that.k128;
            this.y = that.y;
            this.highBound = that.highBound;
            this.bytesSoFar = that.bytesSoFar;
            if (that.buffer != null) {
                byte[] thatbuffer = that.buffer.toByteArray();
                this.buffer = new ByteArrayOutputStream();
                this.buffer.write(thatbuffer, 0, thatbuffer.length);
            }
        }

        public Object clone() {
            return new L2Hash32(this.this$0, this);
        }

        void update(byte[] b, int offset, int len) {
            if (len == 0) {
                return;
            }
            if (!this.highBound) {
                this.poly(64, LOWER_RANGE, this.k64, b, offset, 8);
                this.bytesSoFar += (long)8;
                boolean bl = this.highBound = this.bytesSoFar > BOUNDARY;
                if (this.highBound) {
                    this.poly(128, UPPER_RANGE, this.k128, this.yTo16bytes(), 0, 16);
                    this.buffer = new ByteArrayOutputStream();
                }
                this.update(b, offset + 8, len - 8);
            } else {
                this.buffer.write(b, offset, len);
                if (this.buffer.size() > 16) {
                    byte[] bb = this.buffer.toByteArray();
                    this.poly(128, UPPER_RANGE, this.k128, bb, 0, 16);
                    if (bb.length > 16) {
                        this.buffer.write(bb, 16, bb.length - 16);
                    }
                }
            }
        }

        byte[] digest() {
            if (this.highBound) {
                byte[] bb = this.buffer.toByteArray();
                byte[] lastBlock = new byte[16];
                System.arraycopy(bb, 0, lastBlock, 0, bb.length);
                lastBlock[bb.length] = -128;
                this.poly(128, UPPER_RANGE, this.k128, lastBlock, 0, 16);
            }
            byte[] result = this.yTo16bytes();
            this.reset();
            return result;
        }

        void reset() {
            this.y = BigInteger.ONE;
            this.highBound = false;
            this.bytesSoFar = 0L;
            if (this.buffer != null) {
                this.buffer.reset();
            }
        }

        private byte[] yTo16bytes() {
            byte[] yy = this.y.toByteArray();
            byte[] result = new byte[16];
            if (yy.length > 16) {
                System.arraycopy(yy, yy.length - 16, result, 0, 16);
            } else {
                System.arraycopy(yy, 0, result, 16 - yy.length, yy.length);
            }
            return result;
        }

        private void poly(int wordbits, BigInteger maxwordrange, BigInteger k, byte[] M, int off, int len) {
            byte[] mag = new byte[len];
            System.arraycopy(M, off, mag, 0, len);
            BigInteger p = UHash32.prime(wordbits);
            BigInteger offset = TWO.pow(wordbits).subtract(p);
            BigInteger marker = p.subtract(BigInteger.ONE);
            BigInteger m = new BigInteger(1, mag);
            if (m.compareTo(maxwordrange) >= 0) {
                this.y = this.y.multiply(k).add(marker).mod(p);
                this.y = this.y.multiply(k).add(m.subtract(offset)).mod(p);
            } else {
                this.y = this.y.multiply(k).add(m).mod(p);
            }
        }
    }

    class L1Hash32
    implements Cloneable {
        private /* synthetic */ UHash32 this$0;
        private int[] key;
        private byte[] buffer;
        private int count;
        private ByteArrayOutputStream Y;
        private long totalCount;
        private L2Hash32 l2hash;
        private L3Hash32 l3hash;

        L1Hash32(UHash32 this$0) {
            this.this$0 = this$0;
            this.key = new int[256];
            this.buffer = new byte[1024];
            this.count = 0;
            this.Y = new ByteArrayOutputStream();
            this.totalCount = 0L;
        }

        private L1Hash32(UHash32 this$0, L1Hash32 that) {
            this.this$0 = this$0;
            this(this$0);
            System.arraycopy(that.key, 0, this.key, 0, that.key.length);
            System.arraycopy(that.buffer, 0, this.buffer, 0, that.count);
            this.count = that.count;
            byte[] otherY = that.Y.toByteArray();
            this.Y.write(otherY, 0, otherY.length);
            this.totalCount = that.totalCount;
            if (that.l2hash != null) {
                this.l2hash = (L2Hash32)that.l2hash.clone();
            }
            if (that.l3hash != null) {
                this.l3hash = (L3Hash32)that.l3hash.clone();
            }
        }

        public Object clone() {
            return new L1Hash32(this.this$0, this);
        }

        public void init(byte[] k1, byte[] k2, byte[] k31, byte[] k32) {
            int j = 0;
            for (int i = 0; i < 256; ++i) {
                this.key[i] = k1[j++] << 24 | (k1[j++] & 0xFF) << 16 | (k1[j++] & 0xFF) << 8 | k1[j++] & 0xFF;
            }
            this.l2hash = new L2Hash32(this.this$0, k2);
            this.l3hash = new L3Hash32(this.this$0, k31, k32);
        }

        public void update(byte b) {
            this.buffer[this.count] = b;
            ++this.count;
            ++this.totalCount;
            if (this.count >= 1024) {
                byte[] y = this.nh32(1024);
                this.Y.write(y, 0, 8);
                this.count = 0;
                if (this.Y.size() == 16) {
                    byte[] A = this.Y.toByteArray();
                    this.Y.reset();
                    this.l2hash.update(A, 0, 16);
                }
            }
        }

        public byte[] digest() {
            byte[] B;
            if (this.count != 0) {
                if (this.count % 32 != 0) {
                    int limit = 32 * ((this.count + 31) / 32);
                    System.arraycopy(ALL_ZEROES, 0, this.buffer, this.count, limit - this.count);
                    this.count += limit - this.count;
                }
                byte[] y = this.nh32(this.count);
                this.Y.write(y, 0, 8);
            }
            byte[] A = this.Y.toByteArray();
            this.Y.reset();
            if (this.totalCount <= (long)1024) {
                if (A.length == 0) {
                    B = this.l2hash.digest();
                } else {
                    B = new byte[16];
                    System.arraycopy(A, 0, B, 8, 8);
                }
            } else {
                if (A.length != 0) {
                    this.l2hash.update(A, 0, A.length);
                }
                B = this.l2hash.digest();
            }
            byte[] result = this.l3hash.digest(B);
            this.reset();
            return result;
        }

        public void reset() {
            this.count = 0;
            this.Y.reset();
            this.totalCount = 0L;
            if (this.l2hash != null) {
                this.l2hash.reset();
            }
        }

        private byte[] nh32(int len) {
            int i;
            int t = len / 4;
            int[] m = new int[t];
            int j = 0;
            j = 0;
            for (i = 0; i < t; ++i) {
                m[i] = this.buffer[j++] << 24 | (this.buffer[j++] & 0xFF) << 16 | (this.buffer[j++] & 0xFF) << 8 | this.buffer[j++] & 0xFF;
            }
            long result = (long)len * (long)8;
            for (i = 0; i < t; i += 8) {
                result += ((long)(m[i + 0] + this.key[i + 0]) & 0xFFFFFFFFL) * ((long)(m[i + 4] + this.key[i + 4]) & 0xFFFFFFFFL);
                result += ((long)(m[i + 1] + this.key[i + 1]) & 0xFFFFFFFFL) * ((long)(m[i + 5] + this.key[i + 5]) & 0xFFFFFFFFL);
                result += ((long)(m[i + 2] + this.key[i + 2]) & 0xFFFFFFFFL) * ((long)(m[i + 6] + this.key[i + 6]) & 0xFFFFFFFFL);
                result += ((long)(m[i + 3] + this.key[i + 3]) & 0xFFFFFFFFL) * ((long)(m[i + 7] + this.key[i + 7]) & 0xFFFFFFFFL);
            }
            return new byte[]{(byte)(result >>> 56), (byte)(result >>> 48), (byte)(result >>> 40), (byte)(result >>> 32), (byte)(result >>> 24), (byte)(result >>> 16), (byte)(result >>> 8), (byte)result};
        }
    }
}

