/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHLHSPrimaryExpression;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHUnaryExpression
extends SimpleNode
implements ParserConstants {
    public int kind;
    public boolean postfix = false;

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        if (simpleNode instanceof BSHLHSPrimaryExpression) {
            return this.lhsUnaryOperation(((BSHLHSPrimaryExpression)simpleNode).toLHS(callStack, interpreter));
        }
        return this.unaryOperation(simpleNode.eval(callStack, interpreter), this.kind);
    }

    private final Object lhsUnaryOperation(LHS lHS) throws EvalError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("lhsUnaryOperation");
        }
        Object object = lHS.getValue();
        Object object2 = this.unaryOperation(object, this.kind);
        Object object3 = this.postfix ? object : object2;
        lHS.assign(object2);
        return object3;
    }

    private final Object unaryOperation(Object object, int n) throws EvalError {
        if (object instanceof Boolean || object instanceof Character || object instanceof Number) {
            return this.primitiveWrapperUnaryOperation(object, n);
        }
        if (!(object instanceof Primitive)) {
            throw new EvalError("Unary operation " + ParserConstants.tokenImage[n] + " inappropriate for object", this);
        }
        return Primitive.unaryOperation((Primitive)object, n);
    }

    private final Object primitiveWrapperUnaryOperation(Object object, int n) throws EvalError {
        Class<?> clazz = object.getClass();
        Object object2 = Primitive.promoteToInteger(object);
        if (object2 instanceof Boolean) {
            return new Boolean(Primitive.booleanUnaryOperation((Boolean)object2, n));
        }
        if (object2 instanceof Integer) {
            int n2 = Primitive.intUnaryOperation((Integer)object2, n);
            if (n == 89 || n == 90) {
                if (clazz == Byte.TYPE) {
                    return new Byte((byte)n2);
                }
                if (clazz == Short.TYPE) {
                    return new Short((short)n2);
                }
                if (clazz == Character.TYPE) {
                    return new Character((char)n2);
                }
            }
            return new Integer(n2);
        }
        if (object2 instanceof Long) {
            return new Long(Primitive.longUnaryOperation((Long)object2, n));
        }
        if (object2 instanceof Float) {
            return new Float(Primitive.floatUnaryOperation((Float)object2, n));
        }
        if (object2 instanceof Double) {
            return new Double(Primitive.doubleUnaryOperation((Double)object2, n));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }

    BSHUnaryExpression(int n) {
        super(n);
    }
}

